/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.metrics;

import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.CumulativeCount;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.WindowedCount;

public class ShareRebalanceMetricsManager {
    private final String metricGroupName;
    private final Sensor rebalanceSensor;
    public final MetricName rebalanceTotal;
    public final MetricName rebalanceRatePerHour;
    private long lastRebalanceStartMs = -1L;

    public ShareRebalanceMetricsManager(Metrics metrics) {
        this.metricGroupName = "consumer-share-coordinator-metrics";
        this.rebalanceTotal = this.createMetric(metrics, "rebalance-total", "The total number of rebalance events");
        this.rebalanceRatePerHour = this.createMetric(metrics, "rebalance-rate-per-hour", "The number of rebalance events per hour");
        this.rebalanceSensor = metrics.sensor("rebalance-latency");
        this.rebalanceSensor.add(this.rebalanceTotal, new CumulativeCount());
        this.rebalanceSensor.add(this.rebalanceRatePerHour, new Rate(TimeUnit.HOURS, new WindowedCount()));
    }

    private MetricName createMetric(Metrics metrics, String name2, String description) {
        return metrics.metricName(name2, this.metricGroupName, description);
    }

    public void recordRebalanceStarted(long nowMs) {
        this.lastRebalanceStartMs = nowMs;
    }

    public void recordRebalanceEnded(long nowMs) {
        this.rebalanceSensor.record(nowMs - this.lastRebalanceStartMs);
    }
}

