/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Objects;

public class ClassLoaderUtils {
    private static final URL[] EMPTY_URL_ARRAY = new URL[0];

    public static URL[] getSystemURLs() {
        return ClassLoaderUtils.getURLs(ClassLoader.getSystemClassLoader());
    }

    public static URL[] getThreadURLs() {
        return ClassLoaderUtils.getURLs(Thread.currentThread().getContextClassLoader());
    }

    private static URL[] getURLs(ClassLoader cl) {
        return cl instanceof URLClassLoader ? ((URLClassLoader)cl).getURLs() : EMPTY_URL_ARRAY;
    }

    public static String toString(ClassLoader classLoader2) {
        if (classLoader2 instanceof URLClassLoader) {
            return ClassLoaderUtils.toString((URLClassLoader)classLoader2);
        }
        return Objects.toString(classLoader2);
    }

    public static String toString(URLClassLoader classLoader2) {
        return classLoader2 != null ? classLoader2 + Arrays.toString(classLoader2.getURLs()) : "null";
    }
}

