/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.avro.AvroTypeException;
import org.apache.avro.NameValidator;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.apache.avro.SchemaParser;
import org.apache.avro.util.SchemaResolver;
import org.apache.avro.util.Schemas;

public class ParseContext {
    private static final Map<String, Schema.Type> PRIMITIVES = new HashMap<String, Schema.Type>();
    private static final Set<Schema.Type> NAMED_SCHEMA_TYPES;
    private final Map<String, Schema> oldSchemas;
    private final Map<String, Schema> newSchemas;
    final NameValidator nameValidator;
    private SchemaResolver.ResolvingVisitor resolvingVisitor;

    public ParseContext() {
        this(NameValidator.UTF_VALIDATOR);
    }

    public ParseContext(NameValidator nameValidator) {
        this(Objects.requireNonNull(nameValidator), new LinkedHashMap<String, Schema>(), new LinkedHashMap<String, Schema>());
    }

    private ParseContext(NameValidator nameValidator, Map<String, Schema> oldSchemas, Map<String, Schema> newSchemas) {
        this.nameValidator = nameValidator;
        this.oldSchemas = oldSchemas;
        this.newSchemas = newSchemas;
        this.resolvingVisitor = null;
    }

    public boolean contains(String name2) {
        return PRIMITIVES.containsKey(name2) || this.oldSchemas.containsKey(name2) || this.newSchemas.containsKey(name2);
    }

    public Schema find(String name2, String namespace) {
        Schema.Type type = PRIMITIVES.get(name2);
        if (type != null) {
            return Schema.create(type);
        }
        String fullName = this.fullName(name2, namespace);
        Schema schema = this.getNamedSchema(fullName);
        if (schema == null) {
            schema = this.getNamedSchema(name2);
        }
        return schema != null ? schema : SchemaResolver.unresolvedSchema(fullName);
    }

    private String fullName(String name2, String namespace) {
        if (namespace != null && name2.lastIndexOf(46) < 0) {
            return namespace + "." + name2;
        }
        return name2;
    }

    public Schema getNamedSchema(String fullName) {
        Schema schema = this.oldSchemas.get(fullName);
        if (schema == null) {
            schema = this.newSchemas.get(fullName);
        }
        return schema;
    }

    public void put(Schema schema) {
        if (!NAMED_SCHEMA_TYPES.contains((Object)schema.getType())) {
            throw new AvroTypeException("You can only put a named schema into the context");
        }
        String fullName = this.requireValidFullName(schema.getFullName());
        Schema alreadyKnownSchema = this.oldSchemas.get(fullName);
        if (alreadyKnownSchema != null) {
            if (!schema.equals(alreadyKnownSchema)) {
                throw new SchemaParseException("Can't redefine: " + fullName);
            }
        } else {
            this.resolvingVisitor = null;
            Schema previouslyAddedSchema = this.newSchemas.putIfAbsent(fullName, schema);
            if (previouslyAddedSchema != null && !previouslyAddedSchema.equals(schema)) {
                throw new SchemaParseException("Can't redefine: " + fullName);
            }
        }
    }

    private String requireValidFullName(String fullName) {
        String[] names = fullName.split("\\.");
        for (int i = 0; i < names.length - 1; ++i) {
            this.validateName(names[i], "Namespace part");
        }
        this.validateName(names[names.length - 1], "Name");
        return fullName;
    }

    private void validateName(String name2, String typeOfName) {
        NameValidator.Result result2 = this.nameValidator.validate(name2);
        if (!result2.isOK()) {
            throw new SchemaParseException(typeOfName + " \"" + name2 + "\" is invalid: " + result2.getErrors());
        }
    }

    public boolean hasNewSchemas() {
        return !this.newSchemas.isEmpty();
    }

    public void commit() {
        this.oldSchemas.putAll(this.newSchemas);
        this.newSchemas.clear();
    }

    public SchemaParser.ParseResult commit(final Schema mainSchema) {
        final Collection<Schema> parsedNamedSchemas = this.newSchemas.values();
        SchemaParser.ParseResult parseResult = new SchemaParser.ParseResult(){

            @Override
            public Schema mainSchema() {
                return mainSchema == null ? null : ParseContext.this.resolve(mainSchema);
            }

            @Override
            public List<Schema> parsedNamedSchemas() {
                return parsedNamedSchemas.stream().map(ParseContext.this::resolve).collect(Collectors.toList());
            }
        };
        this.commit();
        return parseResult;
    }

    public void rollback() {
        this.newSchemas.clear();
    }

    public List<Schema> resolveAllSchemas() {
        this.ensureSchemasAreResolved();
        return new ArrayList<Schema>(this.oldSchemas.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureSchemasAreResolved() {
        if (this.hasNewSchemas()) {
            throw new IllegalStateException("Schemas cannot be resolved unless the ParseContext is committed.");
        }
        if (this.resolvingVisitor == null) {
            NameValidator saved = Schema.getNameValidator();
            try {
                Schema.setNameValidator(this.nameValidator);
                SchemaResolver.ResolvingVisitor visitor2 = new SchemaResolver.ResolvingVisitor(this.oldSchemas::get);
                this.oldSchemas.values().forEach(schema -> Schemas.visit(schema, visitor2));
                for (Map.Entry<String, Schema> entry : this.oldSchemas.entrySet()) {
                    entry.setValue(visitor2.getResolved(entry.getValue()));
                }
                this.resolvingVisitor = visitor2;
            }
            finally {
                Schema.setNameValidator(saved);
            }
        }
    }

    public Schema resolve(Schema schema) {
        this.ensureSchemasAreResolved();
        if (NAMED_SCHEMA_TYPES.contains((Object)schema.getType()) && schema.getFullName() != null) {
            return Objects.requireNonNull(this.oldSchemas.get(schema.getFullName()), () -> "Unknown schema: " + schema.getFullName());
        }
        Schemas.visit(schema, this.resolvingVisitor);
        return this.resolvingVisitor.getResolved(schema);
    }

    public Map<String, Schema> typesByName() {
        LinkedHashMap<String, Schema> result2 = new LinkedHashMap<String, Schema>();
        result2.putAll(this.oldSchemas);
        result2.putAll(this.newSchemas);
        return result2;
    }

    static {
        PRIMITIVES.put("string", Schema.Type.STRING);
        PRIMITIVES.put("bytes", Schema.Type.BYTES);
        PRIMITIVES.put("int", Schema.Type.INT);
        PRIMITIVES.put("long", Schema.Type.LONG);
        PRIMITIVES.put("float", Schema.Type.FLOAT);
        PRIMITIVES.put("double", Schema.Type.DOUBLE);
        PRIMITIVES.put("boolean", Schema.Type.BOOLEAN);
        PRIMITIVES.put("null", Schema.Type.NULL);
        NAMED_SCHEMA_TYPES = EnumSet.of(Schema.Type.RECORD, Schema.Type.ENUM, Schema.Type.FIXED);
    }
}

