/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.classpath;

import io.github.classgraph.ModuleRef;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import nonapi.io.github.classgraph.reflection.ReflectionUtils;
import nonapi.io.github.classgraph.scanspec.ScanSpec;
import nonapi.io.github.classgraph.utils.CollectionUtils;
import nonapi.io.github.classgraph.utils.LogNode;

public class ModuleFinder {
    private List<ModuleRef> systemModuleRefs;
    private List<ModuleRef> nonSystemModuleRefs;
    private boolean forceScanJavaClassPath;

    public List<ModuleRef> getSystemModuleRefs() {
        return this.systemModuleRefs;
    }

    public List<ModuleRef> getNonSystemModuleRefs() {
        return this.nonSystemModuleRefs;
    }

    public boolean forceScanJavaClassPath() {
        return this.forceScanJavaClassPath;
    }

    private static void findLayerOrder(Object layer, Set<Object> layerVisited, Set<Object> parentLayers, Deque<Object> layerOrderOut) {
        if (layerVisited.add(layer)) {
            List parents = (List)ReflectionUtils.invokeMethod(true, layer, "parents");
            if (parents != null) {
                parentLayers.addAll(parents);
                for (Object parent : parents) {
                    ModuleFinder.findLayerOrder(parent, layerVisited, parentLayers, layerOrderOut);
                }
            }
            layerOrderOut.push(layer);
        }
    }

    private static List<ModuleRef> findModuleRefs(LinkedHashSet<Object> layers, ScanSpec scanSpec, LogNode log) {
        ArrayList layerOrderFinal;
        if (layers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayDeque<Object> layerOrder = new ArrayDeque<Object>();
        HashSet<Object> parentLayers = new HashSet<Object>();
        for (Object e : layers) {
            if (e == null) continue;
            ModuleFinder.findLayerOrder(e, new HashSet<Object>(), parentLayers, layerOrder);
        }
        if (scanSpec.addedModuleLayers != null) {
            for (Object object : scanSpec.addedModuleLayers) {
                if (object == null) continue;
                ModuleFinder.findLayerOrder(object, new HashSet<Object>(), parentLayers, layerOrder);
            }
        }
        if (scanSpec.ignoreParentModuleLayers) {
            layerOrderFinal = new ArrayList();
            for (Object e : layerOrder) {
                if (parentLayers.contains(e)) continue;
                layerOrderFinal.add(e);
            }
        } else {
            layerOrderFinal = new ArrayList(layerOrder);
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        for (Object layer : layerOrderFinal) {
            Set modules;
            Object configuration2 = ReflectionUtils.invokeMethod(true, layer, "configuration");
            if (configuration2 == null || (modules = (Set)ReflectionUtils.invokeMethod(true, configuration2, "modules")) == null) continue;
            ArrayList<ModuleRef> modulesInLayer = new ArrayList<ModuleRef>();
            for (Object module2 : modules) {
                Object moduleReference = ReflectionUtils.invokeMethod(true, module2, "reference");
                if (moduleReference == null || !hashSet.add(moduleReference)) continue;
                try {
                    modulesInLayer.add(new ModuleRef(moduleReference, layer));
                }
                catch (IllegalArgumentException e) {
                    if (log == null) continue;
                    log.log("Exception while creating ModuleRef for module " + moduleReference, e);
                }
            }
            CollectionUtils.sortIfNotEmpty(modulesInLayer);
            linkedHashSet.addAll(modulesInLayer);
        }
        return new ArrayList<ModuleRef>(linkedHashSet);
    }

    private List<ModuleRef> findModuleRefsFromCallstack(Class<?>[] callStack, ScanSpec scanSpec, boolean scanNonSystemModules, LogNode log) {
        LinkedHashSet<Object> layers = new LinkedHashSet<Object>();
        if (callStack != null) {
            for (Class<?> stackFrameClass : callStack) {
                Object module2 = ReflectionUtils.invokeMethod(false, stackFrameClass, "getModule");
                if (module2 == null) continue;
                Object layer = ReflectionUtils.invokeMethod(true, module2, "getLayer");
                if (layer != null) {
                    layers.add(layer);
                    continue;
                }
                if (!scanNonSystemModules) continue;
                this.forceScanJavaClassPath = true;
            }
        }
        Class<?> moduleLayerClass = null;
        try {
            moduleLayerClass = Class.forName("java.lang.ModuleLayer");
        }
        catch (ClassNotFoundException | LinkageError throwable) {
            // empty catch block
        }
        if (moduleLayerClass != null) {
            Object bootLayer = ReflectionUtils.invokeStaticMethod(false, moduleLayerClass, "boot");
            if (bootLayer != null) {
                layers.add(bootLayer);
            } else if (scanNonSystemModules) {
                this.forceScanJavaClassPath = true;
            }
        }
        return ModuleFinder.findModuleRefs(layers, scanSpec, log);
    }

    public ModuleFinder(Class<?>[] callStack, ScanSpec scanSpec, boolean scanNonSystemModules, boolean scanSystemModules, LogNode log) {
        List<ModuleRef> allModuleRefsList = null;
        if (scanSpec.overrideModuleLayers == null) {
            if (callStack != null && callStack.length > 0) {
                allModuleRefsList = this.findModuleRefsFromCallstack(callStack, scanSpec, scanNonSystemModules, log);
            }
        } else {
            if (log != null) {
                LogNode subLog = log.log("Overriding module layers");
                for (Object moduleLayer : scanSpec.overrideModuleLayers) {
                    subLog.log(moduleLayer.toString());
                }
            }
            allModuleRefsList = ModuleFinder.findModuleRefs(new LinkedHashSet<Object>(scanSpec.overrideModuleLayers), scanSpec, log);
        }
        if (allModuleRefsList != null) {
            this.systemModuleRefs = new ArrayList<ModuleRef>();
            this.nonSystemModuleRefs = new ArrayList<ModuleRef>();
            for (ModuleRef moduleRef : allModuleRefsList) {
                if (moduleRef == null) continue;
                boolean isSystemModule = moduleRef.isSystemModule();
                if (isSystemModule && scanSystemModules) {
                    this.systemModuleRefs.add(moduleRef);
                    continue;
                }
                if (isSystemModule || !scanNonSystemModules) continue;
                this.nonSystemModuleRefs.add(moduleRef);
            }
        }
        if (log != null) {
            if (scanSystemModules) {
                LogNode sysSubLog = log.log("System modules found:");
                if (this.systemModuleRefs != null && !this.systemModuleRefs.isEmpty()) {
                    for (ModuleRef moduleRef : this.systemModuleRefs) {
                        sysSubLog.log(moduleRef.toString());
                    }
                } else {
                    sysSubLog.log("[None]");
                }
            } else {
                log.log("Scanning of system modules is not enabled");
            }
            if (scanNonSystemModules) {
                LogNode nonSysSubLog = log.log("Non-system modules found:");
                if (this.nonSystemModuleRefs != null && !this.nonSystemModuleRefs.isEmpty()) {
                    for (ModuleRef moduleRef : this.nonSystemModuleRefs) {
                        nonSysSubLog.log(moduleRef.toString());
                    }
                } else {
                    nonSysSubLog.log("[None]");
                }
            } else {
                log.log("Scanning of non-system modules is not enabled");
            }
        }
    }
}

