/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.classloaderhandler;

import java.io.File;
import java.lang.reflect.Array;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nonapi.io.github.classgraph.classloaderhandler.ClassLoaderHandler;
import nonapi.io.github.classgraph.classpath.ClassLoaderOrder;
import nonapi.io.github.classgraph.classpath.ClasspathOrder;
import nonapi.io.github.classgraph.reflection.ReflectionUtils;
import nonapi.io.github.classgraph.scanspec.ScanSpec;
import nonapi.io.github.classgraph.utils.FileUtils;
import nonapi.io.github.classgraph.utils.LogNode;

class JBossClassLoaderHandler
implements ClassLoaderHandler {
    private JBossClassLoaderHandler() {
    }

    public static boolean canHandle(Class<?> classLoaderClass, LogNode log) {
        return "org.jboss.modules.ModuleClassLoader".equals(classLoaderClass.getName());
    }

    public static void findClassLoaderOrder(ClassLoader classLoader2, ClassLoaderOrder classLoaderOrder, LogNode log) {
        classLoaderOrder.delegateTo(classLoader2.getParent(), true, log);
        classLoaderOrder.add(classLoader2, log);
    }

    private static void handleResourceLoader(Object resourceLoader, ClassLoader classLoader2, ClasspathOrder classpathOrderOut, ScanSpec scanSpec, LogNode log) {
        File file;
        if (resourceLoader == null) {
            return;
        }
        Object root = ReflectionUtils.getFieldVal(false, resourceLoader, "root");
        File physicalFile = (File)ReflectionUtils.invokeMethod(false, root, "getPhysicalFile");
        String path = null;
        if (physicalFile != null) {
            File file2;
            String name2 = (String)ReflectionUtils.invokeMethod(false, root, "getName");
            path = name2 != null ? (FileUtils.canRead(file2 = new File(physicalFile.getParentFile(), name2)) ? file2.getAbsolutePath() : physicalFile.getAbsolutePath()) : physicalFile.getAbsolutePath();
        } else {
            path = (String)ReflectionUtils.invokeMethod(false, root, "getPathName");
            if (path == null) {
                File file3 = root instanceof Path ? ((Path)root).toFile() : (file = root instanceof File ? (File)root : null);
                if (file != null) {
                    path = file.getAbsolutePath();
                }
            }
        }
        if (path == null && (file = (File)ReflectionUtils.getFieldVal(false, resourceLoader, "fileOfJar")) != null) {
            path = file.getAbsolutePath();
        }
        if (path != null) {
            classpathOrderOut.addClasspathEntry((Object)path, classLoader2, scanSpec, log);
        } else if (log != null) {
            log.log("Could not determine classpath for ResourceLoader: " + resourceLoader);
        }
    }

    private static void handleRealModule(Object module2, Set<Object> visitedModules, ClassLoader classLoader2, ClasspathOrder classpathOrderOut, ScanSpec scanSpec, LogNode log) {
        Object vfsResourceLoaders;
        if (!visitedModules.add(module2)) {
            return;
        }
        ClassLoader moduleLoader = (ClassLoader)ReflectionUtils.invokeMethod(false, module2, "getClassLoader");
        if (moduleLoader == null) {
            moduleLoader = classLoader2;
        }
        if ((vfsResourceLoaders = ReflectionUtils.invokeMethod(false, moduleLoader, "getResourceLoaders")) != null) {
            int n = Array.getLength(vfsResourceLoaders);
            for (int i = 0; i < n; ++i) {
                Object resourceLoader = Array.get(vfsResourceLoaders, i);
                JBossClassLoaderHandler.handleResourceLoader(resourceLoader, moduleLoader, classpathOrderOut, scanSpec, log);
            }
        }
    }

    public static void findClasspathOrder(ClassLoader classLoader2, ClasspathOrder classpathOrder, ScanSpec scanSpec, LogNode log) {
        Object module2 = ReflectionUtils.invokeMethod(false, classLoader2, "getModule");
        Object callerModuleLoader = ReflectionUtils.invokeMethod(false, module2, "getCallerModuleLoader");
        HashSet<Object> visitedModules = new HashSet<Object>();
        Map moduleMap = (Map)ReflectionUtils.getFieldVal(false, callerModuleLoader, "moduleMap");
        Set<Object> moduleMapEntries = moduleMap != null ? moduleMap.entrySet() : Collections.emptySet();
        for (Map.Entry entry : moduleMapEntries) {
            Object val = entry.getValue();
            Object realModule = ReflectionUtils.invokeMethod(false, val, "getModule");
            JBossClassLoaderHandler.handleRealModule(realModule, visitedModules, classLoader2, classpathOrder, scanSpec, log);
        }
        Map pathsMap = (Map)ReflectionUtils.invokeMethod(false, module2, "getPaths");
        for (Map.Entry ent : pathsMap.entrySet()) {
            for (Object localLoader : (List)ent.getValue()) {
                Object moduleClassLoader = ReflectionUtils.getFieldVal(false, localLoader, "this$0");
                Object realModule = ReflectionUtils.getFieldVal(false, moduleClassLoader, "module");
                JBossClassLoaderHandler.handleRealModule(realModule, visitedModules, classLoader2, classpathOrder, scanSpec, log);
            }
        }
    }
}

