/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.platform;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.lightapi.portal.platform.DeploymentPlatformHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnsiblePlatform
implements DeploymentPlatformHandler {
    private static final Logger logger = LoggerFactory.getLogger(AnsiblePlatform.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    @Override
    public Map<String, Object> startDeployment(Map<String, Object> input) throws Exception {
        String instanceId = (String)input.get("instanceId");
        String platformUrl = (String)input.get("url");
        String token = (String)input.get("token");
        URL url = new URL(platformUrl + "/api/v2/job_templates/1/launch/");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        conn.setRequestProperty("Authorization", "Bearer " + token);
        conn.setRequestProperty("Content-Type", "application/json");
        String payload = mapper.writeValueAsString(Map.of("extra_vars", Map.of("instance_id", instanceId, "action", "deploy")));
        conn.getOutputStream().write(payload.getBytes(StandardCharsets.UTF_8));
        Map response = mapper.readValue(conn.getInputStream(), Map.class);
        String jobId = String.valueOf(response.get("job"));
        HashMap<String, Object> result2 = new HashMap<String, Object>();
        result2.put("jobId", jobId);
        return result2;
    }

    @Override
    public Map<String, Object> queryStatus(Map<String, Object> input) throws Exception {
        String jobId = (String)input.get("jobId");
        String deploymentId = (String)input.get("deploymentId");
        String token = (String)input.get("token");
        String platformUrl = (String)input.get("url");
        URL url = new URL(platformUrl + "/api/v2/jobs/" + jobId + "/");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Authorization", "Bearer " + token);
        Map response = mapper.readValue(conn.getInputStream(), Map.class);
        String status = (String)response.get("status");
        logger.info("Ansible job status for job {} = {}", (Object)jobId, (Object)status);
        HashMap<String, Object> result2 = new HashMap<String, Object>();
        result2.put("status", status);
        return result2;
    }
}

