/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.command;

import com.networknt.config.Config;
import com.networknt.config.JsonMapper;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.monad.Failure;
import com.networknt.monad.Result;
import com.networknt.monad.Success;
import com.networknt.rpc.HybridHandler;
import com.networknt.status.Status;
import com.networknt.utility.NioUtils;
import com.networknt.utility.UuidUtil;
import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.cloudevents.jackson.JsonFormat;
import io.undertow.server.HttpServerExchange;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import net.lightapi.portal.HybridQueryClient;
import net.lightapi.portal.PortalConfig;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.PortalUtil;
import net.lightapi.portal.command.HybridCommandStartup;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;

public abstract class AbstractCommandHandler
implements HybridHandler {
    protected static final PortalConfig config = (PortalConfig)Config.getInstance().getJsonObjectConfig("portal", PortalConfig.class);
    private static final JsonFormat jsonFormat = new JsonFormat();
    public static final String USER_ID = "userId";
    public static final String HOST_ID = "hostId";
    protected static final String INCORRECT_TOKEN_TYPE = "ERR11601";
    protected static final String SEND_MESSAGE_EXCEPTION = "ERR11605";

    protected abstract String getCloudEventType();

    protected Result<Map<String, Object>> validateInput(HttpServerExchange exchange, Map<String, Object> map, String userId, String host) {
        return Success.of(map);
    }

    protected Result<Map<String, Object>> enrichInput(HttpServerExchange exchange, Map<String, Object> map) {
        return Success.of(map);
    }

    protected String customizeOutput(Map<String, Object> map) {
        return JsonMapper.toJson(map);
    }

    protected Result<Map<String, Object>> validateTokenType(String userId, Map<String, Object> map) {
        if (userId == null) {
            this.getLogger().error("Incorrect token type: userId is null. Must be Authorization Code Token.");
            return Failure.of(new Status(INCORRECT_TOKEN_TYPE, "Authorization Code Token"));
        }
        return Success.of(map);
    }

    protected Result<Map<String, Object>> additionalAction(HttpServerExchange exchange, Map<String, Object> map, String userId, String host) {
        return Success.of(map);
    }

    @Override
    public ByteBuffer handle(HttpServerExchange exchange, Object input) {
        Result<Map<String, Object>> validatedResult;
        String host;
        Boolean globalFlag;
        Logger logger2 = this.getLogger();
        System.out.println(logger2.getName());
        if (logger2.isTraceEnabled()) {
            logger2.trace("input = {}", input);
        }
        Map map = (Map)input;
        Map auditInfo = exchange.getAttachment(AttachmentConstants.AUDIT_INFO);
        String userId = (String)auditInfo.get("user_id");
        Result<Map<String, Object>> tokenTypeResult = this.validateTokenType(userId, map);
        if (tokenTypeResult.isFailure()) {
            return NioUtils.toByteBuffer(this.getStatus(exchange, tokenTypeResult.getError()));
        }
        String role = (String)auditInfo.get("role");
        if (role != null && role.contains("admin") && (globalFlag = (Boolean)map.get("globalFlag")) != null && globalFlag.booleanValue()) {
            map.remove(HOST_ID);
            map.remove("globalFlag");
        }
        if ((host = (String)auditInfo.get("host")) == null) {
            host = (String)map.get(HOST_ID);
        }
        if (userId == null) {
            userId = (String)map.get(USER_ID);
        }
        if (logger2.isTraceEnabled()) {
            logger2.trace("userId = {}, host = {}", (Object)userId, (Object)host);
        }
        if ((validatedResult = this.validateInput(exchange, map, userId, host)).isFailure()) {
            return NioUtils.toByteBuffer(this.getStatus(exchange, validatedResult.getError()));
        }
        Result<Map<String, Object>> enrichedResult = this.enrichInput(exchange, map);
        if (enrichedResult.isFailure()) {
            return NioUtils.toByteBuffer(this.getStatus(exchange, enrichedResult.getError()));
        }
        Result<String> result2 = HybridQueryClient.getNonceByUserId(exchange, userId);
        if (result2.isFailure()) {
            return NioUtils.toByteBuffer(this.getStatus(exchange, result2.getError()));
        }
        Number nonce = PortalUtil.parseNumber(result2.getResult());
        if (logger2.isTraceEnabled()) {
            logger2.trace("nonce = {}", (Object)nonce);
        }
        CloudEvent event = this.buildCloudEvent(map, userId, host, nonce);
        ProducerRecord<String, byte[]> record = new ProducerRecord<String, byte[]>(config.getTopic(), config.isMultitenancy() ? host : userId, jsonFormat.serialize(event));
        CountDownLatch latch = new CountDownLatch(1);
        try {
            HybridCommandStartup.producer.send(record, (recordMetadata, e) -> {
                if (Objects.nonNull(e)) {
                    logger2.error("Exception occurred while pushing the event", e);
                } else {
                    logger2.info("Event record pushed successfully. Received Record Metadata is {}", (Object)recordMetadata);
                }
                latch.countDown();
            });
            latch.await();
        }
        catch (InterruptedException e2) {
            logger2.error("Exception:", e2);
            return NioUtils.toByteBuffer(this.getStatus(exchange, SEND_MESSAGE_EXCEPTION, e2.getMessage(), config.isMultitenancy() ? host : userId));
        }
        Result<Map<String, Object>> additionalActionResult = this.additionalAction(exchange, map, userId, host);
        if (additionalActionResult.isFailure()) {
            return NioUtils.toByteBuffer(this.getStatus(exchange, additionalActionResult.getError()));
        }
        return NioUtils.toByteBuffer(this.customizeOutput(map));
    }

    protected CloudEvent buildCloudEvent(Map<String, Object> map, String userId, String host, Number nonce) {
        io.cloudevents.core.v1.CloudEventBuilder eventTemplate = CloudEventBuilder.v1().withSource(PortalConstants.EVENT_SOURCE).withType(this.getCloudEventType());
        String data = JsonMapper.toJson(map);
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace("event user = {} host = {} type = {} and data = {}", userId, host, this.getCloudEventType(), data);
        }
        return eventTemplate.newBuilder().withId(UuidUtil.getUUID().toString()).withTime(OffsetDateTime.now()).withExtension("user", userId).withExtension("nonce", nonce).withExtension("host", host).withData("application/json", data.getBytes(StandardCharsets.UTF_8)).build();
    }

    protected abstract Logger getLogger();
}

