/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.error.YAMLException;

public class PortalUtil {
    private static final HttpClient client = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).connectTimeout(Duration.ofSeconds(10L)).build();

    public static String readUrl(String url) throws IOException, InterruptedException, URISyntaxException {
        HttpRequest request = HttpRequest.newBuilder().uri(new URI(url)).GET().timeout(Duration.ofSeconds(30L)).build();
        HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() >= 200 && response.statusCode() < 300) {
            return response.body();
        }
        throw new IOException("HTTP request failed with status code: " + response.statusCode() + ", body: " + response.body());
    }

    public static boolean isValidYaml(String yamlString) {
        try {
            Yaml yaml = new Yaml(new SafeConstructor(new LoaderOptions()));
            yaml.load(yamlString);
            return true;
        }
        catch (YAMLException e) {
            System.err.println("Invalid YAML: " + e.getMessage());
            return false;
        }
    }

    public static Map<String, Object> yamlToMap(String yamlString) {
        LoaderOptions options = new LoaderOptions();
        Yaml yaml = new Yaml(new SafeConstructor(options));
        Object obj = yaml.load(yamlString);
        if (obj instanceof Map) {
            return (Map)obj;
        }
        return new LinkedHashMap<String, Object>();
    }

    public static Number parseNumber(String str) throws NumberFormatException {
        if (str == null || str.trim().isEmpty()) {
            throw new NumberFormatException("Input string is null or empty");
        }
        String trimmed = str.trim();
        if (trimmed.matches(".*[.eE].*")) {
            try {
                return PortalUtil.parseFloatingPoint(trimmed);
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("Invalid floating-point number: " + trimmed);
            }
        }
        try {
            return PortalUtil.parseInteger(trimmed);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Invalid integer number: " + trimmed);
        }
    }

    private static Number parseFloatingPoint(String str) {
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException e) {
            return new BigDecimal(str);
        }
    }

    private static Number parseInteger(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e1) {
            try {
                return Long.parseLong(str);
            }
            catch (NumberFormatException e2) {
                return new BigInteger(str);
            }
        }
    }
}

