/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal;

import com.networknt.client.Http2Client;
import com.networknt.cluster.Cluster;
import com.networknt.config.Config;
import com.networknt.config.JsonMapper;
import com.networknt.monad.Failure;
import com.networknt.monad.Result;
import com.networknt.monad.Success;
import com.networknt.server.ServerConfig;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.status.Status;
import io.undertow.UndertowOptions;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.net.URI;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import net.lightapi.portal.PortalClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.OptionMap;

public class HybridCommandClient {
    static final Logger logger = LoggerFactory.getLogger(HybridCommandClient.class);
    public static final PortalClientConfig config = (PortalClientConfig)Config.getInstance().getJsonObjectConfig("portal-client", PortalClientConfig.class);
    static String tag = ServerConfig.getInstance().getEnvironment();
    static Cluster cluster = SingletonServiceFactory.getBean(Cluster.class);
    static Http2Client client = Http2Client.getInstance();
    static ClientConnection connection;
    static final String GENERIC_EXCEPTION = "ERR10014";
    static final String ESTABLISH_CONNECTION_ERROR = "ERR10053";
    static Map<String, ClientConnection> connCache;

    public HybridCommandClient() {
        if (!config.isPortalByServiceUrl()) {
            String host = cluster.serviceToUrl("https", config.getPortalCommandServiceId(), tag, null);
            try {
                connection = client.connect(new URI(host), Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, OptionMap.create(UndertowOptions.ENABLE_HTTP2, true)).get();
            }
            catch (Exception e) {
                logger.error("Exception:", e);
            }
        }
    }

    public static Result<String> callCommandWithToken(String command, String token) {
        try {
            if (connection == null || !connection.isOpen()) {
                String host = cluster.serviceToUrl("https", config.getPortalCommandServiceId(), tag, null);
                connection = client.connect(new URI(host), Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, OptionMap.create(UndertowOptions.ENABLE_HTTP2, true)).get();
            }
            return HybridCommandClient.callCommandWithToken(connection, command, token);
        }
        catch (Exception e) {
            logger.error("Exception:", e);
            Status status = new Status(ESTABLISH_CONNECTION_ERROR, e.getMessage());
            return Failure.of(status);
        }
    }

    public static Result<String> callCommandWithToken(String command, String token, String url) {
        try {
            ClientConnection conn = connCache.get(url);
            if (conn == null || !conn.isOpen()) {
                conn = client.connect(new URI(url), Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, OptionMap.create(UndertowOptions.ENABLE_HTTP2, true)).get();
                connCache.put(url, conn);
            }
            return HybridCommandClient.callCommandWithToken(conn, command, token);
        }
        catch (Exception e) {
            logger.error("Exception:", e);
            Status status = new Status(ESTABLISH_CONNECTION_ERROR, e.getMessage());
            return Failure.of(status);
        }
    }

    public static Result<String> callCommandWithToken(ClientConnection connection, String command, String token) {
        Result<String> result2 = null;
        try {
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference<ClientResponse> reference = new AtomicReference<ClientResponse>();
            String message = "/portal/command?cmd=" + URLEncoder.encode(command, "UTF-8");
            ClientRequest request = new ClientRequest().setMethod(Methods.GET).setPath(message);
            request.getRequestHeaders().put(Headers.AUTHORIZATION, "Bearer " + token);
            request.getRequestHeaders().put(Headers.HOST, "localhost");
            connection.sendRequest(request, client.createClientCallback(reference, latch));
            latch.await();
            int statusCode = reference.get().getResponseCode();
            String body = reference.get().getAttachment(Http2Client.RESPONSE_BODY);
            if (statusCode != 200) {
                Status status = Config.getInstance().getMapper().readValue(body, Status.class);
                result2 = Failure.of(status);
            } else {
                result2 = Success.of(body);
            }
        }
        catch (Exception e) {
            logger.error("Exception:", e);
            Status status = new Status(GENERIC_EXCEPTION, e.getMessage());
            result2 = Failure.of(status);
        }
        return result2;
    }

    public static Result<String> createRefreshToken(Map<String, Object> refreshTokenMap, String token) {
        HashMap<String, Object> commandMap = new HashMap<String, Object>();
        commandMap.put("host", "lightapi.net");
        commandMap.put("service", "oauth");
        commandMap.put("action", "createRefreshToken");
        commandMap.put("version", "0.1.0");
        commandMap.put("data", refreshTokenMap);
        String command = JsonMapper.toJson(commandMap);
        if (logger.isTraceEnabled()) {
            logger.trace("command = " + command);
        }
        if (config.isPortalByServiceUrl()) {
            return HybridCommandClient.callCommandWithToken(command, token, config.getPortalCommandServiceUrl());
        }
        return HybridCommandClient.callCommandWithToken(command, token);
    }

    public static Result<String> createAuthCode(Map<String, Object> codeMap, String token) {
        HashMap<String, Object> commandMap = new HashMap<String, Object>();
        commandMap.put("host", "lightapi.net");
        commandMap.put("service", "oauth");
        commandMap.put("action", "createAuthCode");
        commandMap.put("version", "0.1.0");
        commandMap.put("data", codeMap);
        if (config.isPortalByServiceUrl()) {
            return HybridCommandClient.callCommandWithToken(JsonMapper.toJson(commandMap), token, config.getPortalCommandServiceUrl());
        }
        return HybridCommandClient.callCommandWithToken(JsonMapper.toJson(commandMap), token);
    }

    public static Result<String> deleteAuthCode(String hostId, String authCode, String token) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"oauth\",\"action\":\"deleteAuthCode\",\"version\":\"0.1.0\",\"data\":{\"hostId\":\"%s\",\"authCode\":\"%s\"}}", hostId, authCode);
        if (config.isPortalByServiceUrl()) {
            return HybridCommandClient.callCommandWithToken(command, token, config.getPortalCommandServiceUrl());
        }
        return HybridCommandClient.callCommandWithToken(command, token);
    }

    public static Result<String> createRefToken(Map<String, Object> refTokenMap, String token) {
        HashMap<String, Object> commandMap = new HashMap<String, Object>();
        commandMap.put("host", "lightapi.net");
        commandMap.put("service", "oauth");
        commandMap.put("action", "createRefToken");
        commandMap.put("version", "0.1.0");
        commandMap.put("data", refTokenMap);
        String command = JsonMapper.toJson(commandMap);
        if (logger.isTraceEnabled()) {
            logger.trace("command = " + command);
        }
        if (config.isPortalByServiceUrl()) {
            return HybridCommandClient.callCommandWithToken(command, token, config.getPortalCommandServiceUrl());
        }
        return HybridCommandClient.callCommandWithToken(command, token);
    }

    public static Result<String> createSocialUser(Map<String, Object> userMap, String token) {
        HashMap<String, Object> commandMap = new HashMap<String, Object>();
        commandMap.put("host", "lightapi.net");
        commandMap.put("service", "user");
        commandMap.put("action", "createSocialUser");
        commandMap.put("version", "0.1.0");
        commandMap.put("data", userMap);
        String command = JsonMapper.toJson(commandMap);
        if (logger.isTraceEnabled()) {
            logger.trace("command = " + command);
        }
        if (config.isPortalByServiceUrl()) {
            return HybridCommandClient.callCommandWithToken(command, token, config.getPortalCommandServiceUrl());
        }
        return HybridCommandClient.callCommandWithToken(command, token);
    }

    static {
        connCache = new ConcurrentHashMap<String, ClientConnection>();
    }
}

