/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.extensions;

import io.undertow.connector.PooledByteBuffer;
import io.undertow.websockets.core.StreamSinkFrameChannel;
import io.undertow.websockets.core.StreamSourceFrameChannel;
import io.undertow.websockets.extensions.ExtensionFunction;
import io.undertow.websockets.extensions.NoopExtensionFunction;
import java.io.IOException;
import java.util.List;

public class CompositeExtensionFunction
implements ExtensionFunction {
    private final ExtensionFunction[] delegates;

    private CompositeExtensionFunction(ExtensionFunction ... delegates) {
        this.delegates = delegates;
    }

    public static ExtensionFunction compose(List<ExtensionFunction> functions) {
        if (null == functions) {
            return NoopExtensionFunction.INSTANCE;
        }
        return CompositeExtensionFunction.compose(functions.toArray(new ExtensionFunction[functions.size()]));
    }

    public static ExtensionFunction compose(ExtensionFunction ... functions) {
        if (functions == null || functions.length == 0) {
            return NoopExtensionFunction.INSTANCE;
        }
        if (functions.length == 1) {
            return functions[0];
        }
        return new CompositeExtensionFunction(functions);
    }

    @Override
    public boolean hasExtensionOpCode() {
        for (ExtensionFunction delegate : this.delegates) {
            if (!delegate.hasExtensionOpCode()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int writeRsv(int rsv) {
        for (ExtensionFunction ext : this.delegates) {
            rsv = ext.writeRsv(rsv);
        }
        return rsv;
    }

    @Override
    public PooledByteBuffer transformForWrite(PooledByteBuffer pooledBuffer, StreamSinkFrameChannel channel, boolean lastFrame) throws IOException {
        PooledByteBuffer result2 = pooledBuffer;
        for (ExtensionFunction delegate : this.delegates) {
            result2 = delegate.transformForWrite(result2, channel, lastFrame);
        }
        return result2;
    }

    @Override
    public PooledByteBuffer transformForRead(PooledByteBuffer pooledBuffer, StreamSourceFrameChannel channel, boolean lastFragementOfMessage) throws IOException {
        PooledByteBuffer result2 = pooledBuffer;
        for (ExtensionFunction delegate : this.delegates) {
            result2 = delegate.transformForRead(result2, channel, lastFragementOfMessage);
        }
        return result2;
    }

    @Override
    public void dispose() {
        for (ExtensionFunction delegate : this.delegates) {
            delegate.dispose();
        }
    }
}

