/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.security.impl;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.idm.PasswordCredential;
import io.undertow.server.DefaultResponseListener;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.server.session.Session;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import io.undertow.util.RedirectBuilder;
import io.undertow.util.Sessions;
import java.io.IOException;
import java.io.UncheckedIOException;

public class FormAuthenticationMechanism
implements AuthenticationMechanism {
    public static final String LOCATION_ATTRIBUTE = FormAuthenticationMechanism.class.getName() + ".LOCATION";
    public static final String DEFAULT_POST_LOCATION = "/j_security_check";
    protected static final String ORIGINAL_SESSION_TIMEOUT = "io.undertow.servlet.form.auth.orig.session.timeout";
    private final String name;
    private final String loginPage;
    private final String errorPage;
    private final String postLocation;
    private final FormParserFactory formParserFactory;
    private final IdentityManager identityManager;
    protected final int authenticationSessionTimeout = 120;

    public FormAuthenticationMechanism(String name2, String loginPage, String errorPage) {
        this(FormParserFactory.builder().build(), name2, loginPage, errorPage);
    }

    public FormAuthenticationMechanism(String name2, String loginPage, String errorPage, String postLocation) {
        this(FormParserFactory.builder().build(), name2, loginPage, errorPage, postLocation);
    }

    public FormAuthenticationMechanism(FormParserFactory formParserFactory, String name2, String loginPage, String errorPage) {
        this(formParserFactory, name2, loginPage, errorPage, DEFAULT_POST_LOCATION);
    }

    public FormAuthenticationMechanism(FormParserFactory formParserFactory, String name2, String loginPage, String errorPage, IdentityManager identityManager) {
        this(formParserFactory, name2, loginPage, errorPage, DEFAULT_POST_LOCATION, identityManager);
    }

    public FormAuthenticationMechanism(FormParserFactory formParserFactory, String name2, String loginPage, String errorPage, String postLocation) {
        this(formParserFactory, name2, loginPage, errorPage, postLocation, null);
    }

    public FormAuthenticationMechanism(FormParserFactory formParserFactory, String name2, String loginPage, String errorPage, String postLocation, IdentityManager identityManager) {
        this.name = name2;
        this.loginPage = loginPage;
        this.errorPage = errorPage;
        this.postLocation = postLocation;
        this.formParserFactory = formParserFactory;
        this.identityManager = identityManager;
    }

    private IdentityManager getIdentityManager(SecurityContext securityContext) {
        return this.identityManager != null ? this.identityManager : securityContext.getIdentityManager();
    }

    @Override
    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        if (exchange.getRequestPath().endsWith(this.postLocation) && exchange.getRequestMethod().equals(Methods.POST)) {
            return this.runFormAuth(exchange, securityContext);
        }
        return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public AuthenticationMechanism.AuthenticationMechanismOutcome runFormAuth(HttpServerExchange exchange, SecurityContext securityContext) {
        AuthenticationMechanism.AuthenticationMechanismOutcome retValue;
        Throwable original;
        block25: {
            FormDataParser parser = this.formParserFactory.createParser(exchange);
            if (parser == null) {
                UndertowLogger.SECURITY_LOGGER.debug("Could not authenticate as no form parser is present");
                return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
            }
            original = null;
            retValue = null;
            try {
                AuthenticationMechanism.AuthenticationMechanismOutcome outcome;
                block24: {
                    FormData data = parser.parseBlocking();
                    FormData.FormValue jUsername = data.getFirst("j_username");
                    FormData.FormValue jPassword = data.getFirst("j_password");
                    if (jUsername == null || jPassword == null) {
                        UndertowLogger.SECURITY_LOGGER.debugf("Could not authenticate as username or password was not present in the posted result for %s", (Object)exchange);
                        return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
                    }
                    String userName = jUsername.getValue();
                    String password = jPassword.getValue();
                    outcome = null;
                    PasswordCredential credential = new PasswordCredential(password.toCharArray());
                    IdentityManager identityManager = this.getIdentityManager(securityContext);
                    Account account = identityManager.verify(userName, credential);
                    if (account != null) {
                        securityContext.authenticationComplete(account, this.name, true);
                        UndertowLogger.SECURITY_LOGGER.debugf("Authenticated user %s using for auth for %s", (Object)account.getPrincipal().getName(), (Object)exchange);
                        outcome = AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
                        break block24;
                    }
                    securityContext.authenticationFailed(UndertowMessages.MESSAGES.authenticationFailed(userName), this.name);
                }
                try {
                    if (outcome == AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED) {
                        this.handleRedirectBack(exchange);
                        exchange.endExchange();
                    }
                    retValue = outcome != null ? outcome : AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
                }
                catch (Throwable t2) {
                    if (original != null) {
                        original.addSuppressed(t2);
                        break block25;
                    }
                    original = t2;
                }
                break block25;
                catch (Throwable t3) {
                    try {
                        original = t3;
                    }
                    catch (Throwable throwable) {
                        block26: {
                            try {
                                if (outcome == AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED) {
                                    this.handleRedirectBack(exchange);
                                    exchange.endExchange();
                                }
                                retValue = outcome != null ? outcome : AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
                            }
                            catch (Throwable t4) {
                                if (original != null) {
                                    original.addSuppressed(t4);
                                    break block26;
                                }
                                original = t4;
                            }
                        }
                        throw throwable;
                    }
                    try {
                        if (outcome == AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED) {
                            this.handleRedirectBack(exchange);
                            exchange.endExchange();
                        }
                        retValue = outcome != null ? outcome : AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
                    }
                    catch (Throwable t5) {
                        if (original != null) {
                            original.addSuppressed(t5);
                            break block25;
                        }
                        original = t5;
                    }
                }
            }
            catch (IOException e) {
                original = new UncheckedIOException(e);
            }
        }
        if (original != null) {
            if (original instanceof RuntimeException) {
                throw (RuntimeException)original;
            }
            if (original instanceof Error) {
                throw (Error)original;
            }
        }
        return retValue;
    }

    protected void handleRedirectBack(HttpServerExchange exchange) {
        Session session2 = Sessions.getSession(exchange);
        if (session2 != null) {
            this.restoreOriginalSessionTimeout(session2);
            final String location = (String)session2.removeAttribute(LOCATION_ATTRIBUTE);
            if (location != null) {
                exchange.addDefaultResponseListener(new DefaultResponseListener(){

                    @Override
                    public boolean handleDefaultResponse(HttpServerExchange exchange) {
                        exchange.getResponseHeaders().put(Headers.LOCATION, location);
                        exchange.setStatusCode(302);
                        exchange.endExchange();
                        return true;
                    }
                });
            }
        }
    }

    protected void restoreOriginalSessionTimeout(HttpServerExchange exchange) {
        Session session2 = Sessions.getSession(exchange);
        this.restoreOriginalSessionTimeout(session2);
    }

    protected void restoreOriginalSessionTimeout(Session session2) {
        Integer originalSessionTimeout;
        if (session2 != null && (originalSessionTimeout = (Integer)session2.removeAttribute(ORIGINAL_SESSION_TIMEOUT)) != null) {
            session2.setMaxInactiveInterval(originalSessionTimeout);
        }
    }

    @Override
    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        if (exchange.getRelativePath().isEmpty()) {
            exchange.getResponseHeaders().put(Headers.LOCATION, RedirectBuilder.redirect(exchange, exchange.getRelativePath() + "/", true));
            return new AuthenticationMechanism.ChallengeResult(true, 302);
        }
        if (exchange.getRequestPath().endsWith(this.postLocation) && exchange.getRequestMethod().equals(Methods.POST)) {
            UndertowLogger.SECURITY_LOGGER.debugf("Serving form auth error page %s for %s", (Object)this.loginPage, (Object)exchange);
            Integer code = this.servePage(exchange, this.errorPage);
            return new AuthenticationMechanism.ChallengeResult(true, code);
        }
        UndertowLogger.SECURITY_LOGGER.debugf("Serving login form %s for %s", (Object)this.loginPage, (Object)exchange);
        this.storeInitialLocation(exchange);
        Integer code = this.servePage(exchange, this.loginPage);
        return new AuthenticationMechanism.ChallengeResult(true, code);
    }

    protected void storeInitialLocation(HttpServerExchange exchange) {
        int originalMaxInactiveInterval;
        Session session2 = Sessions.getSession(exchange);
        boolean newSession = false;
        if (session2 == null) {
            session2 = Sessions.getOrCreateSession(exchange);
            newSession = true;
        }
        if (newSession && (originalMaxInactiveInterval = session2.getMaxInactiveInterval()) > 120) {
            session2.setAttribute(ORIGINAL_SESSION_TIMEOUT, session2.getMaxInactiveInterval());
            session2.setMaxInactiveInterval(120);
        }
        session2.setAttribute(LOCATION_ATTRIBUTE, RedirectBuilder.redirect(exchange, exchange.getRelativePath()));
    }

    protected Integer servePage(HttpServerExchange exchange, String location) {
        FormAuthenticationMechanism.sendRedirect(exchange, location);
        return 307;
    }

    static void sendRedirect(HttpServerExchange exchange, String location) {
        String loc = exchange.getRequestScheme() + "://" + exchange.getHostAndPort() + location;
        exchange.getResponseHeaders().put(Headers.LOCATION, loc);
    }
}

