/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.security.impl;

import io.undertow.util.HeaderToken;
import io.undertow.util.HeaderTokenParser;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public enum AuthenticationInfoToken implements HeaderToken
{
    NEXT_NONCE(Headers.NEXT_NONCE, true),
    MESSAGE_QOP(Headers.QOP, true),
    RESPONSE_AUTH(Headers.RESPONSE_AUTH, true),
    CNONCE(Headers.CNONCE, true),
    NONCE_COUNT(Headers.NONCE_COUNT, false);

    private static final HeaderTokenParser<AuthenticationInfoToken> TOKEN_PARSER;
    private final String name;
    private final boolean quoted;

    private AuthenticationInfoToken(HttpString name2, boolean quoted) {
        this.name = name2.toString();
        this.quoted = quoted;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isAllowQuoted() {
        return this.quoted;
    }

    public static Map<AuthenticationInfoToken, String> parseHeader(String header) {
        return TOKEN_PARSER.parseHeader(header);
    }

    static {
        LinkedHashMap<String, AuthenticationInfoToken> expected = new LinkedHashMap<String, AuthenticationInfoToken>(AuthenticationInfoToken.values().length);
        for (AuthenticationInfoToken current : AuthenticationInfoToken.values()) {
            expected.put(current.getName(), current);
        }
        TOKEN_PARSER = new HeaderTokenParser(Collections.unmodifiableMap(expected));
    }
}

