/*
 * Decompiled with CFR 0.152.
 */
package io.undertow;

import io.undertow.UndertowLogger;
import io.undertow.protocols.ssl.SslConduit;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.ServerConnection;
import io.undertow.server.handlers.sse.ServerSentEventConnection;
import io.undertow.util.HeaderMap;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.RejectedExecutionException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.xnio.channels.ReadTimeoutException;
import org.xnio.channels.WriteTimeoutException;
import org.xnio.ssl.SslConnection;

public class UndertowLogger_$logger
extends DelegatingBasicLogger
implements UndertowLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = UndertowLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public UndertowLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void exceptionProcessingRequest(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.exceptionProcessingRequest$str(), new Object[0]);
    }

    protected String exceptionProcessingRequest$str() {
        return "UT005001: An exception occurred processing the request";
    }

    @Override
    public final void ioExceptionReadingFromChannel(IOException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.ioExceptionReadingFromChannel$str(), new Object[0]);
    }

    protected String ioExceptionReadingFromChannel$str() {
        return "UT005003: IOException reading from channel";
    }

    @Override
    public final void cannotRemoveUploadedFile(Path file) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.cannotRemoveUploadedFile$str(), (Object)file);
    }

    protected String cannotRemoveUploadedFile$str() {
        return "UT005005: Cannot remove uploaded file %s";
    }

    @Override
    public final void requestHeaderWasTooLarge(SocketAddress address, int size) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.requestHeaderWasTooLarge$str(), (Object)address, (Object)size);
    }

    protected String requestHeaderWasTooLarge$str() {
        return "UT005006: Connection from %s terminated as request header was larger than %s";
    }

    @Override
    public final void requestWasNotFullyConsumed() {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.requestWasNotFullyConsumed$str(), new Object[0]);
    }

    protected String requestWasNotFullyConsumed$str() {
        return "UT005007: Request was not fully consumed";
    }

    @Override
    public final void invalidTokenReceived(String tokenName, String tokenValue) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.invalidTokenReceived$str(), (Object)tokenName, (Object)tokenValue);
    }

    protected String invalidTokenReceived$str() {
        return "UT005008: An invalid token '%s' with value '%s' has been received.";
    }

    @Override
    public final void missingAuthorizationToken(String tokenName) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.missingAuthorizationToken$str(), (Object)tokenName);
    }

    protected String missingAuthorizationToken$str() {
        return "UT005009: A mandatory token %s is missing from the request.";
    }

    @Override
    public final void authenticationFailed(String userName, String mechanism) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.authenticationFailed$str(), (Object)userName, (Object)mechanism);
    }

    protected String authenticationFailed$str() {
        return "UT005010: Verification of authentication tokens for user '%s' has failed using mechanism '%s'.";
    }

    @Override
    public final void ignoringAjpRequestWithPrefixCode(byte prefix) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.ignoringAjpRequestWithPrefixCode$str(), (Object)prefix);
    }

    protected String ignoringAjpRequestWithPrefixCode$str() {
        return "UT005011: Ignoring AJP request with prefix %s";
    }

    @Override
    public final void ioException(IOException e) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)e, this.ioException$str(), new Object[0]);
    }

    protected String ioException$str() {
        return "UT005013: An IOException occurred";
    }

    @Override
    public final void failedToParseRequest(Throwable e) {
        this.log.logf(FQCN, Logger.Level.DEBUG, e, this.failedToParseRequest$str(), new Object[0]);
    }

    protected String failedToParseRequest$str() {
        return "UT005014: Failed to parse request";
    }

    @Override
    public final void errorRotatingAccessLog(IOException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorRotatingAccessLog$str(), new Object[0]);
    }

    protected String errorRotatingAccessLog$str() {
        return "UT005015: Error rotating access log";
    }

    @Override
    public final void errorWritingAccessLog(IOException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorWritingAccessLog$str(), new Object[0]);
    }

    protected String errorWritingAccessLog$str() {
        return "UT005016: Error writing access log";
    }

    @Override
    public final void unknownVariable(String token) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.unknownVariable$str(), (Object)token);
    }

    protected String unknownVariable$str() {
        return "UT005017: Unknown variable %s. For the literal percent character use two percent characters: '%%'";
    }

    @Override
    public final void exceptionInvokingCloseListener(ServerConnection.CloseListener l, Throwable e) {
        this.log.logf(FQCN, Logger.Level.ERROR, e, this.exceptionInvokingCloseListener$str(), (Object)l);
    }

    protected String exceptionInvokingCloseListener$str() {
        return "UT005018: Exception invoking close listener %s";
    }

    @Override
    public final void errorWritingJDBCLog(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorWritingJDBCLog$str(), new Object[0]);
    }

    protected String errorWritingJDBCLog$str() {
        return "UT005020: Error writing JDBC log";
    }

    @Override
    public final void exceptionGeneratingErrorPage(Exception e, String location) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.exceptionGeneratingErrorPage$str(), (Object)location);
    }

    protected String exceptionGeneratingErrorPage$str() {
        return "UT005022: Exception generating error page %s";
    }

    @Override
    public final void exceptionHandlingRequest(Throwable t2, String requestURI) {
        this.log.logf(FQCN, Logger.Level.ERROR, t2, this.exceptionHandlingRequest$str(), (Object)requestURI);
    }

    protected String exceptionHandlingRequest$str() {
        return "UT005023: Exception handling request to %s";
    }

    @Override
    public final void couldNotRegisterChangeListener(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.couldNotRegisterChangeListener$str(), new Object[0]);
    }

    protected String couldNotRegisterChangeListener$str() {
        return "UT005024: Could not register resource change listener for caching resource manager, automatic invalidation of cached resource will not work";
    }

    @Override
    public final void timingOutRequest(String requestURI) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.timingOutRequest$str(), (Object)requestURI);
    }

    protected String timingOutRequest$str() {
        return "UT005027: Timing out request to %s";
    }

    @Override
    public final void proxyRequestFailed(String requestURI, Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.proxyRequestFailed$str(), (Object)requestURI);
    }

    protected String proxyRequestFailed$str() {
        return "UT005028: Proxy request to %s failed";
    }

    @Override
    public final void proxyFailedToConnectToBackend(String requestURI, URI uri) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.proxyFailedToConnectToBackend$str(), (Object)requestURI, (Object)uri);
    }

    protected String proxyFailedToConnectToBackend$str() {
        return "UT005031: Proxy request to %s could not connect to backend server %s";
    }

    @Override
    public final void listenerNotProgressing() {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.listenerNotProgressing$str(), new Object[0]);
    }

    protected String listenerNotProgressing$str() {
        return "UT005032: Listener not making progress on framed channel, closing channel to prevent infinite loop";
    }

    @Override
    public final void remoteEndpointFailedToSendInitialSettings(int type) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.remoteEndpointFailedToSendInitialSettings$str(), (Object)type);
    }

    protected String remoteEndpointFailedToSendInitialSettings$str() {
        return "UT005034: Remote endpoint failed to send initial settings frame in HTTP2 connection, frame type %s";
    }

    @Override
    public final void parseRequestTimedOut(SocketAddress remoteAddress) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.parseRequestTimedOut$str(), (Object)remoteAddress);
    }

    protected String parseRequestTimedOut$str() {
        return "UT005035: Closing channel because of parse timeout for remote address %s";
    }

    @Override
    public final void noALPNFallback(SocketAddress address) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.noALPNFallback$str(), (Object)address);
    }

    protected String noALPNFallback$str() {
        return "UT005036: ALPN negotiation failed for %s and no fallback defined, closing connection";
    }

    @Override
    public final void stickySessionCookieLengthTruncated(String original, String current) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.stickySessionCookieLengthTruncated$str(), (Object)original, (Object)current);
    }

    protected String stickySessionCookieLengthTruncated$str() {
        return "UT005037: Name of the cookie containing the session id, %s, had been too long and was truncated to: %s";
    }

    @Override
    public final void balancerCreated(int id, String name2, boolean stickySession, String stickySessionCookie, String stickySessionPath, boolean stickySessionRemove, boolean stickySessionForce, int waitWorker, int maxattempts) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.balancerCreated$str(), id, name2, stickySession, stickySessionCookie, stickySessionPath, stickySessionRemove, stickySessionForce, waitWorker, maxattempts);
    }

    protected String balancerCreated$str() {
        return "UT005038: Balancer created: id: %s, name: %s, stickySession: %s, stickySessionCookie: %s, stickySessionPath: %s, stickySessionRemove: %s, stickySessionForce: %s, waitWorker: %s, maxattempts: %s";
    }

    @Override
    public final void proxyAdvertisementsStarted(String address, int frequency) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.proxyAdvertisementsStarted$str(), (Object)address, (Object)frequency);
    }

    protected String proxyAdvertisementsStarted$str() {
        return "UT005039: Undertow starts mod_cluster proxy advertisements on %s with frequency %s ms";
    }

    @Override
    public final void proxyAdvertiseMessagePayload(String payload) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.proxyAdvertiseMessagePayload$str(), (Object)payload);
    }

    protected String proxyAdvertiseMessagePayload$str() {
        return "UT005040: Gonna send payload:\n%s";
    }

    @Override
    public final void proxyAdvertiseCannotSendMessage(Exception e, InetSocketAddress address) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.proxyAdvertiseCannotSendMessage$str(), (Object)address);
    }

    protected String proxyAdvertiseCannotSendMessage$str() {
        return "UT005041: Cannot send advertise message. Address: %s";
    }

    @Override
    public final void mcmpHandlerCreated() {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.mcmpHandlerCreated$str(), new Object[0]);
    }

    protected String mcmpHandlerCreated$str() {
        return "UT005042: Undertow mod_cluster proxy MCMPHandler created";
    }

    @Override
    public final void mcmpProcessingError(String type, String errString) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.mcmpProcessingError$str(), (Object)type, (Object)errString);
    }

    protected String mcmpProcessingError$str() {
        return "UT005043: Error in processing MCMP commands: Type:%s, Mess: %s";
    }

    @Override
    public final void removingNode(String jvmRoute) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.removingNode$str(), (Object)jvmRoute);
    }

    protected String removingNode$str() {
        return "UT005044: Removing node %s";
    }

    @Override
    public final void registeringContext(String contextPath, String jvmRoute) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.registeringContext2$str(), (Object)contextPath, (Object)jvmRoute);
    }

    protected String registeringContext2$str() {
        return "UT005045: Registering context %s, for node %s";
    }

    @Override
    public final void registeringContext(String contextPath, String jvmRoute, List<String> aliases) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.registeringContext3$str(), (Object)contextPath, (Object)jvmRoute, (Object)aliases);
    }

    protected String registeringContext3$str() {
        return "UT005046: Registering context %s, for node %s, with aliases %s";
    }

    @Override
    public final void unregisteringContext(String contextPath, String jvmRoute) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.unregisteringContext$str(), (Object)contextPath, (Object)jvmRoute);
    }

    protected String unregisteringContext$str() {
        return "UT005047: Unregistering context %s, from node %s";
    }

    @Override
    public final void nodeIsInError(String jvmRoute) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.nodeIsInError$str(), (Object)jvmRoute);
    }

    protected String nodeIsInError$str() {
        return "UT005048: Node %s in error";
    }

    @Override
    public final void nodeConfigCreated(URI connectionURI, String balancer, String domain, String jvmRoute, boolean flushPackets, int flushwait, int ping, long ttl, int timeout, int maxConnections, int cacheConnections, int requestQueueSize, boolean queueNewRequests) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.nodeConfigCreated$str(), connectionURI, balancer, domain, jvmRoute, flushPackets, flushwait, ping, ttl, timeout, maxConnections, cacheConnections, requestQueueSize, queueNewRequests);
    }

    protected String nodeConfigCreated$str() {
        return "UT005049: NodeConfig created: connectionURI: %s, balancer: %s, load balancing group: %s, jvmRoute: %s, flushPackets: %s, flushwait: %s, ping: %s,ttl: %s, timeout: %s, maxConnections: %s, cacheConnections: %s, requestQueueSize: %s, queueNewRequests: %s";
    }

    @Override
    public final void failedToProcessManagementReq(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToProcessManagementReq$str(), new Object[0]);
    }

    protected String failedToProcessManagementReq$str() {
        return "UT005050: Failed to process management request";
    }

    @Override
    public final void failedToSendPingResponse(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToSendPingResponse$str(), new Object[0]);
    }

    protected String failedToSendPingResponse$str() {
        return "UT005051: Failed to send ping response";
    }

    @Override
    public final void failedToSendPingResponseDBG(Exception e, String node, String jvmRoute) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)e, this.failedToSendPingResponseDBG$str(), (Object)node, (Object)jvmRoute);
    }

    protected String failedToSendPingResponseDBG$str() {
        return "UT005052: Failed to send ping response, node.getJvmRoute(): %s, jvmRoute: %s";
    }

    @Override
    public final void registeringNode(String jvmRoute, URI connectionURI) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.registeringNode$str(), (Object)jvmRoute, (Object)connectionURI);
    }

    protected String registeringNode$str() {
        return "UT005053: Registering node %s, connection: %s";
    }

    @Override
    public final void mcmpKeyValue(HttpString name2, String value) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.mcmpKeyValue$str(), (Object)name2, (Object)value);
    }

    protected String mcmpKeyValue$str() {
        return "UT005054: MCMP processing, key: %s, value: %s";
    }

    @Override
    public final void httpClientPingTask(URI connection) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.httpClientPingTask$str(), (Object)connection);
    }

    protected String httpClientPingTask$str() {
        return "UT005055: HttpClientPingTask run for connection: %s";
    }

    @Override
    public final void receivedNodeLoad(String jvmRoute, String loadValue) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.receivedNodeLoad$str(), (Object)jvmRoute, (Object)loadValue);
    }

    protected String receivedNodeLoad$str() {
        return "UT005056: Received node load in STATUS message, node jvmRoute: %s, load: %s";
    }

    @Override
    public final void mcmpSendingResponse(InetSocketAddress destination, int status, HeaderMap headers, String response) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.mcmpSendingResponse$str(), destination, status, headers, response);
    }

    protected String mcmpSendingResponse$str() {
        return "UT005057: Sending MCMP response to destination: %s, HTTP status: %s, Headers: %s, response: %s";
    }

    @Override
    public final void potentialCrossTalking(InetAddress group, String s2, String localizedMessage) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.potentialCrossTalking$str(), (Object)group, (Object)s2, (Object)localizedMessage);
    }

    protected String potentialCrossTalking$str() {
        return "UT005058: Could not bind multicast socket to %s (%s address): %s; make sure your multicast address is of the same type as the IP stack (IPv4 or IPv6). Multicast socket will not be bound to an address, but this may lead to cross talking (see http://www.jboss.org/community/docs/DOC-9469 for details).";
    }

    @Override
    public final void oldStylePredicateSyntax(String string) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.oldStylePredicateSyntax$str(), (Object)string);
    }

    protected String oldStylePredicateSyntax$str() {
        return "UT005060: Predicate %s uses old style square braces to define predicates, which will be removed in a future release. predicate[value] should be changed to predicate(value)";
    }

    protected String maxRestartsExceeded$str() {
        return "UT005061: More than %s restarts detected, breaking assumed infinite loop";
    }

    @Override
    public final IllegalStateException maxRestartsExceeded(int maxRestarts) {
        IllegalStateException result2 = new IllegalStateException(String.format(this.getLoggingLocale(), this.maxRestartsExceeded$str(), maxRestarts));
        UndertowLogger_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    @Override
    public final void extendedAccessLogPatternParseError(Throwable t2) {
        this.log.logf(FQCN, Logger.Level.ERROR, t2, this.extendedAccessLogPatternParseError$str(), new Object[0]);
    }

    protected String extendedAccessLogPatternParseError$str() {
        return "UT005062: Pattern parse error";
    }

    @Override
    public final void extendedAccessLogUnknownToken(String token) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.extendedAccessLogUnknownToken$str(), (Object)token);
    }

    protected String extendedAccessLogUnknownToken$str() {
        return "UT005063: Unable to decode with rest of chars starting: %s";
    }

    @Override
    public final void extendedAccessLogMissingClosing() {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.extendedAccessLogMissingClosing$str(), new Object[0]);
    }

    protected String extendedAccessLogMissingClosing$str() {
        return "UT005064: No closing ) found for in decode";
    }

    @Override
    public final void extendedAccessLogCannotDecode(String chars) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.extendedAccessLogCannotDecode$str(), (Object)chars);
    }

    protected String extendedAccessLogCannotDecode$str() {
        return "UT005065: The next characters couldn't be decoded: %s";
    }

    @Override
    public final void extendedAccessLogCannotDecodeXParamValue(String value) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.extendedAccessLogCannotDecodeXParamValue$str(), (Object)value);
    }

    protected String extendedAccessLogCannotDecodeXParamValue$str() {
        return "UT005066: X param for servlet request, couldn't decode value: %s";
    }

    @Override
    public final void extendedAccessLogBadXParam() {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.extendedAccessLogBadXParam$str(), new Object[0]);
    }

    protected String extendedAccessLogBadXParam$str() {
        return "UT005067: X param in wrong format. Needs to be 'x-#(...)'";
    }

    @Override
    public final void extendedAccessLogEmptyPattern() {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.extendedAccessLogEmptyPattern$str(), new Object[0]);
    }

    protected String extendedAccessLogEmptyPattern$str() {
        return "UT005068: Pattern was just empty or whitespace";
    }

    @Override
    public final void failedToWriteJdbcAccessLog(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToWriteJdbcAccessLog$str(), new Object[0]);
    }

    protected String failedToWriteJdbcAccessLog$str() {
        return "UT005069: Failed to write JDBC access log";
    }

    @Override
    public final void failedToWritePreCachedFile() {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.failedToWritePreCachedFile$str(), new Object[0]);
    }

    protected String failedToWritePreCachedFile$str() {
        return "UT005070: Failed to write pre-cached file";
    }

    @Override
    public final void undertowRequestFailed(Throwable t2, HttpServerExchange exchange) {
        this.log.logf(FQCN, Logger.Level.ERROR, t2, this.undertowRequestFailed$str(), (Object)exchange);
    }

    protected String undertowRequestFailed$str() {
        return "UT005071: Undertow request failed %s";
    }

    @Override
    public final void stuckThreadDetected(String threadName, long threadId, long active, Date start, String requestUri, int threshold, int stuckCount, Throwable stackTrace) {
        this.log.logf(FQCN, Logger.Level.WARN, stackTrace, this.stuckThreadDetected$str(), threadName, threadId, active, start, requestUri, threshold, stuckCount);
    }

    protected String stuckThreadDetected$str() {
        return "UT005072: Thread %s (id=%s) has been active for %s milliseconds (since %s) to serve the same request for %s and may be stuck (configured threshold for this StuckThreadDetectionValve is %s seconds). There is/are %s thread(s) in total that are monitored by this Valve and may be stuck.";
    }

    @Override
    public final void stuckThreadCompleted(String threadName, long threadId, long active, int stuckCount) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.stuckThreadCompleted$str(), threadName, threadId, active, stuckCount);
    }

    protected String stuckThreadCompleted$str() {
        return "UT005073: Thread %s (id=%s) was previously reported to be stuck but has completed. It was active for approximately %s milliseconds. There is/are still %s thread(s) that are monitored by this Valve and may be stuck.";
    }

    @Override
    public final void failedToInvokeFailedCallback(ServerSentEventConnection.EventCallback callback, Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToInvokeFailedCallback$str(), (Object)callback);
    }

    protected String failedToInvokeFailedCallback$str() {
        return "UT005074: Failed to invoke error callback %s for SSE task";
    }

    protected String unableToResolveModClusterManagementHost$str() {
        return "UT005075: Unable to resolve mod_cluster management host's address for '%s'";
    }

    @Override
    public final IllegalStateException unableToResolveModClusterManagementHost(String providedHost) {
        IllegalStateException result2 = new IllegalStateException(String.format(this.getLoggingLocale(), this.unableToResolveModClusterManagementHost$str(), providedHost));
        UndertowLogger_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    @Override
    public final void sslReadLoopDetected(SslConduit sslConduit) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.sslReadLoopDetected$str(), (Object)sslConduit);
    }

    protected String sslReadLoopDetected$str() {
        return "UT005076: SSL read loop detected. This should not happen, please report this to the Undertow developers. Current state %s";
    }

    @Override
    public final void sslBufferOverflow(SslConduit sslConduit) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.sslBufferOverflow$str(), (Object)sslConduit);
    }

    protected String sslBufferOverflow$str() {
        return "UT005077: SSL unwrap buffer overflow detected. This should not happen, please report this to the Undertow developers. Current state %s";
    }

    @Override
    public final void alpnConnectionFailed(SslConnection connection) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.alpnConnectionFailed$str(), (Object)connection);
    }

    protected String alpnConnectionFailed$str() {
        return "UT005079: ALPN negotiation on %s failed";
    }

    @Override
    public final void resumedAndDispatched() {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.resumedAndDispatched$str(), new Object[0]);
    }

    protected String resumedAndDispatched$str() {
        return "UT005080: HttpServerExchange cannot have both async IO resumed and dispatch() called in the same cycle";
    }

    @Override
    public final void cannotProxyStartedRequest(HttpServerExchange exchange) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.cannotProxyStartedRequest$str(), (Object)exchange);
    }

    protected String cannotProxyStartedRequest$str() {
        return "UT005081: Response has already been started, cannot proxy request %s";
    }

    protected String cannotUseWildcardAddressAsModClusterManagementHost$str() {
        return "UT005082: Configured mod_cluster management host address cannot be a wildcard address (%s)!";
    }

    @Override
    public final IllegalArgumentException cannotUseWildcardAddressAsModClusterManagementHost(String providedAddress) {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.cannotUseWildcardAddressAsModClusterManagementHost$str(), providedAddress));
        UndertowLogger_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String unexpectedEndOfCompressedInput$str() {
        return "UT005083: Unexpected end of compressed input";
    }

    @Override
    public final IOException unexpectedEndOfCompressedInput() {
        IOException result2 = new IOException(String.format(this.getLoggingLocale(), this.unexpectedEndOfCompressedInput$str(), new Object[0]));
        UndertowLogger_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String dataLargerThanContentLength$str() {
        return "UT005084: Attempted to write %s bytes however content-length has been set to %s";
    }

    @Override
    public final IOException dataLargerThanContentLength(long totalToWrite, long responseContentLength) {
        IOException result2 = new IOException(String.format(this.getLoggingLocale(), this.dataLargerThanContentLength$str(), totalToWrite, responseContentLength));
        UndertowLogger_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    @Override
    public final void responseWasNotTerminated(ServerConnection connection, HttpServerExchange exchange) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.responseWasNotTerminated$str(), (Object)connection, (Object)exchange);
    }

    protected String responseWasNotTerminated$str() {
        return "UT005085: Connection %s for exchange %s was not closed cleanly, forcibly closing connection";
    }

    @Override
    public final void failedToAcceptSSLRequest(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToAcceptSSLRequest$str(), new Object[0]);
    }

    protected String failedToAcceptSSLRequest$str() {
        return "UT005086: Failed to accept SSL request";
    }

    @Override
    public final void closeAsyncFailed(IOException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.closeAsyncFailed$str(), new Object[0]);
    }

    protected String closeAsyncFailed$str() {
        return "UT005088: Failed to execute ServletOutputStream.closeAsync() on IO thread";
    }

    protected String nullParameter$str() {
        return "UT005089: Method parameter '%s' cannot be null";
    }

    @Override
    public final IllegalArgumentException nullParameter(String name2) {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nullParameter$str(), name2));
        UndertowLogger_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    @Override
    public final void handleUnexpectedFailure(Throwable t2) {
        this.log.logf(FQCN, Logger.Level.ERROR, t2, this.handleUnexpectedFailure$str(), new Object[0]);
    }

    protected String handleUnexpectedFailure$str() {
        return "UT005090: Unexpected failure";
    }

    @Override
    public final void directBufferDeallocatorInitializationFailed(Throwable t2) {
        this.log.logf(FQCN, Logger.Level.ERROR, t2, this.directBufferDeallocatorInitializationFailed$str(), new Object[0]);
    }

    protected String directBufferDeallocatorInitializationFailed$str() {
        return "UT005091: Failed to initialize DirectByteBufferDeallocator";
    }

    @Override
    public final void directBufferDeallocationFailed(Throwable t2) {
        this.log.logf(FQCN, Logger.Level.DEBUG, t2, this.directBufferDeallocationFailed$str(), new Object[0]);
    }

    protected String directBufferDeallocationFailed$str() {
        return "UT005092: Failed to free direct buffer";
    }

    @Override
    public final void blockingReadTimedOut(ReadTimeoutException rte) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)rte, this.blockingReadTimedOut$str(), new Object[0]);
    }

    protected String blockingReadTimedOut$str() {
        return "UT005093: Blocking read timed out";
    }

    @Override
    public final void blockingWriteTimedOut(WriteTimeoutException rte) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)rte, this.blockingWriteTimedOut$str(), new Object[0]);
    }

    protected String blockingWriteTimedOut$str() {
        return "UT005094: Blocking write timed out";
    }

    @Override
    public final void sslEngineDelegatedTaskRejected(RejectedExecutionException ree) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)ree, this.sslEngineDelegatedTaskRejected$str(), new Object[0]);
    }

    protected String sslEngineDelegatedTaskRejected$str() {
        return "UT005095: SSLEngine delegated task was rejected";
    }

    @Override
    public final void authenticationFailedFor(String header, HttpServerExchange exchange, Exception e) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)e, this.authenticationFailedFor$str(), (Object)header, (Object)exchange);
    }

    protected String authenticationFailedFor$str() {
        return "UT005096: Authentication failed for digest header %s in %s";
    }

    @Override
    public final void failedToObtainSubject(HttpServerExchange exchange, GeneralSecurityException e) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)e, this.failedToObtainSubject$str(), (Object)exchange);
    }

    protected String failedToObtainSubject$str() {
        return "UT005097: Failed to obtain subject for %s";
    }

    @Override
    public final void failedToNegotiateAtGSSAPI(HttpServerExchange exchange, Throwable e) {
        this.log.logf(FQCN, Logger.Level.DEBUG, e, this.failedToNegotiateAtGSSAPI$str(), (Object)exchange);
    }

    protected String failedToNegotiateAtGSSAPI$str() {
        return "UT005098: GSSAPI negotiation failed for %s";
    }

    @Override
    public final void failedToCreateSSOForSession(String sessionId) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.failedToCreateSSOForSession$str(), (Object)sessionId);
    }

    protected String failedToCreateSSOForSession$str() {
        return "UT005099: Failed to create SSO for session '%s'";
    }

    @Override
    public final void failedToListPathsForFile(Path f) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.failedToListPathsForFile$str(), (Object)f);
    }

    protected String failedToListPathsForFile$str() {
        return "UT005100: Failed to list paths for '%s'";
    }

    @Override
    public final void noSourceToListResourcesFrom() {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.noSourceToListResourcesFrom$str(), new Object[0]);
    }

    protected String noSourceToListResourcesFrom$str() {
        return "UT005101: No source to list resources from";
    }

    @Override
    public final void noFrameflushInTimeout(long timeoutMiliseconds) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.noFrameflushInTimeout$str(), (Object)timeoutMiliseconds);
    }

    protected String noFrameflushInTimeout$str() {
        return "UT005102: Flushing waiting in a frame more than %s miliseconds. The framed channel will be forcibly closed.";
    }

    @Override
    public final void wrongCacheTTLValue(int ttl, int defaultTtl) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.wrongCacheTTLValue$str(), (Object)ttl, (Object)defaultTtl);
    }

    protected String wrongCacheTTLValue$str() {
        return "UT005103: Cache TTL set to wrong value '%sms'. Defaulting to '%sms'.";
    }

    @Override
    public final void failedToRegisterChangeListener(int ttl, int defaultTtl, Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.failedToRegisterChangeListener$str(), (Object)ttl, (Object)defaultTtl);
    }

    protected String failedToRegisterChangeListener$str() {
        return "UT005104: Could not register resource change listener for caching resource manager, automatic invalidation of cached resource will not work. TTL value configured '%sms'. Defaulting to '%sms'.";
    }

    @Override
    public final void cacheEntryMismatchContent(Object key, int cacheIndicatedSize, long written) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.cacheEntryMismatchContent$str(), key, (Object)cacheIndicatedSize, (Object)written);
    }

    protected String cacheEntryMismatchContent$str() {
        return "UT005105: Cache entry content mismatch for '%s'. Expected length '%s', but was '%s'.";
    }

    @Override
    public final void contentEntryMismatch(Object key, long indicatedSize, long written) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.contentEntryMismatch$str(), key, (Object)indicatedSize, (Object)written);
    }

    protected String contentEntryMismatch$str() {
        return "UT005106: Content mismatch for '%s'. Expected length '%s', but was '%s'.";
    }

    @Override
    public final void failedToSetWSTimeout(Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.failedToSetWSTimeout$str(), new Object[0]);
    }

    protected String failedToSetWSTimeout$str() {
        return "UT005107: Failed to set web socket timeout.";
    }
}

