/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics.influxdb;

import com.networknt.metrics.TimeSeriesDbSender;
import io.dropwizard.metrics.Counter;
import io.dropwizard.metrics.Counting;
import io.dropwizard.metrics.Gauge;
import io.dropwizard.metrics.Histogram;
import io.dropwizard.metrics.Meter;
import io.dropwizard.metrics.Metered;
import io.dropwizard.metrics.Metric;
import io.dropwizard.metrics.MetricFilter;
import io.dropwizard.metrics.MetricName;
import io.dropwizard.metrics.MetricRegistry;
import io.dropwizard.metrics.ScheduledReporter;
import io.dropwizard.metrics.Snapshot;
import io.dropwizard.metrics.Timer;
import io.dropwizard.metrics.influxdb.data.InfluxDbPoint;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InfluxDbReporter
extends ScheduledReporter {
    private static final Logger logger = LoggerFactory.getLogger(InfluxDbReporter.class);
    private final TimeSeriesDbSender influxDb;
    private final boolean skipIdleMetrics;
    private final Map<MetricName, Long> previousValues;

    private InfluxDbReporter(MetricRegistry registry, TimeSeriesDbSender influxDb, Map<String, String> tags, TimeUnit rateUnit, TimeUnit durationUnit, MetricFilter filter, boolean skipIdleMetrics) {
        super(registry, "influxDb-reporter", filter, rateUnit, durationUnit);
        this.influxDb = influxDb;
        influxDb.setTags(tags);
        this.skipIdleMetrics = skipIdleMetrics;
        this.previousValues = new TreeMap<MetricName, Long>();
    }

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    @Override
    public void report(SortedMap<MetricName, Gauge> gauges, SortedMap<MetricName, Counter> counters, SortedMap<MetricName, Histogram> histograms, SortedMap<MetricName, Meter> meters, SortedMap<MetricName, Timer> timers) {
        long now = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug("InfluxDbReporter report is called with counter size " + counters.size());
        }
        try {
            this.influxDb.flush();
            for (Map.Entry<MetricName, Gauge> entry : gauges.entrySet()) {
                this.reportGauge(entry.getKey(), entry.getValue(), now);
            }
            for (Map.Entry<MetricName, Metric> entry : counters.entrySet()) {
                this.reportCounter(entry.getKey(), (Counter)entry.getValue(), now);
            }
            for (Map.Entry<MetricName, Metric> entry : histograms.entrySet()) {
                this.reportHistogram(entry.getKey(), (Histogram)entry.getValue(), now);
            }
            for (Map.Entry<MetricName, Metric> entry : meters.entrySet()) {
                this.reportMeter(entry.getKey(), (Metered)entry.getValue(), now);
            }
            for (Map.Entry<MetricName, Metric> entry : timers.entrySet()) {
                this.reportTimer(entry.getKey(), (Timer)entry.getValue(), now);
            }
            if (this.influxDb.hasSeriesData()) {
                this.influxDb.writeData();
            }
            for (Map.Entry<MetricName, Metric> entry : counters.entrySet()) {
                Counter counter = (Counter)entry.getValue();
                long count = counter.getCount();
                counter.dec(count);
            }
        }
        catch (Exception e) {
            logger.error("Unable to report to InfluxDB. Discarding data.", e);
        }
    }

    private void reportTimer(MetricName name2, Timer timer, long now) {
        if (this.canSkipMetric(name2, timer)) {
            return;
        }
        Snapshot snapshot = timer.getSnapshot();
        HashMap<String, String> apiTags = new HashMap<String, String>(name2.getTags());
        String apiName = (String)apiTags.remove("api");
        HashMap<String, String> clientTags = new HashMap<String, String>(name2.getTags());
        String clientId = (String)clientTags.remove("clientId");
        this.influxDb.appendPoints(new InfluxDbPoint(apiName + "." + name2.getKey() + ".min", apiTags, now, this.format(this.convertDuration(snapshot.getMin()))));
        this.influxDb.appendPoints(new InfluxDbPoint(apiName + "." + name2.getKey() + ".max", apiTags, now, this.format(this.convertDuration(snapshot.getMax()))));
        this.influxDb.appendPoints(new InfluxDbPoint(apiName + "." + name2.getKey() + ".mean", apiTags, now, this.format(this.convertDuration(snapshot.getMean()))));
        if (clientId != null) {
            this.influxDb.appendPoints(new InfluxDbPoint(clientId + "." + name2.getKey() + ".min", clientTags, now, this.format(this.convertDuration(snapshot.getMin()))));
            this.influxDb.appendPoints(new InfluxDbPoint(clientId + "." + name2.getKey() + ".max", clientTags, now, this.format(this.convertDuration(snapshot.getMax()))));
            this.influxDb.appendPoints(new InfluxDbPoint(clientId + "." + name2.getKey() + ".mean", clientTags, now, this.format(this.convertDuration(snapshot.getMean()))));
        }
    }

    private void reportHistogram(MetricName name2, Histogram histogram, long now) {
        if (this.canSkipMetric(name2, histogram)) {
            return;
        }
        Snapshot snapshot = histogram.getSnapshot();
        HashMap<String, String> apiTags = new HashMap<String, String>(name2.getTags());
        String apiName = (String)apiTags.remove("api");
        HashMap<String, String> clientTags = new HashMap<String, String>(name2.getTags());
        String clientId = (String)clientTags.remove("clientId");
        this.influxDb.appendPoints(new InfluxDbPoint(apiName + "." + name2.getKey() + ".count", apiTags, now, this.format(histogram.getCount())));
        this.influxDb.appendPoints(new InfluxDbPoint(apiName + "." + name2.getKey() + ".min", apiTags, now, this.format(snapshot.getMin())));
        this.influxDb.appendPoints(new InfluxDbPoint(apiName + "." + name2.getKey() + ".max", apiTags, now, this.format(snapshot.getMax())));
        this.influxDb.appendPoints(new InfluxDbPoint(apiName + "." + name2.getKey() + ".mean", apiTags, now, this.format(snapshot.getMean())));
        if (clientId != null) {
            this.influxDb.appendPoints(new InfluxDbPoint(clientId + "." + name2.getKey() + ".count", clientTags, now, this.format(histogram.getCount())));
            this.influxDb.appendPoints(new InfluxDbPoint(clientId + "." + name2.getKey() + ".min", clientTags, now, this.format(snapshot.getMin())));
            this.influxDb.appendPoints(new InfluxDbPoint(clientId + "." + name2.getKey() + ".max", clientTags, now, this.format(snapshot.getMax())));
            this.influxDb.appendPoints(new InfluxDbPoint(clientId + "." + name2.getKey() + ".mean", clientTags, now, this.format(snapshot.getMean())));
        }
    }

    private void reportCounter(MetricName name2, Counter counter, long now) {
        HashMap<String, String> apiTags = new HashMap<String, String>(name2.getTags());
        String apiName = (String)apiTags.remove("api");
        HashMap<String, String> clientTags = new HashMap<String, String>(name2.getTags());
        String clientId = (String)clientTags.remove("clientId");
        this.influxDb.appendPoints(new InfluxDbPoint(apiName + "." + name2.getKey() + ".count", apiTags, now, this.format(counter.getCount())));
        if (clientId != null) {
            this.influxDb.appendPoints(new InfluxDbPoint(clientId + "." + name2.getKey() + ".count", clientTags, now, this.format(counter.getCount())));
        }
    }

    private void reportGauge(MetricName name2, Gauge<?> gauge, long now) {
        String value = this.format(gauge.getValue());
        if (value != null) {
            HashMap<String, String> apiTags = new HashMap<String, String>(name2.getTags());
            String apiName = (String)apiTags.remove("api");
            HashMap<String, String> clientTags = new HashMap<String, String>(name2.getTags());
            String clientId = (String)clientTags.remove("clientId");
            this.influxDb.appendPoints(new InfluxDbPoint(apiName + "." + name2.getKey(), apiTags, now, value));
            if (clientId != null) {
                this.influxDb.appendPoints(new InfluxDbPoint(clientId + "." + name2.getKey(), clientTags, now, value));
            }
        }
    }

    private void reportMeter(MetricName name2, Metered meter, long now) {
        if (this.canSkipMetric(name2, meter)) {
            return;
        }
        HashMap<String, String> apiTags = new HashMap<String, String>(name2.getTags());
        String apiName = (String)apiTags.remove("api");
        HashMap<String, String> clientTags = new HashMap<String, String>(name2.getTags());
        String clientId = (String)clientTags.remove("clientId");
        this.influxDb.appendPoints(new InfluxDbPoint(apiName + "." + name2.getKey() + ".count", apiTags, now, this.format(meter.getCount())));
        if (clientId != null) {
            this.influxDb.appendPoints(new InfluxDbPoint(clientId + "." + name2.getKey() + ".count", clientTags, now, this.format(meter.getCount())));
        }
    }

    private boolean canSkipMetric(MetricName name2, Counting counting) {
        boolean isIdle;
        boolean bl = isIdle = this.calculateDelta(name2, counting.getCount()) == 0L;
        if (this.skipIdleMetrics && !isIdle) {
            this.previousValues.put(name2, counting.getCount());
        }
        return this.skipIdleMetrics && isIdle;
    }

    private long calculateDelta(MetricName name2, long count) {
        Long previous = this.previousValues.get(name2);
        if (previous == null) {
            return -1L;
        }
        if (count < previous) {
            logger.warn("Saw a non-monotonically increasing value for metric '{}'", (Object)name2);
            return 0L;
        }
        return count - previous;
    }

    private String format(Object o) {
        if (o instanceof Float) {
            return this.format(((Float)o).doubleValue());
        }
        if (o instanceof Double) {
            return this.format((Double)o);
        }
        if (o instanceof Byte) {
            return this.format(((Byte)o).longValue());
        }
        if (o instanceof Short) {
            return this.format(((Short)o).longValue());
        }
        if (o instanceof Integer) {
            return this.format(((Integer)o).longValue());
        }
        if (o instanceof Long) {
            return this.format((Long)o);
        }
        return null;
    }

    private String format(long n) {
        return Long.toString(n);
    }

    private String format(double v) {
        return String.format(Locale.US, "%2.2f", v);
    }

    public static final class Builder {
        private final MetricRegistry registry;
        private Map<String, String> tags;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private MetricFilter filter;
        private boolean skipIdleMetrics;

        private Builder(MetricRegistry registry) {
            this.registry = registry;
            this.tags = null;
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.filter = MetricFilter.ALL;
        }

        public Builder withTags(Map<String, String> tags) {
            this.tags = Collections.unmodifiableMap(tags);
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public Builder skipIdleMetrics(boolean skipIdleMetrics) {
            this.skipIdleMetrics = skipIdleMetrics;
            return this;
        }

        public InfluxDbReporter build(TimeSeriesDbSender influxDb) {
            return new InfluxDbReporter(this.registry, influxDb, this.tags, this.rateUnit, this.durationUnit, this.filter, this.skipIdleMetrics);
        }
    }
}

