/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics.influxdb;

import com.networknt.exception.ClientException;
import com.networknt.http.client.HttpClientRequest;
import com.networknt.http.client.HttpMethod;
import com.networknt.metrics.TimeSeriesDbSender;
import io.dropwizard.metrics.influxdb.InfluxDbReporter;
import io.dropwizard.metrics.influxdb.TimeUtils;
import io.dropwizard.metrics.influxdb.data.InfluxDbPoint;
import io.dropwizard.metrics.influxdb.data.InfluxDbWriteObject;
import java.net.URL;
import java.net.URLEncoder;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluxDbHttpSender
implements TimeSeriesDbSender {
    private static final Logger logger = LoggerFactory.getLogger(InfluxDbReporter.class);
    private final HttpClientRequest httpClientRequest = new HttpClientRequest();
    private final URL url;
    private final String path;
    private final InfluxDbWriteObject influxDbWriteObject;

    public InfluxDbHttpSender(String protocol, String hostname, int port, String database, String username, String password) throws Exception {
        this(protocol, hostname, port, database, username, password, TimeUnit.MILLISECONDS);
    }

    public InfluxDbHttpSender(String protocol, String hostname, int port, String database, String username, String password, TimeUnit timePrecision) throws Exception {
        this.url = new URL(protocol, hostname, port, "");
        String queryDb = String.format("db=%s", URLEncoder.encode(database, "UTF-8"));
        String queryCredential = String.format("u=%s&p=%s", URLEncoder.encode(username, "UTF8"), URLEncoder.encode(password, "UTF8"));
        String queryPrecision = String.format("precision=%s", TimeUtils.toTimePrecision(timePrecision));
        this.path = "/write?" + queryDb + "&" + queryCredential + "&" + queryPrecision;
        if (logger.isInfoEnabled()) {
            logger.info("InfluxDbHttpSender is created with path = " + this.path + " and host = " + String.valueOf(this.url));
        }
        this.influxDbWriteObject = new InfluxDbWriteObject(timePrecision);
    }

    @Override
    public void flush() {
        this.influxDbWriteObject.setPoints(new HashSet<InfluxDbPoint>());
    }

    @Override
    public boolean hasSeriesData() {
        return this.influxDbWriteObject.getPoints() != null && !this.influxDbWriteObject.getPoints().isEmpty();
    }

    @Override
    public void appendPoints(InfluxDbPoint point) {
        if (point != null) {
            this.influxDbWriteObject.getPoints().add(point);
        }
    }

    @Override
    public int writeData() throws Exception {
        String body = this.influxDbWriteObject.getBody();
        HttpRequest.Builder builder = this.httpClientRequest.initBuilder(this.url.toString() + this.path, HttpMethod.POST, Optional.of(body));
        builder.setHeader("Content-Type", "text/plain");
        HttpResponse<?> response = this.httpClientRequest.send(builder, HttpResponse.BodyHandlers.ofString());
        int statusCode = response.statusCode();
        if (statusCode >= 200 && statusCode < 300) {
            return statusCode;
        }
        logger.error("Server returned HTTP response code: " + statusCode + "for path: " + this.path + " and host: " + String.valueOf(this.url) + " with content :'" + (String)response.body() + "'");
        throw new ClientException("Server returned HTTP response code: " + statusCode + "for path: " + this.path + " and host: " + String.valueOf(this.url) + " with content :'" + (String)response.body() + "'");
    }

    @Override
    public void setTags(Map<String, String> tags) {
        if (tags != null) {
            this.influxDbWriteObject.setTags(tags);
        }
    }
}

