/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.log4j.redactor;

import io.confluent.log4j.redactor.RedactorPolicy;
import java.util.Enumeration;
import org.apache.log4j.Appender;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.rewrite.RewriteAppender;
import org.apache.log4j.spi.LoggingEvent;

public class RedactorAppender
extends RewriteAppender {
    private RedactorPolicy policy;
    private String[] appenderRefs;

    public void setPolicy(RedactorPolicy policy) {
        this.policy = policy;
    }

    public void setAppenderRefs(String refs) {
        this.appenderRefs = refs.split(",");
    }

    private void wrapAppender(Logger logger2, String[] appenders) {
        for (String appenderName : appenders) {
            Appender appender;
            if ((appenderName = appenderName.trim()).isEmpty() || (appender = logger2.getAppender(appenderName)) == null) continue;
            logger2.removeAppender(appenderName);
            RedactorAppender maskingAppender = new RedactorAppender();
            maskingAppender.setRewritePolicy(this.policy);
            maskingAppender.addAppender(appender);
            logger2.addAppender((Appender)maskingAppender);
        }
    }

    public void activateOptions() {
        super.activateOptions();
        Enumeration e = LogManager.getCurrentLoggers();
        while (e.hasMoreElements()) {
            Logger logger2 = (Logger)e.nextElement();
            this.wrapAppender(logger2, this.appenderRefs);
        }
        this.wrapAppender(LogManager.getRootLogger(), this.appenderRefs);
    }

    protected void append(LoggingEvent event) {
        super.append(event);
    }
}

