/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;

public class Jackson {
    private Jackson() {
    }

    public static ObjectMapper newObjectMapper() {
        Object mapper = JsonMapper.builder().enable(JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS).build();
        return Jackson.configure(mapper);
    }

    public static ObjectMapper newObjectMapper(JsonFactory jsonFactory) {
        Object mapper = JsonMapper.builder(jsonFactory).enable(JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS).build();
        return Jackson.configure(mapper);
    }

    private static ObjectMapper configure(ObjectMapper mapper) {
        mapper.registerModule(new ParameterNamesModule());
        mapper.registerModule(new Jdk8Module());
        mapper.registerModule(new JavaTimeModule());
        return mapper;
    }
}

