/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.dataformat.csv.CsvGenerator;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvParser;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.google.common.base.Ticker;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClientFactory;
import io.confluent.kafka.schemaregistry.client.rest.entities.Rule;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleMode;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaResponse;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.rules.ErrorAction;
import io.confluent.kafka.schemaregistry.rules.NoneAction;
import io.confluent.kafka.schemaregistry.rules.RuleAction;
import io.confluent.kafka.schemaregistry.rules.RuleBase;
import io.confluent.kafka.schemaregistry.rules.RuleConditionException;
import io.confluent.kafka.schemaregistry.rules.RuleContext;
import io.confluent.kafka.schemaregistry.rules.RuleException;
import io.confluent.kafka.schemaregistry.rules.RuleExecutor;
import io.confluent.kafka.schemaregistry.utils.QualifiedSubject;
import io.confluent.kafka.serializers.AbstractKafkaSchemaSerDeConfig;
import io.confluent.kafka.serializers.context.NullContextNameStrategy;
import io.confluent.kafka.serializers.context.strategy.ContextNameStrategy;
import io.confluent.kafka.serializers.subject.SubjectNameStrategy;
import io.confluent.kafka.serializers.subject.TopicNameStrategy;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.DisconnectException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.errors.ThrottlingQuotaExceededException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKafkaSchemaSerDe
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(AbstractKafkaSchemaSerDe.class);
    protected static final byte MAGIC_BYTE = 0;
    protected static final int idSize = 4;
    protected static final int DEFAULT_CACHE_CAPACITY = 1000;
    protected AbstractKafkaSchemaSerDeConfig config;
    protected Map<String, Object> configOriginals;
    protected SchemaRegistryClient schemaRegistry;
    protected Ticker ticker = Ticker.systemTicker();
    protected ContextNameStrategy contextNameStrategy = new NullContextNameStrategy();
    protected Object keySubjectNameStrategy = new TopicNameStrategy();
    protected Object valueSubjectNameStrategy = new TopicNameStrategy();
    protected Cache<SubjectSchema, ExtendedSchema> latestVersions;
    protected Cache<String, ExtendedSchema> latestWithMetadata;
    protected boolean useSchemaReflection;
    protected boolean useLatestVersion;
    protected Map<String, String> metadata;
    protected boolean enableRuleServiceLoader;
    protected Map<String, Map<String, RuleBase>> ruleExecutors;
    protected Map<String, Map<String, RuleBase>> ruleActions;
    protected boolean isKey;
    private Map<Rule, String> onSuccessActions;
    private Map<Rule, String> onFailureActions;
    private Map<Rule, Boolean> disabledFlags;
    private static final ErrorAction ERROR_ACTION = new ErrorAction();
    private static final NoneAction NONE_ACTION = new NoneAction();
    private static final String ON_SUCCESS = "onSuccess";
    private static final String ON_FAILURE = "onFailure";
    private static final String DISABLED = "disabled";
    private static final String PARAM = ".param.";
    private static final ThreadLocal<Object> key = new ThreadLocal();

    public static Object key() {
        return key.get();
    }

    public static void setKey(Object obj) {
        key.set(obj);
    }

    public static void clearKey() {
        key.remove();
    }

    protected Ticker ticker(SchemaRegistryClient client) {
        return client != null ? client.ticker() : Ticker.systemTicker();
    }

    protected void configureClientProperties(AbstractKafkaSchemaSerDeConfig config, SchemaProvider provider) {
        this.config = config;
        this.configOriginals = config.originals();
        if (this.schemaRegistry == null) {
            List<String> urls = config.getSchemaRegistryUrls();
            int maxSchemaObject = config.getMaxSchemasPerSubject();
            Map<String, Object> originals = config.originalsWithPrefix("");
            this.schemaRegistry = SchemaRegistryClientFactory.newClient(urls, maxSchemaObject, Collections.singletonList(provider), originals, config.requestHeaders());
        }
        this.contextNameStrategy = config.contextNameStrategy();
        this.keySubjectNameStrategy = config.keySubjectNameStrategy();
        this.valueSubjectNameStrategy = config.valueSubjectNameStrategy();
        this.useSchemaReflection = config.useSchemaReflection();
        this.useLatestVersion = config.useLatestVersion();
        int latestCacheSize = config.getLatestCacheSize();
        int latestCacheTtl = config.getLatestCacheTtl();
        CacheBuilder<Object, Object> latestVersionsBuilder = CacheBuilder.newBuilder().maximumSize(latestCacheSize).ticker(this.ticker);
        if (latestCacheTtl >= 0) {
            latestVersionsBuilder = latestVersionsBuilder.expireAfterWrite(latestCacheTtl, TimeUnit.SECONDS);
        }
        this.latestVersions = latestVersionsBuilder.build();
        CacheBuilder<Object, Object> latestWithMetadataBuilder = CacheBuilder.newBuilder().maximumSize(latestCacheSize).ticker(this.ticker);
        if (latestCacheTtl >= 0) {
            latestWithMetadataBuilder = latestWithMetadataBuilder.expireAfterWrite(latestCacheTtl, TimeUnit.SECONDS);
        }
        this.latestWithMetadata = latestWithMetadataBuilder.build();
        if (config.getLatestWithMetadataSpec() != null) {
            MapPropertyParser parser = new MapPropertyParser();
            this.metadata = parser.parse(config.getLatestWithMetadataSpec());
        }
        this.enableRuleServiceLoader = config.enableRuleServiceLoader();
        this.ruleExecutors = this.initRuleObjects(config, "rule.executors", RuleExecutor.class, this.enableRuleServiceLoader);
        this.ruleActions = this.initRuleObjects(config, "rule.actions", RuleAction.class, this.enableRuleServiceLoader);
        this.onSuccessActions = new ConcurrentHashMap<Rule, String>();
        this.onFailureActions = new ConcurrentHashMap<Rule, String>();
        this.disabledFlags = new ConcurrentHashMap<Rule, Boolean>();
    }

    protected void postOp(Object payload) {
        if (this.isKey) {
            AbstractKafkaSchemaSerDe.setKey(payload);
        } else {
            AbstractKafkaSchemaSerDe.clearKey();
        }
    }

    private Map<String, Map<String, RuleBase>> initRuleObjects(AbstractKafkaSchemaSerDeConfig config, String configName, Class<? extends RuleBase> cls, boolean enableRuleServiceLoader) {
        List<String> names = config.getList(configName);
        Map<String, Map<String, RuleBase>> ruleObjects = names.stream().flatMap(n -> this.initRuleObject((String)n, config, configName).map(r -> new AbstractMap.SimpleEntry<String, RuleBase>((String)n, (RuleBase)r))).collect(Collectors.groupingBy(e -> ((RuleBase)e.getValue()).type(), Collectors.toMap(AbstractMap.SimpleEntry::getKey, e -> {
            log.info("Registering rule object {} for {}: {}", e.getKey(), ((RuleBase)e.getValue()).type(), ((RuleBase)e.getValue()).getClass().getName());
            return (RuleBase)e.getValue();
        }, (e1, e2) -> e1, LinkedHashMap::new)));
        if (enableRuleServiceLoader) {
            try {
                this.addRuleObjectsFromServiceLoader(ruleObjects, config, configName, cls, Thread.currentThread().getContextClassLoader());
            }
            catch (ServiceConfigurationError e3) {
                this.addRuleObjectsFromServiceLoader(ruleObjects, config, configName, cls, cls.getClassLoader());
            }
        }
        return ruleObjects;
    }

    private Stream<RuleBase> initRuleObject(String name2, AbstractKafkaSchemaSerDeConfig config, String configName) {
        String propertyName = configName + "." + name2 + ".class";
        Object propertyValue = this.configOriginals.get(propertyName);
        if (propertyValue == null) {
            return Stream.empty();
        }
        try {
            RuleBase ruleObject = propertyValue instanceof Class ? Utils.newInstance((Class)propertyValue, RuleBase.class) : Utils.newInstance(propertyValue.toString(), RuleBase.class);
            this.configureRuleObject(ruleObject, name2, config, configName);
            return Stream.of(ruleObject);
        }
        catch (ClassNotFoundException e) {
            log.error("Could not load rule object class {}", (Object)name2, (Object)e);
            throw new ConfigException("Could not load rule object class " + name2);
        }
    }

    private void addRuleObjectsFromServiceLoader(Map<String, Map<String, RuleBase>> ruleObjects, AbstractKafkaSchemaSerDeConfig config, String configName, Class<? extends RuleBase> cls, ClassLoader classLoader2) {
        ServiceLoader<? extends RuleBase> serviceLoader = ServiceLoader.load(cls, classLoader2);
        String name2 = "_default_";
        for (RuleBase ruleBase : serviceLoader) {
            this.configureRuleObject(ruleBase, name2, config, configName);
            Map rules = ruleObjects.computeIfAbsent(ruleBase.type(), k -> new LinkedHashMap());
            rules.put(name2, ruleBase);
        }
    }

    private void configureRuleObject(RuleBase ruleObject, String name2, AbstractKafkaSchemaSerDeConfig config, String configName) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (ruleObject.addOriginalConfigs()) {
            params.putAll(this.configOriginals);
            params.remove("key.serializer");
            params.remove("value.serializer");
        } else {
            params.putAll(config.originalsWithPrefix("schema.registry.", false));
        }
        String prefix = configName + "." + "_default_" + PARAM;
        params.putAll(config.originalsWithPrefix(prefix));
        prefix = configName + "._" + ruleObject.type() + "_" + PARAM;
        params.putAll(config.originalsWithPrefix(prefix));
        prefix = configName + "." + name2 + PARAM;
        params.putAll(config.originalsWithPrefix(prefix));
        ruleObject.configure(params);
    }

    public SchemaRegistryClient getSchemaRegistryClient() {
        return this.schemaRegistry;
    }

    public Map<String, Map<String, RuleBase>> getRuleExecutors() {
        return this.ruleExecutors;
    }

    private RuleExecutor getRuleExecutor(RuleContext ctx) {
        return (RuleExecutor)this.getRuleObject(ctx, this.ruleExecutors, ctx.rule().getType());
    }

    public Map<String, Map<String, RuleBase>> getRuleActions() {
        return this.ruleActions;
    }

    private RuleAction getRuleAction(RuleContext ctx, String actionName) {
        if (actionName.equals("ERROR")) {
            return ERROR_ACTION;
        }
        if (actionName.equals("NONE")) {
            return NONE_ACTION;
        }
        return (RuleAction)this.getRuleObject(ctx, this.ruleActions, actionName);
    }

    private RuleBase getRuleObject(RuleContext ctx, Map<String, Map<String, RuleBase>> ruleBases, String type) {
        Rule rule = ctx.rule();
        Map<String, RuleBase> ruleObjects = ruleBases.get(type.toUpperCase(Locale.ROOT));
        if (ruleObjects != null && !ruleObjects.isEmpty()) {
            RuleBase ruleObject = ruleObjects.get(ctx.subject() + ":" + rule.getName());
            if (ruleObject != null) {
                return ruleObject;
            }
            ruleObject = ruleObjects.get(rule.getName());
            if (ruleObject != null) {
                return ruleObject;
            }
            return ruleObjects.entrySet().iterator().next().getValue();
        }
        return null;
    }

    public boolean isKey() {
        return this.isKey;
    }

    protected Map<SubjectSchema, ExtendedSchema> latestVersionsCache() {
        return this.latestVersions != null ? this.latestVersions.asMap() : new HashMap();
    }

    protected Map<String, ExtendedSchema> latestWithMetadataCache() {
        return this.latestWithMetadata != null ? this.latestWithMetadata.asMap() : new HashMap();
    }

    protected ExtendedSchema getLatestWithMetadata(String subject) throws IOException, RestClientException {
        if (this.metadata == null || this.metadata.isEmpty()) {
            return null;
        }
        ExtendedSchema extendedSchema = this.latestWithMetadata.getIfPresent(subject);
        if (extendedSchema == null) {
            SchemaMetadata schemaMetadata = this.schemaRegistry.getLatestWithMetadata(subject, this.metadata, true);
            Optional<ParsedSchema> optSchema = this.schemaRegistry.parseSchema(new io.confluent.kafka.schemaregistry.client.rest.entities.Schema(null, schemaMetadata));
            ParsedSchema schema = optSchema.orElseThrow(() -> new IOException("Invalid schema " + schemaMetadata.getSchema() + " with refs " + schemaMetadata.getReferences() + " of type " + schemaMetadata.getSchemaType()));
            schema = schema.copy(schemaMetadata.getVersion());
            extendedSchema = new ExtendedSchema(schemaMetadata.getId(), schemaMetadata.getVersion(), schema);
            this.latestWithMetadata.put(subject, extendedSchema);
        }
        return extendedSchema;
    }

    private ParsedSchema getSchemaMetadata(String subject, int version) throws IOException, RestClientException {
        SchemaMetadata schemaMetadata = this.schemaRegistry.getSchemaMetadata(subject, version, true);
        Optional<ParsedSchema> optSchema = this.schemaRegistry.parseSchema(new io.confluent.kafka.schemaregistry.client.rest.entities.Schema(null, schemaMetadata));
        ParsedSchema schema = optSchema.orElseThrow(() -> new IOException("Invalid schema " + schemaMetadata.getSchema() + " with refs " + schemaMetadata.getReferences() + " of type " + schemaMetadata.getSchemaType()));
        return schema.copy(schemaMetadata.getVersion());
    }

    protected List<Migration> getMigrations(String subject, ParsedSchema writerSchema, ParsedSchema readerSchema) throws IOException, RestClientException {
        ParsedSchema last;
        ParsedSchema first;
        RuleMode migrationMode = null;
        ArrayList<Migration> migrations = new ArrayList<Migration>();
        if (writerSchema.version() < readerSchema.version()) {
            migrationMode = RuleMode.UPGRADE;
            first = writerSchema;
            last = readerSchema;
        } else if (writerSchema.version() > readerSchema.version()) {
            migrationMode = RuleMode.DOWNGRADE;
            first = readerSchema;
            last = writerSchema;
        } else {
            return migrations;
        }
        List<ParsedSchema> versions = this.getSchemasBetween(subject, first, last);
        ParsedSchema previous = null;
        for (int i = 0; i < versions.size(); ++i) {
            ParsedSchema current = versions.get(i);
            if (i == 0) {
                previous = current;
                continue;
            }
            if (current.ruleSet() != null && current.ruleSet().hasRules(migrationMode)) {
                Migration m4 = migrationMode == RuleMode.UPGRADE ? new Migration(migrationMode, previous, current) : new Migration(migrationMode, current, previous);
                migrations.add(m4);
            }
            previous = current;
        }
        if (migrationMode == RuleMode.DOWNGRADE) {
            Collections.reverse(migrations);
        }
        return migrations;
    }

    private List<ParsedSchema> getSchemasBetween(String subject, ParsedSchema first, ParsedSchema last) throws IOException, RestClientException {
        if (last.version() - first.version() <= 1) {
            return ImmutableList.of(first, last);
        }
        int version1 = first.version();
        int version2 = last.version();
        ArrayList<ParsedSchema> schemas = new ArrayList<ParsedSchema>();
        schemas.add(first);
        for (int i = version1 + 1; i < version2; ++i) {
            schemas.add(this.getSchemaMetadata(subject, i));
        }
        schemas.add(last);
        return schemas;
    }

    protected String getSubjectName(String topic, boolean isKey, Object value, ParsedSchema schema) {
        Object subjectNameStrategy = this.subjectNameStrategy(isKey);
        String subject = subjectNameStrategy instanceof io.confluent.kafka.serializers.subject.strategy.SubjectNameStrategy ? ((io.confluent.kafka.serializers.subject.strategy.SubjectNameStrategy)subjectNameStrategy).subjectName(topic, isKey, schema) : ((SubjectNameStrategy)subjectNameStrategy).getSubjectName(topic, isKey, value);
        return this.getContextName(topic, subject);
    }

    protected String getContextName(String topic) {
        return this.getContextName(topic, null);
    }

    protected String getContextName(String topic, String subject) {
        String contextName = this.contextNameStrategy.contextName(topic);
        if (contextName != null) {
            contextName = QualifiedSubject.normalizeContext(contextName);
            return subject != null ? contextName + subject : contextName;
        }
        return subject;
    }

    protected boolean strategyUsesSchema(boolean isKey) {
        Object subjectNameStrategy = this.subjectNameStrategy(isKey);
        if (subjectNameStrategy instanceof io.confluent.kafka.serializers.subject.strategy.SubjectNameStrategy) {
            return ((io.confluent.kafka.serializers.subject.strategy.SubjectNameStrategy)subjectNameStrategy).usesSchema();
        }
        return false;
    }

    protected boolean isDeprecatedSubjectNameStrategy(boolean isKey) {
        Object subjectNameStrategy = this.subjectNameStrategy(isKey);
        return !(subjectNameStrategy instanceof io.confluent.kafka.serializers.subject.strategy.SubjectNameStrategy);
    }

    private Object subjectNameStrategy(boolean isKey) {
        return isKey ? this.keySubjectNameStrategy : this.valueSubjectNameStrategy;
    }

    protected String getOldSubjectName(Object value) {
        if (value instanceof GenericContainer) {
            return ((GenericContainer)value).getSchema().getName() + "-value";
        }
        throw new SerializationException("Primitive types are not supported yet");
    }

    @Deprecated
    public int register(String subject, Schema schema) throws IOException, RestClientException {
        return this.schemaRegistry.register(subject, schema);
    }

    public int register(String subject, ParsedSchema schema) throws IOException, RestClientException {
        return this.schemaRegistry.register(subject, schema);
    }

    public int register(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        return this.schemaRegistry.register(subject, schema, normalize);
    }

    protected io.confluent.kafka.schemaregistry.client.rest.entities.Schema registerWithResponse(String subject, ParsedSchema schema, boolean normalize, boolean propagateSchemaTags) throws IOException, RestClientException {
        RegisterSchemaResponse response = this.schemaRegistry.registerWithResponse(subject, schema, normalize, propagateSchemaTags);
        return new io.confluent.kafka.schemaregistry.client.rest.entities.Schema(subject, response);
    }

    @Deprecated
    public Schema getById(int id) throws IOException, RestClientException {
        return this.schemaRegistry.getById(id);
    }

    public ParsedSchema getSchemaById(int id) throws IOException, RestClientException {
        return this.schemaRegistry.getSchemaById(id);
    }

    @Deprecated
    public Schema getBySubjectAndId(String subject, int id) throws IOException, RestClientException {
        return this.schemaRegistry.getBySubjectAndId(subject, id);
    }

    public ParsedSchema getSchemaBySubjectAndId(String subject, int id) throws IOException, RestClientException {
        return this.schemaRegistry.getSchemaBySubjectAndId(subject, id);
    }

    protected ParsedSchema lookupSchemaBySubjectAndId(String subject, int id, ParsedSchema schema, boolean idCompatStrict) throws IOException, RestClientException {
        ParsedSchema lookupSchema = this.getSchemaBySubjectAndId(subject, id);
        if (idCompatStrict && !lookupSchema.isBackwardCompatible(schema).isEmpty()) {
            throw new IOException("Incompatible schema '" + lookupSchema.canonicalString() + "' with refs '" + lookupSchema.references() + "' of type '" + lookupSchema.schemaType() + "' for schema '" + schema.canonicalString() + "'. Set id.compatibility.strict=false to disable this check");
        }
        return lookupSchema;
    }

    protected ExtendedSchema lookupLatestVersion(String subject, ParsedSchema schema, boolean latestCompatStrict) throws IOException, RestClientException {
        return AbstractKafkaSchemaSerDe.lookupLatestVersion(this.schemaRegistry, subject, schema, this.latestVersionsCache(), latestCompatStrict);
    }

    protected static ExtendedSchema lookupLatestVersion(SchemaRegistryClient schemaRegistry, String subject, ParsedSchema schema, Map<SubjectSchema, ExtendedSchema> cache, boolean latestCompatStrict) throws IOException, RestClientException {
        SubjectSchema ss = new SubjectSchema(subject, schema);
        ExtendedSchema extendedSchema = null;
        if (cache != null) {
            extendedSchema = cache.get(ss);
        }
        if (extendedSchema == null) {
            List<String> errorMessages;
            SchemaMetadata schemaMetadata = schemaRegistry.getLatestSchemaMetadata(subject);
            Optional<ParsedSchema> optSchema = schemaRegistry.parseSchema(new io.confluent.kafka.schemaregistry.client.rest.entities.Schema(null, schemaMetadata));
            ParsedSchema latestVersion = optSchema.orElseThrow(() -> new IOException("Invalid schema " + schemaMetadata.getSchema() + " with refs " + schemaMetadata.getReferences() + " of type " + schemaMetadata.getSchemaType()));
            latestVersion = latestVersion.copy(schemaMetadata.getVersion());
            if (latestCompatStrict && !(errorMessages = latestVersion.isBackwardCompatible(schema)).isEmpty()) {
                String baseMsg = "Incompatible schema '" + schemaMetadata.getSchema() + "' with refs '" + schemaMetadata.getReferences() + "' of type '" + schemaMetadata.getSchemaType() + "' for schema '" + schema.canonicalString() + "'. Set latest.compatibility.strict=false to disable this check.";
                log.error(baseMsg + " Error messages: " + String.join((CharSequence)",", errorMessages) + "; latestVersion=" + latestVersion + "; schema=" + schema);
                throw new IOException(baseMsg + " See log file for more details.");
            }
            extendedSchema = new ExtendedSchema(schemaMetadata.getId(), schemaMetadata.getVersion(), latestVersion);
            if (cache != null) {
                cache.put(ss, extendedSchema);
            }
        }
        return extendedSchema;
    }

    protected ByteBuffer getByteBuffer(byte[] payload) {
        ByteBuffer buffer = ByteBuffer.wrap(payload);
        if (buffer.get() != 0) {
            throw new SerializationException("Unknown magic byte!");
        }
        return buffer;
    }

    protected Object executeMigrations(List<Migration> migrations, String subject, String topic, Headers headers, Object message) throws IOException {
        for (int i = 0; i < migrations.size(); ++i) {
            Migration m4 = migrations.get(i);
            if (i == 0) {
                message = m4.getSource().toJson(message);
            }
            message = this.executeRules(subject, topic, headers, m4.getRuleMode(), m4.getSource(), m4.getTarget(), message);
        }
        return message;
    }

    protected Object executeRules(String subject, String topic, Headers headers, RuleMode ruleMode, ParsedSchema source2, ParsedSchema target, Object message) {
        return this.executeRules(subject, topic, headers, message, ruleMode, source2, target, message);
    }

    protected Object executeRules(String subject, String topic, Headers headers, Object original, RuleMode ruleMode, ParsedSchema source2, ParsedSchema target, Object message) {
        if (message == null || target == null) {
            return message;
        }
        List<Object> rules = Collections.emptyList();
        if (ruleMode == RuleMode.UPGRADE) {
            if (target.ruleSet() != null) {
                rules = target.ruleSet().getMigrationRules();
            }
        } else if (ruleMode == RuleMode.DOWNGRADE) {
            if (source2.ruleSet() != null) {
                rules = new ArrayList<Rule>(source2.ruleSet().getMigrationRules());
                Collections.reverse(rules);
            }
        } else if (target.ruleSet() != null) {
            rules = target.ruleSet().getDomainRules();
            if (ruleMode == RuleMode.READ) {
                rules = new ArrayList<Object>(rules);
                Collections.reverse(rules);
            }
        }
        for (int i = 0; i < rules.size(); ++i) {
            RuleContext ctx;
            RuleExecutor ruleExecutor;
            Rule rule = (Rule)rules.get(i);
            if (this.skipRule(rule, headers)) continue;
            if (rule.getMode() == RuleMode.WRITEREAD) {
                if (ruleMode != RuleMode.READ && ruleMode != RuleMode.WRITE) {
                    continue;
                }
            } else if (rule.getMode() != RuleMode.UPDOWN ? ruleMode != rule.getMode() : ruleMode != RuleMode.UPGRADE && ruleMode != RuleMode.DOWNGRADE) continue;
            if ((ruleExecutor = this.getRuleExecutor(ctx = new RuleContext(this.configOriginals, source2, target, subject, topic, headers, this.isKey ? original : AbstractKafkaSchemaSerDe.key(), this.isKey ? null : original, this.isKey, ruleMode, rule, i, rules))) != null) {
                try {
                    Object result2 = ruleExecutor.transform(ctx, message);
                    switch (rule.getKind()) {
                        case CONDITION: {
                            if (!Boolean.FALSE.equals(result2)) break;
                            throw new RuleConditionException(rule);
                        }
                        case TRANSFORM: {
                            message = result2;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unsupported rule kind " + (Object)((Object)rule.getKind()));
                        }
                    }
                    this.runAction(ctx, ruleMode, rule, message != null ? this.getOnSuccess(rule) : this.getOnFailure(rule), message, null, message != null ? null : "ERROR");
                }
                catch (RuleException e) {
                    this.runAction(ctx, ruleMode, rule, this.getOnFailure(rule), message, e, "ERROR");
                }
                continue;
            }
            this.runAction(ctx, ruleMode, rule, this.getOnFailure(rule), message, new RuleException("Could not find rule executor of type " + rule.getType()), "ERROR");
        }
        return message;
    }

    private String getOnSuccess(Rule rule) {
        return this.onSuccessActions.computeIfAbsent(rule, r -> {
            Object propertyValue = this.getRuleConfig(rule.getName(), ON_SUCCESS);
            if (propertyValue != null) {
                return propertyValue.toString();
            }
            propertyValue = this.getRuleConfig("_" + rule.getType() + "_", ON_SUCCESS);
            if (propertyValue != null) {
                return propertyValue.toString();
            }
            propertyValue = this.getRuleConfig("_default_", ON_SUCCESS);
            if (propertyValue != null) {
                return propertyValue.toString();
            }
            return rule.getOnSuccess();
        });
    }

    private String getOnFailure(Rule rule) {
        return this.onFailureActions.computeIfAbsent(rule, r -> {
            Object propertyValue = this.getRuleConfig(rule.getName(), ON_FAILURE);
            if (propertyValue != null) {
                return propertyValue.toString();
            }
            propertyValue = this.getRuleConfig("_" + rule.getType() + "_", ON_FAILURE);
            if (propertyValue != null) {
                return propertyValue.toString();
            }
            propertyValue = this.getRuleConfig("_default_", ON_FAILURE);
            if (propertyValue != null) {
                return propertyValue.toString();
            }
            return rule.getOnFailure();
        });
    }

    private boolean isDisabled(Rule rule) {
        return this.disabledFlags.computeIfAbsent(rule, r -> {
            Object propertyValue = this.getRuleConfig(rule.getName(), DISABLED);
            if (propertyValue != null) {
                return Boolean.parseBoolean(propertyValue.toString());
            }
            propertyValue = this.getRuleConfig("_" + rule.getType() + "_", DISABLED);
            if (propertyValue != null) {
                return Boolean.parseBoolean(propertyValue.toString());
            }
            propertyValue = this.getRuleConfig("_default_", DISABLED);
            if (propertyValue != null) {
                return Boolean.parseBoolean(propertyValue.toString());
            }
            return rule.isDisabled();
        });
    }

    private Object getRuleConfig(String name2, String suffix) {
        String propertyName = "rule.executors." + name2 + "." + suffix;
        return this.configOriginals.get(propertyName);
    }

    private boolean skipRule(Rule rule, Headers headers) {
        Header header;
        if (this.isDisabled(rule)) {
            return true;
        }
        if (headers != null && (header = headers.lastHeader("__rule.name")) != null) {
            String ruleName = new String(header.value(), StandardCharsets.UTF_8);
            if (rule.getName().equals(ruleName)) {
                return true;
            }
        }
        return false;
    }

    private void runAction(RuleContext ctx, RuleMode ruleMode, Rule rule, String action, Object message, RuleException ex, String defaultAction) {
        String actionName = this.getRuleActionName(rule, ruleMode, action);
        if (actionName == null) {
            actionName = defaultAction;
        }
        if (actionName != null) {
            RuleAction ruleAction = this.getRuleAction(ctx, actionName);
            if (ruleAction == null) {
                log.error("Could not find rule action of type {}", (Object)actionName);
                throw new ConfigException("Could not find rule action of type " + actionName);
            }
            try {
                ruleAction.run(ctx, message, ex);
            }
            catch (RuleException e) {
                log.error("Could not run post-rule action {}", (Object)action, (Object)e);
            }
        }
    }

    private String getRuleActionName(Rule rule, RuleMode ruleMode, String actionName) {
        if ((rule.getMode() == RuleMode.WRITEREAD || rule.getMode() == RuleMode.UPDOWN) && actionName != null && actionName.contains(",")) {
            String[] parts = actionName.split(",");
            switch (ruleMode) {
                case WRITE: 
                case UPGRADE: {
                    return parts[0];
                }
                case READ: 
                case DOWNGRADE: {
                    return parts[1];
                }
            }
            throw new IllegalStateException("Unsupported rule mode " + (Object)((Object)ruleMode));
        }
        return actionName;
    }

    @Override
    public void close() throws IOException {
        this.closeRuleObjects(this.ruleActions);
        this.closeRuleObjects(this.ruleExecutors);
        if (this.schemaRegistry != null) {
            this.schemaRegistry.close();
        }
    }

    private void closeRuleObjects(Map<String, Map<String, RuleBase>> ruleBases) {
        if (ruleBases != null) {
            for (Map.Entry<String, Map<String, RuleBase>> outer : ruleBases.entrySet()) {
                for (Map.Entry<String, RuleBase> inner : outer.getValue().entrySet()) {
                    AbstractKafkaSchemaSerDe.closeQuietly(inner.getValue(), "rule object " + inner.getKey() + " for " + outer.getKey());
                }
            }
        }
    }

    private static void closeQuietly(AutoCloseable closeable, String name2) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable t2) {
                log.error("Failed to close {} with type {}", name2, closeable.getClass().getName(), t2);
            }
        }
    }

    protected static KafkaException toKafkaException(RestClientException e, String errorMessage) {
        int status = e.getStatus();
        if (status == 401) {
            return new AuthenticationException(errorMessage, e);
        }
        if (status == 403) {
            return new AuthorizationException(errorMessage, e);
        }
        if (status == 429) {
            return new ThrottlingQuotaExceededException(e.getMessage());
        }
        if (status == 408 || status == 500 || status == 503 || status == 504) {
            return new TimeoutException(errorMessage, e);
        }
        if (status == 502) {
            return new DisconnectException(errorMessage, e);
        }
        return new SerializationException(errorMessage, e);
    }

    static class MapPropertyParser {
        private final ListPropertyParser parser = new ListPropertyParser();

        public Map<String, String> parse(String str) {
            List<String> strings = this.parser.parse(str);
            return strings.stream().collect(Collectors.toMap(s2 -> s2.substring(0, s2.indexOf(61)), s2 -> s2.substring(s2.indexOf(61) + 1)));
        }

        public String asString(Map<String, String> map) {
            List<String> entries = map.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.toList());
            return this.parser.asString(entries);
        }
    }

    static class ListPropertyParser {
        private static final char DELIM_CHAR = ',';
        private static final char QUOTE_CHAR = '\'';
        private final CsvMapper mapper = new CsvMapper().enable(CsvGenerator.Feature.STRICT_CHECK_FOR_QUOTING).enable(CsvParser.Feature.WRAP_AS_ARRAY);
        private final CsvSchema schema = CsvSchema.builder().setColumnSeparator(',').setQuoteChar('\'').setLineSeparator("").build();

        public List<String> parse(String str) {
            try {
                ObjectReader reader = this.mapper.readerFor(String[].class).with(this.schema);
                MappingIterator iter = reader.readValues(str);
                String[] strings = iter.hasNext() ? (String[])iter.next() : new String[]{};
                return Arrays.asList(strings);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not parse string " + str, e);
            }
        }

        public String asString(List<String> list) {
            try {
                String[] array = list.toArray(new String[0]);
                ObjectWriter writer = this.mapper.writerFor(Object[].class).with(this.schema);
                return writer.writeValueAsString(array);
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException("Could not parse list " + list, e);
            }
        }
    }

    protected static class Migration {
        private final RuleMode ruleMode;
        private final ParsedSchema source;
        private final ParsedSchema target;

        public Migration(RuleMode ruleMode, ParsedSchema source2, ParsedSchema target) {
            this.ruleMode = ruleMode;
            this.source = source2;
            this.target = target;
        }

        public RuleMode getRuleMode() {
            return this.ruleMode;
        }

        public ParsedSchema getSource() {
            return this.source;
        }

        public ParsedSchema getTarget() {
            return this.target;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Migration migration = (Migration)o;
            return this.ruleMode == migration.ruleMode && Objects.equals(this.source, migration.source) && Objects.equals(this.target, migration.target);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.ruleMode, this.source, this.target});
        }
    }

    protected static class ExtendedSchema {
        private final Integer id;
        private final Integer version;
        private final ParsedSchema schema;

        public ExtendedSchema(Integer id, Integer version, ParsedSchema schema) {
            this.id = id;
            this.version = version;
            this.schema = schema;
        }

        public Integer getId() {
            return this.id;
        }

        public Integer getVersion() {
            return this.version;
        }

        public ParsedSchema getSchema() {
            return this.schema;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExtendedSchema that = (ExtendedSchema)o;
            return this.id.equals(that.id) && this.version.equals(that.version) && this.schema.equals(that.schema);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.version, this.schema);
        }
    }

    protected static class SubjectSchema {
        private final String subject;
        private final ParsedSchema schema;

        public SubjectSchema(String subject, ParsedSchema schema) {
            this.subject = subject;
            this.schema = schema;
        }

        public String getSubject() {
            return this.subject;
        }

        public ParsedSchema getSchema() {
            return this.schema;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SubjectSchema that = (SubjectSchema)o;
            return this.subject.equals(that.subject) && this.schema.equals(that.schema);
        }

        public int hashCode() {
            return Objects.hash(this.subject, this.schema);
        }
    }
}

