/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.json.schema;

import java.util.Collection;
import java.util.Objects;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.Schema;

public class CombinedSchemaExt
extends CombinedSchema {
    private final boolean generated;

    public static Builder allOf(Collection<Schema> schemas) {
        return CombinedSchemaExt.builder(schemas).criterion(ALL_CRITERION);
    }

    public static Builder anyOf(Collection<Schema> schemas) {
        return CombinedSchemaExt.builder(schemas).criterion(ANY_CRITERION);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Collection<Schema> subschemas) {
        return new Builder().subschemas((Collection)subschemas);
    }

    public static Builder oneOf(Collection<Schema> schemas) {
        return CombinedSchemaExt.builder(schemas).criterion(ONE_CRITERION);
    }

    public CombinedSchemaExt(Builder builder) {
        super(builder);
        this.generated = builder.generated;
    }

    boolean isGenerated() {
        return this.generated;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CombinedSchemaExt that = (CombinedSchemaExt)o;
        return this.generated == that.generated;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.generated);
    }

    public static class Builder
    extends CombinedSchema.Builder {
        private boolean generated;

        @Override
        public CombinedSchemaExt build() {
            return new CombinedSchemaExt(this);
        }

        @Override
        public Builder criterion(CombinedSchema.ValidationCriterion criterion) {
            return (Builder)super.criterion(criterion);
        }

        @Override
        public Builder subschema(Schema subschema) {
            return (Builder)super.subschema(subschema);
        }

        @Override
        public Builder subschemas(Collection<Schema> subschemas) {
            return (Builder)super.subschemas(subschemas);
        }

        @Override
        public Builder isSynthetic(boolean synthetic) {
            return (Builder)super.isSynthetic(synthetic);
        }

        public Builder isGenerated(boolean generated2) {
            this.generated = generated2;
            return this;
        }
    }
}

