/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.json.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.github.erosb.jsonsKema.JsonArray;
import com.github.erosb.jsonsKema.JsonBoolean;
import com.github.erosb.jsonsKema.JsonNull;
import com.github.erosb.jsonsKema.JsonNumber;
import com.github.erosb.jsonsKema.JsonObject;
import com.github.erosb.jsonsKema.JsonString;
import com.github.erosb.jsonsKema.JsonValue;
import io.confluent.kafka.schemaregistry.json.jackson.JSONBaseSerializer;
import io.confluent.kafka.schemaregistry.json.jackson.JsonSkemaArraySerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;

public class JsonSkemaObjectSerializer
extends JSONBaseSerializer<JsonObject> {
    private static final long serialVersionUID = 1L;
    public static final JsonSkemaObjectSerializer instance = new JsonSkemaObjectSerializer();

    public JsonSkemaObjectSerializer() {
        super(JsonObject.class);
    }

    @Override
    public boolean isEmpty(SerializerProvider provider, JsonObject value) {
        return value == null || value.getProperties().isEmpty();
    }

    @Override
    public void serialize(JsonObject value, JsonGenerator g2, SerializerProvider provider) throws IOException {
        g2.writeStartObject(value);
        this.serializeContents(value, g2, provider);
        g2.writeEndObject();
    }

    @Override
    public void serializeWithType(JsonObject value, JsonGenerator g2, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        g2.setCurrentValue(value);
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g2, typeSer.typeId(value, JsonToken.START_OBJECT));
        this.serializeContents(value, g2, provider);
        typeSer.writeTypeSuffix(g2, typeIdDef);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return this.createSchemaNode("object", true);
    }

    protected void serializeContents(JsonObject value, JsonGenerator g2, SerializerProvider provider) throws IOException {
        for (Map.Entry<JsonString, JsonValue> entry : value.getProperties().entrySet()) {
            String key = entry.getKey().getValue();
            JsonValue ob = entry.getValue();
            if (ob == null || ob instanceof JsonNull) {
                if (!provider.isEnabled(SerializationFeature.WRITE_NULL_MAP_VALUES)) continue;
                g2.writeNullField(key);
                continue;
            }
            g2.writeFieldName(key);
            if (ob instanceof JsonObject) {
                this.serialize((JsonObject)ob, g2, provider);
                continue;
            }
            if (ob instanceof JsonArray) {
                JsonSkemaArraySerializer.instance.serialize((JsonArray)ob, g2, provider);
                continue;
            }
            if (ob instanceof JsonString) {
                g2.writeString(((JsonString)ob).getValue());
                continue;
            }
            if (ob instanceof JsonNumber) {
                Number num = ((JsonNumber)ob).getValue();
                if (num instanceof Double) {
                    g2.writeNumber(num.doubleValue());
                    continue;
                }
                if (num instanceof Float) {
                    g2.writeNumber(num.floatValue());
                    continue;
                }
                if (num instanceof Long) {
                    g2.writeNumber(num.longValue());
                    continue;
                }
                g2.writeNumber(num.intValue());
                continue;
            }
            if (ob instanceof JsonBoolean) {
                g2.writeBoolean(((JsonBoolean)ob).getValue());
                continue;
            }
            provider.defaultSerializeValue(ob, g2);
        }
    }
}

