/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.json.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.github.erosb.jsonsKema.JsonBoolean;
import com.github.erosb.jsonsKema.JsonNull;
import com.github.erosb.jsonsKema.JsonNumber;
import com.github.erosb.jsonsKema.JsonObject;
import com.github.erosb.jsonsKema.JsonString;
import com.github.erosb.jsonsKema.JsonValue;
import com.github.erosb.jsonsKema.UnknownSource;
import io.confluent.kafka.schemaregistry.json.jackson.JsonSkemaArrayDeserializer;
import java.io.IOException;
import java.util.HashMap;

public class JsonSkemaObjectDeserializer
extends StdDeserializer<JsonObject> {
    private static final long serialVersionUID = 1L;
    public static final JsonSkemaObjectDeserializer instance = new JsonSkemaObjectDeserializer();

    public JsonSkemaObjectDeserializer() {
        super(JsonObject.class);
    }

    @Override
    public JsonObject deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        HashMap<JsonString, JsonValue> ob = new HashMap<JsonString, JsonValue>();
        JsonToken t2 = p.getCurrentToken();
        if (t2 == JsonToken.START_OBJECT) {
            t2 = p.nextToken();
        }
        while (t2 == JsonToken.FIELD_NAME) {
            JsonString fieldName = new JsonString(p.getCurrentName(), UnknownSource.INSTANCE);
            t2 = p.nextToken();
            switch (t2) {
                case START_ARRAY: {
                    ob.put(fieldName, JsonSkemaArrayDeserializer.instance.deserialize(p, ctxt));
                    break;
                }
                case START_OBJECT: {
                    ob.put(fieldName, this.deserialize(p, ctxt));
                    break;
                }
                case VALUE_STRING: {
                    ob.put(fieldName, new JsonString(p.getText(), UnknownSource.INSTANCE));
                    break;
                }
                case VALUE_NULL: {
                    ob.put(fieldName, new JsonNull(UnknownSource.INSTANCE));
                    break;
                }
                case VALUE_TRUE: {
                    ob.put(fieldName, new JsonBoolean(true, UnknownSource.INSTANCE));
                    break;
                }
                case VALUE_FALSE: {
                    ob.put(fieldName, new JsonBoolean(false, UnknownSource.INSTANCE));
                    break;
                }
                case VALUE_NUMBER_INT: {
                    Number num = p.getNumberValue();
                    if (num instanceof Byte || num instanceof Short) {
                        num = num.intValue();
                    }
                    ob.put(fieldName, new JsonNumber(num, UnknownSource.INSTANCE));
                    break;
                }
                case VALUE_NUMBER_FLOAT: {
                    ob.put(fieldName, new JsonNumber(p.getNumberValue(), UnknownSource.INSTANCE));
                    break;
                }
                case VALUE_EMBEDDED_OBJECT: {
                    Object o = p.getEmbeddedObject();
                    if (o instanceof byte[]) {
                        ob.put(fieldName, new JsonString(p.getText(), UnknownSource.INSTANCE));
                        break;
                    }
                    return (JsonObject)ctxt.handleUnexpectedToken(JsonObject.class, p);
                }
                default: {
                    return (JsonObject)ctxt.handleUnexpectedToken(JsonObject.class, p);
                }
            }
            t2 = p.nextToken();
        }
        return new JsonObject(ob, UnknownSource.INSTANCE);
    }
}

