/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.json.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.github.erosb.jsonsKema.JsonArray;
import com.github.erosb.jsonsKema.JsonBoolean;
import com.github.erosb.jsonsKema.JsonNull;
import com.github.erosb.jsonsKema.JsonNumber;
import com.github.erosb.jsonsKema.JsonString;
import com.github.erosb.jsonsKema.JsonValue;
import com.github.erosb.jsonsKema.UnknownSource;
import io.confluent.kafka.schemaregistry.json.jackson.JsonSkemaObjectDeserializer;
import java.io.IOException;
import java.util.ArrayList;

public class JsonSkemaArrayDeserializer
extends StdDeserializer<JsonArray> {
    private static final long serialVersionUID = 1L;
    public static final JsonSkemaArrayDeserializer instance = new JsonSkemaArrayDeserializer();

    public JsonSkemaArrayDeserializer() {
        super(JsonArray.class);
    }

    @Override
    public JsonArray deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t2;
        if (!p.isExpectedStartArrayToken()) {
            JsonToken t3 = p.currentToken();
            return (JsonArray)ctxt.handleUnexpectedToken(this.handledType(), t3, p, "Unexpected token (%s), expected START_ARRAY for %s value", new Object[]{t3, ClassUtil.nameOf(this.handledType())});
        }
        ArrayList<JsonValue> elements = new ArrayList<JsonValue>();
        block11: while ((t2 = p.nextToken()) != JsonToken.END_ARRAY) {
            switch (t2) {
                case START_ARRAY: {
                    elements.add(this.deserialize(p, ctxt));
                    continue block11;
                }
                case START_OBJECT: {
                    elements.add(JsonSkemaObjectDeserializer.instance.deserialize(p, ctxt));
                    continue block11;
                }
                case VALUE_STRING: {
                    elements.add(new JsonString(p.getText(), UnknownSource.INSTANCE));
                    continue block11;
                }
                case VALUE_NULL: {
                    elements.add(new JsonNull(UnknownSource.INSTANCE));
                    continue block11;
                }
                case VALUE_TRUE: {
                    elements.add(new JsonBoolean(true, UnknownSource.INSTANCE));
                    continue block11;
                }
                case VALUE_FALSE: {
                    elements.add(new JsonBoolean(false, UnknownSource.INSTANCE));
                    continue block11;
                }
                case VALUE_NUMBER_INT: {
                    Number num = p.getNumberValue();
                    if (num instanceof Byte || num instanceof Short) {
                        num = num.intValue();
                    }
                    elements.add(new JsonNumber(num, UnknownSource.INSTANCE));
                    continue block11;
                }
                case VALUE_NUMBER_FLOAT: {
                    elements.add(new JsonNumber(p.getNumberValue(), UnknownSource.INSTANCE));
                    continue block11;
                }
                case VALUE_EMBEDDED_OBJECT: {
                    Object o = p.getEmbeddedObject();
                    if (o instanceof byte[]) {
                        elements.add(new JsonString(p.getText(), UnknownSource.INSTANCE));
                        continue block11;
                    }
                    return (JsonArray)ctxt.handleUnexpectedToken(this.handledType(), p);
                }
            }
            return (JsonArray)ctxt.handleUnexpectedToken(this.handledType(), p);
        }
        return new JsonArray(elements, UnknownSource.INSTANCE);
    }
}

