/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.json.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.CacheProvider;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.databind.ser.impl.UnknownSerializer;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import io.confluent.kafka.schemaregistry.json.jackson.JsonOrgModule;
import io.confluent.kafka.schemaregistry.json.jackson.JsonSkemaModule;
import java.util.TreeMap;

public class Jackson {
    private Jackson() {
    }

    public static ObjectMapper newObjectMapper() {
        return Jackson.newObjectMapper(false);
    }

    public static ObjectMapper newObjectMapper(boolean sorted2) {
        Object mapper = JsonMapper.builder().enable(JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS).build();
        return Jackson.configure(mapper, sorted2);
    }

    public static ObjectMapper newObjectMapper(JsonFactory jsonFactory) {
        Object mapper = JsonMapper.builder(jsonFactory).enable(JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS).build();
        return Jackson.configure(mapper, false);
    }

    private static ObjectMapper configure(ObjectMapper mapper, boolean sorted2) {
        mapper.registerModule(new GuavaModule());
        mapper.registerModule(new JodaModule());
        mapper.registerModule(new ParameterNamesModule());
        mapper.registerModule(new Jdk8Module());
        mapper.registerModule(new JavaTimeModule());
        mapper.registerModule(new JsonOrgModule());
        mapper.registerModule(new JsonSkemaModule());
        mapper.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.setNodeFactory(sorted2 ? new SortingNodeFactory(true) : JsonNodeFactory.withExactBigDecimals(true));
        mapper.setSerializerProvider(new DefaultSerializerProviderImpl());
        return mapper;
    }

    static class UnknownSerializerImpl
    extends UnknownSerializer {
        public UnknownSerializerImpl() {
        }

        public UnknownSerializerImpl(Class<?> cls) {
            super(cls);
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor2, JavaType typeHint) throws JsonMappingException {
            visitor2.expectAnyFormat(typeHint);
        }
    }

    static class DefaultSerializerProviderImpl
    extends DefaultSerializerProvider {
        private static final long serialVersionUID = 1L;
        protected static final JsonSerializer<Object> DEFAULT_UNKNOWN_SERIALIZER = new UnknownSerializerImpl();

        public DefaultSerializerProviderImpl() {
            this._unknownTypeSerializer = DEFAULT_UNKNOWN_SERIALIZER;
        }

        public DefaultSerializerProviderImpl(DefaultSerializerProviderImpl src) {
            super(src);
            this._unknownTypeSerializer = DEFAULT_UNKNOWN_SERIALIZER;
        }

        public DefaultSerializerProviderImpl(DefaultSerializerProviderImpl src, CacheProvider cp) {
            super(src, cp);
            this._unknownTypeSerializer = DEFAULT_UNKNOWN_SERIALIZER;
        }

        protected DefaultSerializerProviderImpl(SerializerProvider src, SerializationConfig config, SerializerFactory f) {
            super(src, config, f);
            this._unknownTypeSerializer = DEFAULT_UNKNOWN_SERIALIZER;
        }

        @Override
        public DefaultSerializerProvider copy() {
            return this.getClass() != DefaultSerializerProviderImpl.class ? super.copy() : new DefaultSerializerProviderImpl(this);
        }

        @Override
        public DefaultSerializerProviderImpl createInstance(SerializationConfig config, SerializerFactory jsf) {
            return new DefaultSerializerProviderImpl(this, config, jsf);
        }

        @Override
        public DefaultSerializerProviderImpl withCaches(CacheProvider cp) {
            return new DefaultSerializerProviderImpl(this, cp);
        }
    }

    static class SortingNodeFactory
    extends JsonNodeFactory {
        public SortingNodeFactory(boolean bigDecimalExact) {
            super(bigDecimalExact);
        }

        @Override
        public ObjectNode objectNode() {
            return new ObjectNode(this, new TreeMap<String, JsonNode>());
        }
    }
}

