/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.rest.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Metadata {
    public static final String CONFLUENT_VERSION = "confluent:version";
    @JsonPropertyOrder(alphabetic=true)
    private final SortedMap<String, SortedSet<String>> tags;
    @JsonPropertyOrder(alphabetic=true)
    private final SortedMap<String, String> properties;
    private final SortedSet<String> sensitive;

    @JsonCreator
    public Metadata(@JsonProperty(value="tags") Map<String, ? extends Set<String>> tags, @JsonProperty(value="properties") Map<String, String> properties, @JsonProperty(value="sensitive") Set<String> sensitive) {
        SortedMap sortedTags = tags != null ? (SortedMap)tags.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Set)e.getValue()).stream().sorted().collect(Collectors.toCollection(TreeSet::new)), (e1, e2) -> e1, TreeMap::new)) : Collections.emptySortedMap();
        TreeMap<String, String> sortedProperties = properties != null ? new TreeMap<String, String>(properties) : Collections.emptySortedMap();
        SortedSet sortedSensitive = sensitive != null ? (SortedSet)sensitive.stream().sorted().collect(Collectors.toCollection(TreeSet::new)) : Collections.emptySortedSet();
        this.tags = Collections.unmodifiableSortedMap(sortedTags);
        this.properties = Collections.unmodifiableSortedMap(sortedProperties);
        this.sensitive = Collections.unmodifiableSortedSet(sortedSensitive);
    }

    public SortedMap<String, SortedSet<String>> getTags() {
        return this.tags;
    }

    public SortedMap<String, String> getProperties() {
        return this.properties;
    }

    public SortedSet<String> getSensitive() {
        return this.sensitive;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Metadata metadata = (Metadata)o;
        return Objects.equals(this.tags, metadata.tags) && Objects.equals(this.properties, metadata.properties) && Objects.equals(this.sensitive, metadata.sensitive);
    }

    public int hashCode() {
        return Objects.hash(this.tags, this.properties, this.sensitive);
    }

    public String toString() {
        return "Metadata{tags=" + this.tags + ", properties=" + this.properties + ", sensitive=" + this.sensitive + '}';
    }

    public void updateHash(MessageDigest md) {
        if (this.tags != null) {
            this.tags.forEach((key, value) -> {
                md.update(key.getBytes(StandardCharsets.UTF_8));
                value.forEach(v -> md.update(v.getBytes(StandardCharsets.UTF_8)));
            });
        }
        if (this.properties != null) {
            this.properties.forEach((key, value) -> {
                md.update(key.getBytes(StandardCharsets.UTF_8));
                md.update(value.getBytes(StandardCharsets.UTF_8));
            });
        }
        if (this.sensitive != null) {
            this.sensitive.forEach(s2 -> md.update(s2.getBytes(StandardCharsets.UTF_8)));
        }
    }

    @JsonIgnore
    public Integer getConfluentVersionNumber() {
        String version = this.getConfluentVersion();
        if (version == null) {
            return null;
        }
        try {
            return Integer.parseInt(version);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @JsonIgnore
    public String getConfluentVersion() {
        return this.getProperties() != null ? (String)this.getProperties().get(CONFLUENT_VERSION) : null;
    }

    public static Metadata setConfluentVersion(Metadata metadata, int version) {
        HashMap<String, String> newProps = metadata != null && metadata.getProperties() != null ? new HashMap<String, String>(metadata.getProperties()) : new HashMap<String, String>();
        newProps.put(CONFLUENT_VERSION, String.valueOf(version));
        return new Metadata(metadata != null ? metadata.getTags() : null, newProps, metadata != null ? metadata.getSensitive() : null);
    }

    public static Metadata removeConfluentVersion(Metadata metadata) {
        if (metadata == null || metadata.getProperties() == null) {
            return metadata;
        }
        HashMap<String, String> newProps = new HashMap<String, String>(metadata.getProperties());
        newProps.remove(CONFLUENT_VERSION);
        return new Metadata(metadata.getTags(), newProps, metadata.getSensitive());
    }

    public static Metadata mergeMetadata(Metadata oldMetadata, Metadata newMetadata) {
        if (oldMetadata == null) {
            return newMetadata;
        }
        if (newMetadata == null) {
            return oldMetadata;
        }
        return new Metadata(Metadata.merge(oldMetadata.tags, newMetadata.tags), Metadata.merge(oldMetadata.properties, newMetadata.properties), Metadata.merge(oldMetadata.sensitive, newMetadata.sensitive));
    }

    private static <T> SortedMap<String, T> merge(SortedMap<String, T> oldMap, SortedMap<String, T> newMap) {
        if (oldMap == null || oldMap.isEmpty()) {
            return newMap;
        }
        if (newMap == null || newMap.isEmpty()) {
            return oldMap;
        }
        TreeMap<String, T> map = new TreeMap<String, T>(oldMap);
        map.putAll(newMap);
        return map;
    }

    private static SortedSet<String> merge(SortedSet<String> oldSet, SortedSet<String> newSet) {
        if (oldSet == null || oldSet.isEmpty()) {
            return newSet;
        }
        if (newSet == null || newSet.isEmpty()) {
            return oldSet;
        }
        TreeSet<String> set = new TreeSet<String>(oldSet);
        set.addAll(newSet);
        return set;
    }
}

