/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.rw;

import io.cloudevents.rw.CloudEventRWException;
import io.cloudevents.types.Time;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.Base64;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface CloudEventContextWriter {
    public CloudEventContextWriter withContextAttribute(String var1, String var2) throws CloudEventRWException;

    default public CloudEventContextWriter withContextAttribute(String name2, URI value) throws CloudEventRWException {
        return this.withContextAttribute(name2, value.toString());
    }

    default public CloudEventContextWriter withContextAttribute(String name2, OffsetDateTime value) throws CloudEventRWException {
        return this.withContextAttribute(name2, Time.writeTime(name2, value));
    }

    default public CloudEventContextWriter withContextAttribute(String name2, Number value) throws CloudEventRWException {
        return this.withContextAttribute(name2, value.toString());
    }

    default public CloudEventContextWriter withContextAttribute(String name2, Integer value) throws CloudEventRWException {
        return this.withContextAttribute(name2, value.toString());
    }

    default public CloudEventContextWriter withContextAttribute(String name2, Boolean value) throws CloudEventRWException {
        return this.withContextAttribute(name2, value.toString());
    }

    default public CloudEventContextWriter withContextAttribute(String name2, byte[] value) throws CloudEventRWException {
        return this.withContextAttribute(name2, Base64.getEncoder().encodeToString(value));
    }
}

