/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.kafka.impl;

import io.cloudevents.core.message.impl.MessageUtils;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;

public class KafkaHeaders {
    protected static final String CE_PREFIX = "ce_";
    public static final String CONTENT_TYPE = "content-type";
    protected static final Map<String, String> ATTRIBUTES_TO_HEADERS = MessageUtils.generateAttributesToHeadersMapping(v -> {
        if (v.equals("datacontenttype")) {
            return CONTENT_TYPE;
        }
        return CE_PREFIX + v;
    });
    public static final String SPEC_VERSION = ATTRIBUTES_TO_HEADERS.get("specversion");

    public static String getParsedKafkaHeader(Headers headers, String key) {
        Header h2 = headers.lastHeader(key);
        if (h2 == null) {
            return null;
        }
        return new String(h2.value(), StandardCharsets.UTF_8);
    }
}

