/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.kafka.impl;

import io.cloudevents.SpecVersion;
import io.cloudevents.core.data.BytesCloudEventData;
import io.cloudevents.core.message.impl.BaseGenericBinaryMessageReaderImpl;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.apache.kafka.common.header.Headers;

public class KafkaBinaryMessageReaderImpl
extends BaseGenericBinaryMessageReaderImpl<String, byte[]> {
    private final Headers headers;

    public KafkaBinaryMessageReaderImpl(SpecVersion version, Headers headers, byte[] payload) {
        super(version, payload != null && payload.length > 0 ? BytesCloudEventData.wrap(payload) : null);
        Objects.requireNonNull(headers);
        this.headers = headers;
    }

    @Override
    protected boolean isContentTypeHeader(String key) {
        return key.equals("content-type");
    }

    @Override
    protected boolean isCloudEventsHeader(String key) {
        return key.length() > "ce_".length() && key.startsWith("ce_");
    }

    @Override
    protected String toCloudEventsKey(String key) {
        return key.substring("ce_".length()).toLowerCase();
    }

    @Override
    protected void forEachHeader(BiConsumer<String, byte[]> fn) {
        this.headers.forEach(h2 -> fn.accept(h2.key(), h2.value()));
    }

    @Override
    protected String toCloudEventsValue(byte[] value) {
        return new String(value, StandardCharsets.UTF_8);
    }
}

