/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.kafka;

import io.cloudevents.CloudEvent;
import java.util.Map;
import org.apache.kafka.clients.producer.ProducerInterceptor;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;

public class PartitionKeyExtensionInterceptor
implements ProducerInterceptor<Object, CloudEvent> {
    public static final String PARTITION_KEY_EXTENSION = "partitionkey";

    @Override
    public ProducerRecord<Object, CloudEvent> onSend(ProducerRecord<Object, CloudEvent> record) {
        if (record.value() == null) {
            return record;
        }
        Object partitionKey = record.value().getExtension(PARTITION_KEY_EXTENSION);
        if (partitionKey == null) {
            return record;
        }
        return new ProducerRecord<Object, CloudEvent>(record.topic(), record.partition(), record.timestamp(), partitionKey, record.value(), record.headers());
    }

    @Override
    public void onAcknowledgement(RecordMetadata metadata, Exception exception) {
    }

    @Override
    public void close() {
    }

    @Override
    public void configure(Map<String, ?> configs) {
    }
}

