/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventData;
import io.cloudevents.core.CloudEventUtils;
import io.cloudevents.jackson.JsonCloudEventData;
import io.cloudevents.jackson.JsonFormat;
import io.cloudevents.rw.CloudEventContextReader;
import io.cloudevents.rw.CloudEventContextWriter;
import io.cloudevents.rw.CloudEventRWException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

class CloudEventSerializer
extends StdSerializer<CloudEvent> {
    private final boolean forceDataBase64Serialization;
    private final boolean forceStringSerialization;

    protected CloudEventSerializer(boolean forceDataBase64Serialization, boolean forceStringSerialization) {
        super(CloudEvent.class);
        this.forceDataBase64Serialization = forceDataBase64Serialization;
        this.forceStringSerialization = forceStringSerialization;
    }

    @Override
    public void serialize(CloudEvent value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("specversion", value.getSpecVersion().toString());
        try {
            CloudEventContextReader contextReader = CloudEventUtils.toContextReader(value);
            JsonContextWriter contextWriter = new JsonContextWriter(gen, provider);
            contextReader.readContext(contextWriter);
        }
        catch (RuntimeException e) {
            throw (IOException)e.getCause();
        }
        if (value.getData() != null) {
            CloudEventData data = value.getData();
            if (data instanceof JsonCloudEventData) {
                gen.writeObjectField("data", ((JsonCloudEventData)data).getNode());
            } else {
                byte[] dataBytes = data.toBytes();
                String contentType = value.getDataContentType();
                if (this.shouldSerializeBase64(contentType)) {
                    switch (value.getSpecVersion()) {
                        case V03: {
                            gen.writeStringField("datacontentencoding", "base64");
                            gen.writeFieldName("data");
                            gen.writeBinary(dataBytes);
                            break;
                        }
                        case V1: {
                            gen.writeFieldName("data_base64");
                            gen.writeBinary(dataBytes);
                        }
                    }
                } else if (JsonFormat.dataIsJsonContentType(contentType)) {
                    char[] dataAsString = new String(dataBytes, StandardCharsets.UTF_8).toCharArray();
                    gen.writeFieldName("data");
                    gen.writeRawValue(dataAsString, 0, dataAsString.length);
                } else {
                    gen.writeFieldName("data");
                    gen.writeUTF8String(dataBytes, 0, dataBytes.length);
                }
            }
        }
        gen.writeEndObject();
    }

    private boolean shouldSerializeBase64(String contentType) {
        if (JsonFormat.dataIsJsonContentType(contentType)) {
            return this.forceDataBase64Serialization;
        }
        return !this.forceStringSerialization;
    }

    private static class JsonContextWriter
    implements CloudEventContextWriter {
        private final JsonGenerator gen;
        private final SerializerProvider provider;

        public JsonContextWriter(JsonGenerator gen, SerializerProvider provider) {
            this.gen = gen;
            this.provider = provider;
        }

        @Override
        public CloudEventContextWriter withContextAttribute(String name2, String value) throws CloudEventRWException {
            try {
                this.gen.writeStringField(name2, value);
                return this;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public CloudEventContextWriter withContextAttribute(String name2, Number value) throws CloudEventRWException {
            if (value instanceof Integer) {
                this.withContextAttribute(name2, (Integer)value);
            } else {
                this.withContextAttribute(name2, value.toString());
            }
            return this;
        }

        @Override
        public CloudEventContextWriter withContextAttribute(String name2, Integer value) throws CloudEventRWException {
            try {
                this.gen.writeNumberField(name2, value);
                return this;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public CloudEventContextWriter withContextAttribute(String name2, Boolean value) throws CloudEventRWException {
            try {
                this.gen.writeBooleanField(name2, value);
                return this;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

