/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.core.v03;

import io.cloudevents.core.v03.CloudEventBuilder;
import io.cloudevents.rw.CloudEventContextWriter;
import io.cloudevents.rw.CloudEventRWException;
import io.cloudevents.types.Time;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.OffsetDateTime;

class V1ToV03AttributesConverter
implements CloudEventContextWriter {
    private final CloudEventBuilder builder;

    V1ToV03AttributesConverter(CloudEventBuilder builder) {
        this.builder = builder;
    }

    @Override
    public CloudEventContextWriter withContextAttribute(String name2, String value) throws CloudEventRWException {
        switch (name2) {
            case "id": {
                this.builder.withId(value);
                return this;
            }
            case "source": {
                try {
                    this.builder.withSource(new URI(value));
                }
                catch (URISyntaxException e) {
                    throw CloudEventRWException.newInvalidAttributeValue("source", value, e);
                }
                return this;
            }
            case "type": {
                this.builder.withType(value);
                return this;
            }
            case "datacontenttype": {
                this.builder.withDataContentType(value);
                return this;
            }
            case "dataschema": {
                try {
                    this.builder.withSchemaUrl(new URI(value));
                }
                catch (URISyntaxException e) {
                    throw CloudEventRWException.newInvalidAttributeValue("dataschema", value, e);
                }
                return this;
            }
            case "subject": {
                this.builder.withSubject(value);
                return this;
            }
            case "time": {
                this.builder.withTime(Time.parseTime("time", value));
                return this;
            }
        }
        this.builder.withExtension(name2, value);
        return this;
    }

    @Override
    public CloudEventContextWriter withContextAttribute(String name2, URI value) throws CloudEventRWException {
        switch (name2) {
            case "source": {
                this.builder.withSource(value);
                return this;
            }
            case "dataschema": {
                this.builder.withSchemaUrl(value);
                return this;
            }
            case "id": 
            case "type": 
            case "datacontenttype": 
            case "subject": 
            case "time": {
                throw CloudEventRWException.newInvalidAttributeType(name2, URI.class);
            }
        }
        this.builder.withExtension(name2, value);
        return this;
    }

    @Override
    public CloudEventContextWriter withContextAttribute(String name2, OffsetDateTime value) throws CloudEventRWException {
        switch (name2) {
            case "time": {
                this.builder.withTime(value);
                return this;
            }
            case "source": 
            case "dataschema": 
            case "id": 
            case "type": 
            case "datacontenttype": 
            case "subject": {
                throw CloudEventRWException.newInvalidAttributeType(name2, OffsetDateTime.class);
            }
        }
        this.builder.withExtension(name2, value);
        return this;
    }

    @Override
    public CloudEventContextWriter withContextAttribute(String name2, Number value) throws CloudEventRWException {
        switch (name2) {
            case "time": 
            case "source": 
            case "dataschema": 
            case "id": 
            case "type": 
            case "datacontenttype": 
            case "subject": {
                throw CloudEventRWException.newInvalidAttributeType(name2, Number.class);
            }
        }
        this.builder.withExtension(name2, value);
        return this;
    }

    @Override
    public CloudEventContextWriter withContextAttribute(String name2, Boolean value) throws CloudEventRWException {
        switch (name2) {
            case "time": 
            case "source": 
            case "dataschema": 
            case "id": 
            case "type": 
            case "datacontenttype": 
            case "subject": {
                throw CloudEventRWException.newInvalidAttributeType(name2, Boolean.class);
            }
        }
        this.builder.withExtension(name2, value);
        return this;
    }
}

