/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.core.v03;

import io.cloudevents.CloudEventData;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.impl.BaseCloudEvent;
import io.cloudevents.lang.Nullable;
import io.cloudevents.rw.CloudEventContextWriter;
import io.cloudevents.rw.CloudEventRWException;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Objects;

public final class CloudEventV03
extends BaseCloudEvent {
    public static final String ID = "id";
    public static final String SOURCE = "source";
    public static final String SPECVERSION = "specversion";
    public static final String TYPE = "type";
    public static final String TIME = "time";
    public static final String SCHEMAURL = "schemaurl";
    public static final String DATACONTENTTYPE = "datacontenttype";
    public static final String DATACONTENTENCODING = "datacontentencoding";
    public static final String SUBJECT = "subject";
    private final String id;
    private final URI source;
    private final String type;
    private final String datacontenttype;
    private final URI schemaurl;
    private final String subject;
    private final OffsetDateTime time;

    public CloudEventV03(String id, URI source2, String type, OffsetDateTime time, URI schemaurl, String datacontenttype, String subject, CloudEventData data, Map<String, Object> extensions) {
        super(data, extensions);
        this.id = id;
        this.source = source2;
        this.type = type;
        this.time = time;
        this.schemaurl = schemaurl;
        this.datacontenttype = datacontenttype;
        this.subject = subject;
    }

    @Override
    public SpecVersion getSpecVersion() {
        return SpecVersion.V03;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public URI getSource() {
        return this.source;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getDataContentType() {
        return this.datacontenttype;
    }

    @Override
    public URI getDataSchema() {
        return this.schemaurl;
    }

    @Nullable
    public URI getSchemaUrl() {
        return this.schemaurl;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public OffsetDateTime getTime() {
        return this.time;
    }

    @Override
    public Object getAttribute(String attributeName) {
        switch (attributeName) {
            case "specversion": {
                return this.getSpecVersion();
            }
            case "id": {
                return this.id;
            }
            case "source": {
                return this.source;
            }
            case "type": {
                return this.type;
            }
            case "datacontenttype": {
                return this.datacontenttype;
            }
            case "schemaurl": {
                return this.schemaurl;
            }
            case "subject": {
                return this.subject;
            }
            case "time": {
                return this.time;
            }
            case "datacontentencoding": {
                return null;
            }
        }
        throw new IllegalArgumentException("Spec version v0.3 doesn't have attribute named " + attributeName);
    }

    @Override
    public void readContext(CloudEventContextWriter writer) throws CloudEventRWException {
        writer.withContextAttribute(ID, this.id);
        writer.withContextAttribute(SOURCE, this.source);
        writer.withContextAttribute(TYPE, this.type);
        if (this.datacontenttype != null) {
            writer.withContextAttribute(DATACONTENTTYPE, this.datacontenttype);
        }
        if (this.schemaurl != null) {
            writer.withContextAttribute(SCHEMAURL, this.schemaurl);
        }
        if (this.subject != null) {
            writer.withContextAttribute(SUBJECT, this.subject);
        }
        if (this.time != null) {
            writer.withContextAttribute(TIME, this.time);
        }
        this.readExtensions(writer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CloudEventV03 that = (CloudEventV03)o;
        return Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getSource(), that.getSource()) && Objects.equals(this.getType(), that.getType()) && Objects.equals(this.datacontenttype, that.datacontenttype) && Objects.equals(this.schemaurl, that.schemaurl) && Objects.equals(this.getSubject(), that.getSubject()) && Objects.equals(this.getTime(), that.getTime()) && Objects.equals(this.getData(), that.getData()) && Objects.equals(this.extensions, that.extensions);
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getSource(), this.getType(), this.datacontenttype, this.schemaurl, this.getSubject(), this.getTime(), this.getData(), this.extensions);
    }

    public String toString() {
        return "CloudEvent{id='" + this.id + '\'' + ", source=" + this.source + ", type='" + this.type + '\'' + (this.datacontenttype != null ? ", datacontenttype='" + this.datacontenttype + '\'' : "") + (this.schemaurl != null ? ", schemaurl=" + this.schemaurl : "") + (this.subject != null ? ", subject='" + this.subject + '\'' : "") + (this.time != null ? ", time=" + this.time : "") + (this.getData() != null ? ", data=" + this.getData() : "") + ", extensions=" + this.extensions + '}';
    }
}

