/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.core.impl;

import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventContext;
import io.cloudevents.CloudEventData;
import io.cloudevents.CloudEventExtension;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.cloudevents.core.data.BytesCloudEventData;
import io.cloudevents.rw.CloudEventRWException;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public abstract class BaseCloudEventBuilder<SELF extends BaseCloudEventBuilder<SELF, T>, T extends CloudEvent>
implements CloudEventBuilder {
    private final SELF self;
    protected CloudEventData data;
    protected Map<String, Object> extensions = new HashMap<String, Object>();

    public BaseCloudEventBuilder() {
        this.self = this;
    }

    public BaseCloudEventBuilder(CloudEventContext context) {
        this();
        this.setAttributes(context);
    }

    public BaseCloudEventBuilder(CloudEvent event) {
        this();
        this.setAttributes(event);
        this.data = event.getData();
    }

    protected abstract void setAttributes(CloudEventContext var1);

    public SELF withData(byte[] data) {
        this.data = BytesCloudEventData.wrap(data);
        return this.self;
    }

    public SELF withData(String dataContentType, byte[] data) {
        this.withDataContentType(dataContentType);
        this.withData(data);
        return this.self;
    }

    public SELF withData(String dataContentType, URI dataSchema, byte[] data) {
        this.withDataContentType(dataContentType);
        this.withDataSchema(dataSchema);
        this.withData(data);
        return this.self;
    }

    public SELF withData(CloudEventData data) {
        this.data = data;
        return this.self;
    }

    public SELF withData(String dataContentType, CloudEventData data) {
        this.withDataContentType(dataContentType);
        this.withData(data);
        return this.self;
    }

    public SELF withData(String dataContentType, URI dataSchema, CloudEventData data) {
        this.withDataContentType(dataContentType);
        this.withDataSchema(dataSchema);
        this.withData(data);
        return this.self;
    }

    @Override
    public CloudEventBuilder withoutData() {
        this.data = null;
        return this.self;
    }

    @Override
    public CloudEventBuilder withoutDataSchema() {
        this.withDataSchema(null);
        return this.self;
    }

    @Override
    public CloudEventBuilder withoutDataContentType() {
        this.withDataContentType(null);
        return this.self;
    }

    public SELF withExtension(@Nonnull String key, @Nonnull String value) {
        if (!BaseCloudEventBuilder.isValidExtensionName(key)) {
            throw CloudEventRWException.newInvalidExtensionName(key);
        }
        this.extensions.put(key, value);
        return this.self;
    }

    public SELF withExtension(@Nonnull String key, @Nonnull Number value) {
        if (!BaseCloudEventBuilder.isValidExtensionName(key)) {
            throw CloudEventRWException.newInvalidExtensionName(key);
        }
        this.extensions.put(key, value);
        return this.self;
    }

    public SELF withExtension(@Nonnull String key, @Nonnull Integer value) {
        if (!BaseCloudEventBuilder.isValidExtensionName(key)) {
            throw CloudEventRWException.newInvalidExtensionName(key);
        }
        this.extensions.put(key, value);
        return this.self;
    }

    public SELF withExtension(@Nonnull String key, @Nonnull Boolean value) {
        if (!BaseCloudEventBuilder.isValidExtensionName(key)) {
            throw CloudEventRWException.newInvalidExtensionName(key);
        }
        this.extensions.put(key, value);
        return this.self;
    }

    public SELF withExtension(@Nonnull String key, @Nonnull URI value) {
        if (!BaseCloudEventBuilder.isValidExtensionName(key)) {
            throw CloudEventRWException.newInvalidExtensionName(key);
        }
        this.extensions.put(key, value);
        return this.self;
    }

    public SELF withExtension(@Nonnull String key, @Nonnull OffsetDateTime value) {
        if (!BaseCloudEventBuilder.isValidExtensionName(key)) {
            throw CloudEventRWException.newInvalidExtensionName(key);
        }
        this.extensions.put(key, value);
        return this.self;
    }

    @Override
    public CloudEventBuilder withExtension(@Nonnull String key, @Nonnull byte[] value) {
        if (!BaseCloudEventBuilder.isValidExtensionName(key)) {
            throw CloudEventRWException.newInvalidExtensionName(key);
        }
        this.extensions.put(key, value);
        return this.self;
    }

    public SELF withoutExtension(@Nonnull String key) {
        this.extensions.remove(key);
        return this.self;
    }

    public SELF withoutExtension(@Nonnull CloudEventExtension extension) {
        extension.getKeys().forEach(string -> this.withoutExtension((String)string));
        return this.self;
    }

    public SELF withExtension(@Nonnull CloudEventExtension extension) {
        for (String key : extension.getKeys()) {
            Object value = extension.getValue(key);
            if (value == null) continue;
            this.extensions.put(key, value);
        }
        return this.self;
    }

    @Override
    public CloudEvent end(CloudEventData value) throws CloudEventRWException {
        this.data = value;
        return this.build();
    }

    @Override
    public CloudEvent end() {
        try {
            return this.build();
        }
        catch (Exception e) {
            throw CloudEventRWException.newOther(e);
        }
    }

    protected static IllegalStateException createMissingAttributeException(String attributeName) {
        return new IllegalStateException("Attribute '" + attributeName + "' cannot be null");
    }

    private static boolean isValidExtensionName(String name2) {
        for (int i = 0; i < name2.length(); ++i) {
            if (BaseCloudEventBuilder.isValidChar(name2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidChar(char c) {
        return c >= 'a' && c <= 'z' || c >= '0' && c <= '9';
    }

    protected void requireValidAttributeWrite(String name2) {
        if (name2.equals("specversion")) {
            throw new IllegalArgumentException("You should not set the specversion attribute through withContextAttribute methods");
        }
    }
}

