/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents;

import io.cloudevents.SpecVersion;
import io.cloudevents.lang.Nullable;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface CloudEventAttributes {
    public SpecVersion getSpecVersion();

    public String getId();

    public String getType();

    public URI getSource();

    @Nullable
    public String getDataContentType();

    @Nullable
    public URI getDataSchema();

    @Nullable
    public String getSubject();

    @Nullable
    public OffsetDateTime getTime();

    @Nullable
    public Object getAttribute(String var1) throws IllegalArgumentException;

    default public Set<String> getAttributeNames() {
        return this.getSpecVersion().getAllAttributes().stream().filter(s2 -> this.getAttribute((String)s2) != null).collect(Collectors.toSet());
    }
}

