/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema.internal;

import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.internal._PlatformKt;
import com.squareup.wire.schema.EnumType;
import com.squareup.wire.schema.Extend;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.internal.NameFactory;
import java.lang.annotation.ElementType;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001c\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\u0016\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u0010\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u001a\u0010\u0010\u0013\u001a\u00020\u00142\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u001a\u000e\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u0016\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u000e\u0010\u0019\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a9\u0010\u001a\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\n2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001e2\b\b\u0002\u0010\u001f\u001a\u00020\u0001\u00a2\u0006\u0002\u0010 \u00a8\u0006!"}, d2={"builtInAdapterString", "", "type", "Lcom/squareup/wire/schema/ProtoType;", "useArray", "", "eligibleAsAnnotationMember", "schema", "Lcom/squareup/wire/schema/Schema;", "field", "Lcom/squareup/wire/schema/Field;", "annotationTargetType", "Ljava/lang/annotation/ElementType;", "extend", "Lcom/squareup/wire/schema/Extend;", "optionValueToInt", "", "value", "", "optionValueToLong", "", "javaPackage", "protoFile", "Lcom/squareup/wire/schema/ProtoFile;", "hasEponymousType", "legacyQualifiedFieldName", "annotationName", "T", "extension", "factory", "Lcom/squareup/wire/schema/internal/NameFactory;", "simpleNameSuffix", "(Lcom/squareup/wire/schema/ProtoFile;Lcom/squareup/wire/schema/Field;Lcom/squareup/wire/schema/internal/NameFactory;Ljava/lang/String;)Ljava/lang/Object;", "wire-schema"})
@JvmName(name="JvmLanguages")
public final class JvmLanguages {
    @JvmOverloads
    @Nullable
    public static final String builtInAdapterString(@NotNull ProtoType type, boolean useArray) {
        Intrinsics.checkNotNullParameter(type, "type");
        if (type.isScalar()) {
            if (useArray) {
                String string;
                ProtoType protoType = type;
                if (Intrinsics.areEqual(protoType, ProtoType.INT32)) {
                    string = ProtoAdapter.class.getName() + "#INT32_ARRAY";
                } else if (Intrinsics.areEqual(protoType, ProtoType.UINT32)) {
                    string = ProtoAdapter.class.getName() + "#UINT32_ARRAY";
                } else if (Intrinsics.areEqual(protoType, ProtoType.SINT32)) {
                    string = ProtoAdapter.class.getName() + "#SINT32_ARRAY";
                } else if (Intrinsics.areEqual(protoType, ProtoType.FIXED32)) {
                    string = ProtoAdapter.class.getName() + "#FIXED32_ARRAY";
                } else if (Intrinsics.areEqual(protoType, ProtoType.SFIXED32)) {
                    string = ProtoAdapter.class.getName() + "#SFIXED32_ARRAY";
                } else if (Intrinsics.areEqual(protoType, ProtoType.INT64)) {
                    string = ProtoAdapter.class.getName() + "#INT64_ARRAY";
                } else if (Intrinsics.areEqual(protoType, ProtoType.UINT64)) {
                    string = ProtoAdapter.class.getName() + "#UINT64_ARRAY";
                } else if (Intrinsics.areEqual(protoType, ProtoType.SINT64)) {
                    string = ProtoAdapter.class.getName() + "#SINT64_ARRAY";
                } else if (Intrinsics.areEqual(protoType, ProtoType.FIXED64)) {
                    string = ProtoAdapter.class.getName() + "#FIXED64_ARRAY";
                } else if (Intrinsics.areEqual(protoType, ProtoType.SFIXED64)) {
                    string = ProtoAdapter.class.getName() + "#SFIXED64_ARRAY";
                } else if (Intrinsics.areEqual(protoType, ProtoType.FLOAT)) {
                    string = ProtoAdapter.class.getName() + "#FLOAT_ARRAY";
                } else if (Intrinsics.areEqual(protoType, ProtoType.DOUBLE)) {
                    string = ProtoAdapter.class.getName() + "#DOUBLE_ARRAY";
                } else {
                    throw new IllegalArgumentException("No Array adapter for " + type);
                }
                return string;
            }
            StringBuilder stringBuilder = new StringBuilder().append(ProtoAdapter.class.getName()).append('#');
            String string = type.toString();
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue(locale, "US");
            String string2 = string.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
            return stringBuilder.append(string2).toString();
        }
        ProtoType protoType = type;
        return Intrinsics.areEqual(protoType, ProtoType.DURATION) ? ProtoAdapter.class.getName() + "#DURATION" : (Intrinsics.areEqual(protoType, ProtoType.TIMESTAMP) ? ProtoAdapter.class.getName() + "#INSTANT" : (Intrinsics.areEqual(protoType, ProtoType.EMPTY) ? ProtoAdapter.class.getName() + "#EMPTY" : (Intrinsics.areEqual(protoType, ProtoType.STRUCT_MAP) ? ProtoAdapter.class.getName() + "#STRUCT_MAP" : (Intrinsics.areEqual(protoType, ProtoType.STRUCT_VALUE) ? ProtoAdapter.class.getName() + "#STRUCT_VALUE" : (Intrinsics.areEqual(protoType, ProtoType.STRUCT_NULL) ? ProtoAdapter.class.getName() + "#STRUCT_NULL" : (Intrinsics.areEqual(protoType, ProtoType.STRUCT_LIST) ? ProtoAdapter.class.getName() + "#STRUCT_LIST" : (Intrinsics.areEqual(protoType, ProtoType.DOUBLE_VALUE) ? ProtoAdapter.class.getName() + "#DOUBLE_VALUE" : (Intrinsics.areEqual(protoType, ProtoType.FLOAT_VALUE) ? ProtoAdapter.class.getName() + "#FLOAT_VALUE" : (Intrinsics.areEqual(protoType, ProtoType.INT64_VALUE) ? ProtoAdapter.class.getName() + "#INT64_VALUE" : (Intrinsics.areEqual(protoType, ProtoType.UINT64_VALUE) ? ProtoAdapter.class.getName() + "#UINT64_VALUE" : (Intrinsics.areEqual(protoType, ProtoType.INT32_VALUE) ? ProtoAdapter.class.getName() + "#INT32_VALUE" : (Intrinsics.areEqual(protoType, ProtoType.UINT32_VALUE) ? ProtoAdapter.class.getName() + "#UINT32_VALUE" : (Intrinsics.areEqual(protoType, ProtoType.BOOL_VALUE) ? ProtoAdapter.class.getName() + "#BOOL_VALUE" : (Intrinsics.areEqual(protoType, ProtoType.STRING_VALUE) ? ProtoAdapter.class.getName() + "#STRING_VALUE" : (Intrinsics.areEqual(protoType, ProtoType.BYTES_VALUE) ? ProtoAdapter.class.getName() + "#BYTES_VALUE" : null)))))))))))))));
    }

    public static /* synthetic */ String builtInAdapterString$default(ProtoType protoType, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return JvmLanguages.builtInAdapterString(protoType, bl);
    }

    public static final boolean eligibleAsAnnotationMember(@NotNull Schema schema, @NotNull Field field) {
        Intrinsics.checkNotNullParameter(schema, "schema");
        Intrinsics.checkNotNullParameter(field, "field");
        ProtoType protoType = field.getType();
        Intrinsics.checkNotNull(protoType);
        ProtoType type = protoType;
        if (Intrinsics.areEqual(type, ProtoType.BYTES)) {
            return false;
        }
        if (!type.isScalar() && !(schema.getType(type) instanceof EnumType)) {
            return false;
        }
        String qualifiedName = field.getQualifiedName();
        if (StringsKt.startsWith$default(qualifiedName, "google.protobuf.", false, 2, null) || StringsKt.startsWith$default(qualifiedName, "wire.", false, 2, null)) {
            return false;
        }
        return !Intrinsics.areEqual(field.getName(), "redacted");
    }

    @Nullable
    public static final ElementType annotationTargetType(@NotNull Extend extend) {
        Intrinsics.checkNotNullParameter(extend, "extend");
        ProtoType protoType = extend.getType();
        Intrinsics.checkNotNull(protoType);
        ProtoType protoType2 = protoType;
        return Intrinsics.areEqual(protoType2, Options.MESSAGE_OPTIONS) || Intrinsics.areEqual(protoType2, Options.ENUM_OPTIONS) || Intrinsics.areEqual(protoType2, Options.SERVICE_OPTIONS) ? ElementType.TYPE : (Intrinsics.areEqual(protoType2, Options.FIELD_OPTIONS) || Intrinsics.areEqual(protoType2, Options.ENUM_VALUE_OPTIONS) ? ElementType.FIELD : (Intrinsics.areEqual(protoType2, Options.METHOD_OPTIONS) ? ElementType.METHOD : null));
    }

    public static final int optionValueToInt(@Nullable Object value) {
        int n;
        if (value == null) {
            return 0;
        }
        String string = value.toString();
        if (StringsKt.startsWith$default(string, "0x", false, 2, null) || StringsKt.startsWith$default(string, "0X", false, 2, null)) {
            String string2 = string.substring(2);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            n = Integer.parseInt(string2, CharsKt.checkRadix(16));
        } else {
            if (StringsKt.startsWith$default(string, "0", false, 2, null) && !Intrinsics.areEqual(string, "0")) {
                throw new IllegalStateException(("Octal literal unsupported: " + value).toString());
            }
            n = new BigInteger(string).intValue();
        }
        return n;
    }

    public static final long optionValueToLong(@Nullable Object value) {
        long l;
        if (value == null) {
            return 0L;
        }
        String string = value.toString();
        if (StringsKt.startsWith$default(string, "0x", false, 2, null) || StringsKt.startsWith$default(string, "0X", false, 2, null)) {
            String string2 = string.substring(2);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            l = Long.parseLong(string2, CharsKt.checkRadix(16));
        } else {
            if (StringsKt.startsWith$default(string, "0", false, 2, null) && !Intrinsics.areEqual(string, "0")) {
                throw new IllegalStateException(("Octal literal unsupported: " + value).toString());
            }
            l = new BigInteger(string).longValue();
        }
        return l;
    }

    @NotNull
    public static final String javaPackage(@NotNull ProtoFile protoFile) {
        Intrinsics.checkNotNullParameter(protoFile, "protoFile");
        String wirePackage = protoFile.wirePackage();
        if (wirePackage != null) {
            return wirePackage;
        }
        String javaPackage = protoFile.javaPackage();
        if (javaPackage != null) {
            return javaPackage;
        }
        String string = protoFile.getPackageName();
        if (string == null) {
            string = "";
        }
        return string;
    }

    public static final boolean hasEponymousType(@NotNull Schema schema, @NotNull Field field) {
        Intrinsics.checkNotNullParameter(schema, "schema");
        Intrinsics.checkNotNullParameter(field, "field");
        return schema.getType(JvmLanguages.legacyQualifiedFieldName(field)) != null;
    }

    @NotNull
    public static final String legacyQualifiedFieldName(@NotNull Field field) {
        Intrinsics.checkNotNullParameter(field, "field");
        return StringsKt.isBlank(field.getPackageName()) ? field.getName() : field.getPackageName() + '.' + field.getName();
    }

    public static final <T> T annotationName(@NotNull ProtoFile protoFile, @NotNull Field extension, @NotNull NameFactory<T> factory, @NotNull String simpleNameSuffix) {
        List<String> list;
        Intrinsics.checkNotNullParameter(protoFile, "protoFile");
        Intrinsics.checkNotNullParameter(extension, "extension");
        Intrinsics.checkNotNullParameter(factory, "factory");
        Intrinsics.checkNotNullParameter(simpleNameSuffix, "simpleNameSuffix");
        String simpleName = _PlatformKt.camelCase(extension.getName(), true) + simpleNameSuffix;
        switch (extension.getNamespaces().size()) {
            case 0: 
            case 1: {
                list = CollectionsKt.listOf(simpleName);
                break;
            }
            default: {
                list = CollectionsKt.plus((Collection)extension.getNamespaces().subList(1, extension.getNamespaces().size()), simpleName);
            }
        }
        List<String> names = list;
        Object type = null;
        for (String n : names) {
            type = type == null ? factory.newName(JvmLanguages.javaPackage(protoFile), n) : factory.nestedName(type, n);
        }
        if (type == null) {
            throw new NullPointerException();
        }
        return type;
    }

    public static /* synthetic */ Object annotationName$default(ProtoFile protoFile, Field field, NameFactory nameFactory, String string, int n, Object object) {
        if ((n & 8) != 0) {
            string = "Option";
        }
        return JvmLanguages.annotationName(protoFile, field, nameFactory, string);
    }

    @JvmOverloads
    @Nullable
    public static final String builtInAdapterString(@NotNull ProtoType type) {
        Intrinsics.checkNotNullParameter(type, "type");
        return JvmLanguages.builtInAdapterString$default(type, false, 2, null);
    }
}

