/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.server.handler;

import com.networknt.config.JsonMapper;
import com.networknt.handler.LightHttpHandler;
import com.networknt.server.Server;
import com.networknt.server.ServerConfig;
import com.networknt.server.model.ServerShutdownResponse;
import io.undertow.server.HttpServerExchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerShutdownHandler
implements LightHttpHandler {
    private static final Logger logger = LoggerFactory.getLogger(ServerShutdownHandler.class);

    public ServerShutdownHandler() {
        logger.info("ServerShutdownHandler constructed");
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        try {
            ServerConfig serverConfig = ServerConfig.getInstance();
            ServerShutdownResponse response = new ServerShutdownResponse();
            response.setTime(System.currentTimeMillis());
            response.setServiceId(serverConfig.getServiceId());
            response.setTag(serverConfig.getEnvironment());
            exchange.getResponseSender().send(JsonMapper.toJson(response));
            logger.info("ServerShutdownHandler - Killing the Server!");
            Server.shutdown();
            System.exit(0);
        }
        catch (Exception e) {
            logger.info("ServerShutdownHandler - Unable to kill the Server!", e);
        }
    }
}

