/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.server;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.client.Http2Client;
import com.networknt.config.Config;
import com.networknt.server.IConfigLoader;
import com.networknt.server.Server;
import com.networknt.server.ServerConfig;
import com.networknt.utility.StringUtils;
import io.undertow.UndertowOptions;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStore;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.jose4j.json.internal.json_simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class UrlConfigLoader
implements IConfigLoader {
    static final Logger logger = LoggerFactory.getLogger(UrlConfigLoader.class);
    public static final String CONFIG_SERVER_URI = "light-config-server-uri";
    public static final String CONFIG_SERVER_PATH = "light-config-server-path";
    public static String configServerUri = System.getProperty("light-config-server-uri");
    public static String configServerPath = System.getProperty("light-config-server-path", "/light-service-configs");
    public static final String LIGHT_ENV = "light-env";
    public static final String DEFAULT_ENV = "dev";
    public static final String DEFAULT_TARGET_CONFIGS_DIRECTORY = "src/main/resources/config";
    public static String lightEnv = System.getProperty("light-env", "dev");
    public static String targetConfigsDirectory = System.getProperty("light-4j-config-dir", "src/main/resources/config");
    public static Map<String, Object> startupConfig = Config.getInstance().getJsonMapConfig("startup");
    public static final String PROJECT_NAME = "projectName";
    public static final String PROJECT_VERSION = "projectVersion";
    public static final String SERVICE_NAME = "serviceName";
    public static final String SERVICE_VERSION = "serviceVersion";
    public static final String AUTHORIZATION = "config_server_authorization";
    public static final String CLIENT_TRUSTSTORE_PASS = "config_server_client_truststore_password";
    public static final String CLIENT_TRUSTSTORE_LOC = "config_server_client_truststore_location";
    public static final String VERIFY_HOST_NAME = "config_server_client_verify_host_name";
    public static final String clientToken = System.getenv("config_server_authorization");
    public static final String CONFIGS = "configs";
    public static final String FILES = "files";
    public static final String CERTS = "certs";
    public static final String GLOBALS = "globals";
    public static final String SLASH = "/";
    static final String CONFIGS_FILE_NAME = "values";
    static final String CONFIG_EXT_JSON = ".json";
    static final String CONFIG_EXT_YAML = ".yaml";
    static final String CONFIG_EXT_YML = ".yml";
    static final String[] configExtensionsOrdered = new String[]{".yml", ".yaml", ".json"};
    static final ObjectMapper mapper = new ObjectMapper();
    static final TypeReference<Map<String, Object>> mapType = new TypeReference<Map<String, Object>>(){};
    static final Pattern files = Pattern.compile(">([^>/]+)</a>");
    static Http2Client client = Http2Client.getInstance();
    ClientConnection connection = null;
    String host = null;

    @Override
    public void init() {
        if (StringUtils.isBlank(configServerUri)) {
            return;
        }
        try {
            logger.info("init url config: {}{}", (Object)configServerUri, (Object)configServerPath);
            URI uri = new URI(configServerUri);
            this.host = uri.getHost();
            this.connection = client.connect(uri, Http2Client.WORKER, client.createXnioSsl(UrlConfigLoader.createBootstrapContext()), Http2Client.BUFFER_POOL, OptionMap.create(UndertowOptions.ENABLE_HTTP2, true)).get();
            this.loadConfigs();
            this.loadFiles(CERTS);
            this.loadFiles(FILES);
        }
        catch (Exception e) {
            logger.error("Failed to connect to config server", e);
        }
        finally {
            IoUtils.safeClose((Closeable)this.connection);
        }
    }

    @Override
    public void reloadConfig() {
        if (StringUtils.isBlank(configServerUri)) {
            return;
        }
        try {
            logger.info("init url config: {}{}", (Object)configServerUri, (Object)configServerPath);
            URI uri = new URI(configServerUri);
            this.host = uri.getHost();
            this.connection = client.connect(uri, Http2Client.WORKER, client.createXnioSsl(UrlConfigLoader.createBootstrapContext()), Http2Client.BUFFER_POOL, OptionMap.create(UndertowOptions.ENABLE_HTTP2, true)).get();
            this.loadConfigs();
        }
        catch (Exception e) {
            logger.error("Failed to connect to config server", e);
        }
        finally {
            IoUtils.safeClose((Closeable)this.connection);
        }
    }

    private void loadConfigs() {
        Map<String, Object> serviceConfigs = new HashMap<String, Object>();
        serviceConfigs.putAll(this.getServiceConfigs(true));
        serviceConfigs.putAll(this.getServiceConfigs(false));
        serviceConfigs.put("environment", lightEnv);
        logger.debug("loadConfigs: {}", (Object)serviceConfigs);
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        serviceConfigs = (Map)Config.getInstance().getYaml().load(new Yaml(options).dump(serviceConfigs));
        Config.getInstance().clear();
        Config.getInstance().putInConfigCache(CONFIGS_FILE_NAME, serviceConfigs);
    }

    private void loadFiles(String configType) {
        HashMap<String, byte[]> serviceFiles = new HashMap<String, byte[]>();
        serviceFiles.putAll(this.getServiceFiles(configType, true));
        serviceFiles.putAll(this.getServiceFiles(configType, false));
        logger.debug("{} files loaded from config sever.", (Object)serviceFiles.size());
        logger.debug("loadFiles: {}", (Object)serviceFiles);
        try {
            Path filePath = Paths.get(targetConfigsDirectory, new String[0]);
            if (!Files.exists(filePath, new LinkOption[0])) {
                Files.createDirectories(filePath, new FileAttribute[0]);
                logger.info("target configs directory created :", (Object)targetConfigsDirectory);
            }
            for (String fileName : serviceFiles.keySet()) {
                filePath = Paths.get(targetConfigsDirectory + SLASH + fileName, new String[0]);
                Files.write(filePath, (byte[])serviceFiles.get(fileName), new OpenOption[0]);
            }
        }
        catch (IOException e) {
            logger.error("Exception while creating {} dir or creating files there:{}", (Object)targetConfigsDirectory, (Object)e);
        }
    }

    private Map<String, Object> getServiceConfigs(boolean globals) {
        for (String extension : configExtensionsOrdered) {
            Map<String, Object> config = this.loadSpecificConfigFileAsMap(CONFIGS, globals, extension);
            if (config == null) continue;
            return config;
        }
        return Collections.emptyMap();
    }

    private Map<String, byte[]> getServiceFiles(String configType, boolean globals) {
        HashMap<String, byte[]> serviceFiles = new HashMap<String, byte[]>();
        String configPath = UrlConfigLoader.getConfigServerPath(configType, globals) + SLASH;
        String respBody = this.getString(configPath);
        if (StringUtils.isNotBlank(respBody)) {
            Matcher matcher = files.matcher(respBody);
            String endpoint = null;
            while (matcher.find()) {
                String file = matcher.group(1);
                endpoint = configPath + SLASH + file;
                byte[] bs = this.getBytes(endpoint);
                if (bs == null || bs.length <= 0) continue;
                serviceFiles.put(file, bs);
            }
        }
        return serviceFiles;
    }

    private Map<String, Object> loadSpecificConfigFileAsMap(String configType, boolean globals, String fileExtension2) {
        String endpoint = UrlConfigLoader.getConfigServerPath(configType, globals) + "/values" + fileExtension2;
        String respBody = this.getString(endpoint);
        if (StringUtils.isNotBlank(respBody)) {
            try {
                if (!CONFIG_EXT_JSON.equals(fileExtension2)) {
                    respBody = JSONValue.toJSONString(Config.getInstance().getYaml().load(respBody));
                }
                return mapper.readValue(respBody, mapType);
            }
            catch (Exception e) {
                logger.error("Exception while parsing Url response: {} {}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
            }
        }
        return null;
    }

    private static String getConfigServerPath(String configType, boolean globals) {
        StringBuilder configPath = new StringBuilder(configServerPath);
        configPath.append(SLASH).append(configType);
        configPath.append(SLASH).append(startupConfig.get(PROJECT_NAME));
        if (globals) {
            configPath.append(SLASH).append(GLOBALS);
            configPath.append(SLASH).append(startupConfig.get(PROJECT_VERSION));
        } else {
            configPath.append(SLASH).append(startupConfig.get(SERVICE_NAME));
            configPath.append(SLASH).append(startupConfig.get(SERVICE_VERSION));
        }
        configPath.append(SLASH).append(lightEnv);
        return configPath.toString();
    }

    private String getString(String endpoint) {
        Object object = this.sendRequest(clientToken, endpoint, false);
        return object == null ? null : (String)object;
    }

    private byte[] getBytes(String endpoint) {
        Object object = this.sendRequest(clientToken, endpoint, true);
        if (object != null) {
            ByteBuffer buffer = (ByteBuffer)object;
            return buffer.array();
        }
        return null;
    }

    private Object sendRequest(String clientToken, String endpoint, boolean raw) {
        try {
            logger.debug("GET url configs endpoint:{}{}", (Object)configServerUri, (Object)endpoint);
            ClientRequest clientRequest = new ClientRequest().setMethod(Methods.GET).setPath(endpoint);
            if (StringUtils.isNotBlank(clientToken)) {
                clientRequest.getRequestHeaders().put(Headers.AUTHORIZATION, clientToken);
            }
            clientRequest.getRequestHeaders().put(Headers.HOST, this.host);
            AtomicReference<ClientResponse> responseReference = new AtomicReference<ClientResponse>();
            CountDownLatch latch = new CountDownLatch(1);
            this.connection.sendRequest(clientRequest, raw ? client.byteBufferClientCallback(responseReference, latch) : client.createClientCallback(responseReference, latch));
            latch.await(10000L, TimeUnit.MILLISECONDS);
            ClientResponse clientResponse = responseReference.get();
            if (clientResponse != null) {
                int statusCode = clientResponse.getResponseCode();
                if (statusCode == 200) {
                    return raw ? clientResponse.getAttachment(Http2Client.BUFFER_BODY) : clientResponse.getAttachment(Http2Client.RESPONSE_BODY);
                }
                if (statusCode == 404) {
                    return null;
                }
            }
            logger.debug("Received client response: {}", (Object)clientResponse);
        }
        catch (Exception e) {
            logger.error("Exception while GET url: {} {}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
        }
        return null;
    }

    private static SSLContext createBootstrapContext() throws RuntimeException {
        SSLContext sslContext = null;
        try {
            TrustManager[] trustManagers = UrlConfigLoader.buildTrustManagers(UrlConfigLoader.loadBootstrapTrustStore());
            sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(null, trustManagers, null);
        }
        catch (Exception e) {
            logger.error("Unable to create SSLContext: {} {}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
        }
        return sslContext;
    }

    private static TrustManager[] buildTrustManagers(KeyStore trustStore) {
        try {
            if (trustStore != null) {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(trustStore);
                return trustManagerFactory.getTrustManagers();
            }
        }
        catch (Exception e) {
            logger.error("Unable to initialise TrustManager[]", e);
        }
        return Server.TRUST_ALL_CERTS;
    }

    private static KeyStore loadBootstrapTrustStore() {
        KeyStore keyStore;
        String truststorePassword = System.getenv(CLIENT_TRUSTSTORE_PASS);
        String truststoreLocation = System.getenv(CLIENT_TRUSTSTORE_LOC);
        if (truststorePassword == null && truststoreLocation == null) {
            truststorePassword = ServerConfig.getInstance().getBootstrapStorePass();
            truststoreLocation = ServerConfig.getInstance().getBootstrapStoreName();
        }
        if (StringUtils.isBlank(truststoreLocation)) {
            return null;
        }
        FileInputStream stream = new FileInputStream(truststoreLocation);
        try {
            KeyStore loadedKeystore = KeyStore.getInstance("JKS");
            loadedKeystore.load(stream, truststorePassword != null ? truststorePassword.toCharArray() : null);
            keyStore = loadedKeystore;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                logger.error("Unable to load truststore: " + truststoreLocation, e);
                return null;
            }
        }
        ((InputStream)stream).close();
        return keyStore;
    }
}

