/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.security;

import com.networknt.apikey.ApiKeyHandler;
import com.networknt.basicauth.BasicAuthHandler;
import com.networknt.config.Config;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.security.AbstractJwtVerifyHandler;
import com.networknt.security.AbstractSimpleJwtVerifyHandler;
import com.networknt.security.AbstractSwtVerifyHandler;
import com.networknt.security.JwtVerifier;
import com.networknt.security.SecurityConfig;
import com.networknt.security.UnifiedPathPrefixAuth;
import com.networknt.security.UnifiedSecurityConfig;
import com.networknt.status.Status;
import com.networknt.utility.ModuleRegistry;
import com.networknt.utility.StringUtils;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnifiedSecurityHandler
implements MiddlewareHandler {
    static final Logger logger = LoggerFactory.getLogger(UnifiedSecurityHandler.class);
    static final String BEARER_PREFIX = "BEARER";
    static final String BASIC_PREFIX = "BASIC";
    static final String API_KEY = "apikey";
    static final String JWT = "jwt";
    static final String SWT = "swt";
    static final String SJWT = "sjwt";
    static final String MISSING_AUTH_TOKEN = "ERR10002";
    static final String INVALID_AUTHORIZATION_HEADER = "ERR12003";
    static final String HANDLER_NOT_FOUND = "ERR11200";
    static final String MISSING_PATH_PREFIX_AUTH = "ERR10078";
    static UnifiedSecurityConfig config;
    private volatile HttpHandler next;
    public static JwtVerifier jwtVerifier;

    public UnifiedSecurityHandler() {
        logger.info("UnifiedSecurityHandler starts");
        config = UnifiedSecurityConfig.load();
        jwtVerifier = new JwtVerifier(SecurityConfig.load());
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        Status status;
        if (logger.isDebugEnabled()) {
            logger.debug("UnifiedSecurityHandler.handleRequest starts.");
        }
        if ((status = this.verifyUnifiedSecurity(exchange)) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("UnifiedSecurityHandler.handleRequest ends with an error.");
            }
            this.setExchangeStatus(exchange, status);
            exchange.endExchange();
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("UnifiedSecurityHandler.handleRequest ends.");
        }
        Handler.next(exchange, this.next);
    }

    public Status verifyUnifiedSecurity(HttpServerExchange exchange) throws Exception {
        String reqPath = exchange.getRequestPath();
        if (config.getAnonymousPrefixes() != null) {
            if (config.getAnonymousPrefixes().stream().anyMatch(reqPath::startsWith)) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Skip request path base on anonymousPrefixes for " + reqPath);
                }
                return null;
            }
        }
        if (config.getPathPrefixAuths() != null) {
            boolean found = false;
            for (UnifiedPathPrefixAuth pathPrefixAuth : config.getPathPrefixAuths()) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Check with requestPath = {} prefix = {}", (Object)reqPath, (Object)pathPrefixAuth.getPrefix());
                }
                if (!reqPath.startsWith(pathPrefixAuth.getPrefix())) continue;
                found = true;
                if (logger.isTraceEnabled()) {
                    logger.trace("Found with requestPath = {} prefix = {}", (Object)reqPath, (Object)pathPrefixAuth.getPrefix());
                }
                if (pathPrefixAuth.isBasic() || pathPrefixAuth.isJwt() || pathPrefixAuth.isSwt() || pathPrefixAuth.isSjwt()) {
                    String authorization = exchange.getRequestHeaders().getFirst(Headers.AUTHORIZATION);
                    if (authorization == null) {
                        logger.error("Basic or JWT or SWT or SJWT is enabled and authorization header is missing.");
                        if (pathPrefixAuth.isBasic()) {
                            if (logger.isTraceEnabled()) {
                                logger.trace("Basic is enabled and set WWW-Authenticate header to Basic realm=\"Default Realm\"");
                            }
                            exchange.getResponseHeaders().put(Headers.WWW_AUTHENTICATE, "Basic realm=\"Default Realm\"");
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug("UnifiedSecurityHandler.handleRequest ends with an error.");
                        }
                        return new Status(MISSING_AUTH_TOKEN, new Object[0]);
                    }
                    if (authorization.trim().length() <= 5) {
                        logger.error("Invalid/Unsupported authorization header {}", (Object)authorization);
                        return new Status(INVALID_AUTHORIZATION_HEADER, authorization);
                    }
                    if (BASIC_PREFIX.equalsIgnoreCase(authorization.substring(0, 5))) {
                        Map<String, HttpHandler> handlers = Handler.getHandlers();
                        BasicAuthHandler handler = (BasicAuthHandler)handlers.get(BASIC_PREFIX.toLowerCase());
                        if (handler == null) {
                            logger.error("Cannot find BasicAuthHandler with alias name basic.");
                            return new Status(HANDLER_NOT_FOUND, "com.networknt.basicauth.BasicAuthHandler@basic");
                        }
                        if (!handler.isEnabled() || handler.handleBasicAuth(exchange, reqPath, authorization)) break;
                        return null;
                    }
                    if (BEARER_PREFIX.equalsIgnoreCase(authorization.substring(0, 6))) {
                        Map<String, HttpHandler> handlers = Handler.getHandlers();
                        if (authorization.length() < 8) {
                            logger.error("Invalid authorization header {}", (Object)authorization);
                            return new Status(INVALID_AUTHORIZATION_HEADER, authorization);
                        }
                        String token = authorization.substring(7);
                        boolean isJwtOrSjwt = StringUtils.isJwtToken(token);
                        if (logger.isTraceEnabled()) {
                            logger.trace("Bearer token is jwt or sjwt = {}", (Object)isJwtOrSjwt);
                        }
                        if (isJwtOrSjwt) {
                            Status status;
                            AbstractJwtVerifyHandler handler;
                            if (pathPrefixAuth.isSjwt()) {
                                Status status2;
                                AbstractSimpleJwtVerifyHandler handler2;
                                if (logger.isTraceEnabled()) {
                                    logger.trace("SJWT is enabled.");
                                }
                                if (pathPrefixAuth.isJwt()) {
                                    Status status3;
                                    AbstractSimpleJwtVerifyHandler handler3;
                                    if (logger.isTraceEnabled()) {
                                        logger.trace("JWT is enabled along with SJWT.");
                                    }
                                    boolean isScopeInJwt = jwtVerifier.isScopeInJwt(token, pathPrefixAuth.getPrefix());
                                    if (logger.isTraceEnabled()) {
                                        logger.trace("Check token has scope = {}", (Object)isScopeInJwt);
                                    }
                                    if (isScopeInJwt) {
                                        Status status4;
                                        AbstractJwtVerifyHandler handler4;
                                        if (logger.isTraceEnabled()) {
                                            logger.trace("Both jwt and sjwt are true and it has scope. This is a jwt token.");
                                        }
                                        if ((handler4 = (AbstractJwtVerifyHandler)handlers.get(JWT)) == null) {
                                            logger.error("Cannot find JwtVerifyHandler with alias name jwt.");
                                            return new Status(HANDLER_NOT_FOUND, "com.networknt.openapi.JwtVerifyHandler@jwt");
                                        }
                                        if (!handler4.isEnabled() || (status4 = handler4.handleJwt(exchange, pathPrefixAuth.getPrefix(), reqPath, pathPrefixAuth.getJwkServiceIds())) == null) break;
                                        return status4;
                                    }
                                    if (logger.isTraceEnabled()) {
                                        logger.trace("Both jwt and sjwt are true and no scope in the token. It is a sjwt token.");
                                    }
                                    if ((handler3 = (AbstractSimpleJwtVerifyHandler)handlers.get(SJWT)) == null) {
                                        logger.error("Cannot find SimpleJwtVerifyHandler with alias name sjwt.");
                                        return new Status(HANDLER_NOT_FOUND, "com.networknt.openapi.SimpleJwtVerifyHandler@sjwt");
                                    }
                                    if (!handler3.isEnabled() || (status3 = handler3.handleJwt(exchange, pathPrefixAuth.getPrefix(), reqPath, pathPrefixAuth.getSjwkServiceIds())) == null) break;
                                    return status3;
                                }
                                if (logger.isTraceEnabled()) {
                                    logger.trace("jwt is not true and sjwt is true. This is a sjwt token.");
                                }
                                if ((handler2 = (AbstractSimpleJwtVerifyHandler)handlers.get(SJWT)) == null) {
                                    logger.error("Cannot find SimpleJwtVerifyHandler with alias name sjwt.");
                                    return new Status(HANDLER_NOT_FOUND, "com.networknt.openapi.SimpleJwtVerifyHandler@sjwt");
                                }
                                if (!handler2.isEnabled() || (status2 = handler2.handleJwt(exchange, pathPrefixAuth.getPrefix(), reqPath, pathPrefixAuth.getSjwkServiceIds())) == null) break;
                                return status2;
                            }
                            if (logger.isTraceEnabled()) {
                                logger.trace("SJWT is not enabled and this is a jwt token.");
                            }
                            if ((handler = (AbstractJwtVerifyHandler)handlers.get(JWT)) == null) {
                                logger.error("Cannot find JwtVerifyHandler with alias name jwt.");
                                return new Status(HANDLER_NOT_FOUND, "com.networknt.openapi.JwtVerifyHandler@jwt");
                            }
                            if (!handler.isEnabled() || (status = handler.handleJwt(exchange, pathPrefixAuth.getPrefix(), reqPath, pathPrefixAuth.getJwkServiceIds())) == null) break;
                            return status;
                        }
                        if (pathPrefixAuth.isSwt()) {
                            Status status;
                            AbstractSwtVerifyHandler handler;
                            if (logger.isTraceEnabled()) {
                                logger.trace("Bearer token is swt.");
                            }
                            if ((handler = (AbstractSwtVerifyHandler)handlers.get(SWT)) == null) {
                                logger.error("Cannot find SwtVerifyHandler with alias name swt.");
                                return new Status(HANDLER_NOT_FOUND, "com.networknt.openapi.SwtVerifyHandler@swt");
                            }
                            if (!handler.isEnabled() || (status = handler.handleSwt(exchange, reqPath, pathPrefixAuth.getSwtServiceIds())) == null) break;
                            return status;
                        }
                        logger.error("Invalid/Unsupported authorization header {}", (Object)authorization);
                        return new Status(INVALID_AUTHORIZATION_HEADER, authorization);
                    }
                    String s2 = authorization.length() > 10 ? authorization.substring(0, 10) : authorization;
                    logger.error("Invalid/Unsupported authorization header {}", (Object)s2);
                    return new Status(INVALID_AUTHORIZATION_HEADER, s2);
                }
                if (!pathPrefixAuth.isApikey()) continue;
                Map<String, HttpHandler> handlers = Handler.getHandlers();
                ApiKeyHandler handler = (ApiKeyHandler)handlers.get(API_KEY);
                if (handler == null) {
                    logger.error("Cannot find ApiKeyHandler with alias name apikey.");
                    return new Status(HANDLER_NOT_FOUND, "com.networknt.apikey.ApiKeyHandler@apikey");
                }
                if (!handler.isEnabled() || handler.handleApiKey(exchange, reqPath)) break;
                return null;
            }
            if (!found) {
                logger.error("Cannot find prefix entry in pathPrefixAuths for " + reqPath);
                return new Status(MISSING_PATH_PREFIX_AUTH, reqPath);
            }
        } else {
            logger.error("Cannot find pathPrefixAuths definition for " + reqPath);
            return new Status(MISSING_PATH_PREFIX_AUTH, reqPath);
        }
        return null;
    }

    @Override
    public HttpHandler getNext() {
        return this.next;
    }

    @Override
    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    @Override
    public boolean isEnabled() {
        return config.isEnabled();
    }

    @Override
    public void register() {
        ModuleRegistry.registerModule("unified-security", UnifiedSecurityHandler.class.getName(), Config.getNoneDecryptedInstance().getJsonMapConfigNoCache("unified-security"), null);
    }

    @Override
    public void reload() {
        config.reload();
        ModuleRegistry.registerModule("unified-security", UnifiedSecurityHandler.class.getName(), Config.getNoneDecryptedInstance().getJsonMapConfigNoCache("unified-security"), null);
    }
}

