/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.security;

import com.fasterxml.jackson.core.type.TypeReference;
import com.networknt.config.Config;
import com.networknt.config.ConfigException;
import com.networknt.config.schema.ArrayField;
import com.networknt.config.schema.BooleanField;
import com.networknt.config.schema.ConfigSchema;
import com.networknt.config.schema.OutputFormat;
import com.networknt.security.UnifiedPathPrefixAuth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfigSchema(configKey="unified-security", configName="unified-security", outputFormats={OutputFormat.JSON_SCHEMA, OutputFormat.YAML})
public class UnifiedSecurityConfig {
    private static final Logger logger = LoggerFactory.getLogger(UnifiedSecurityConfig.class);
    public static final String CONFIG_NAME = "unified-security";
    public static final String ENABLED = "enabled";
    public static final String ANONYMOUS_PREFIXES = "anonymousPrefixes";
    public static final String PATH_PREFIX_AUTHS = "pathPrefixAuths";
    public static final String PREFIX = "prefix";
    public static final String BASIC = "basic";
    public static final String JWT = "jwt";
    public static final String SJWT = "sjwt";
    public static final String SWT = "swt";
    public static final String APIKEY = "apikey";
    public static final String JWK_SERVICE_IDS = "jwkServiceIds";
    public static final String SJWK_SERVICE_IDS = "sjwkServiceIds";
    public static final String SWT_SERVICE_IDS = "swtServiceIds";
    @BooleanField(configFieldName="enabled", externalizedKeyName="enabled", defaultValue=true, externalized=true, description="indicate if this handler is enabled. By default, it will be enabled if it is injected into the\nrequest/response chain in the handler.yml configuration.")
    boolean enabled;
    @ArrayField(configFieldName="anonymousPrefixes", externalizedKeyName="anonymousPrefixes", items=String.class, externalized=true, description="Anonymous prefixes configuration. A list of request path prefixes. The anonymous prefixes will be checked\nfirst, and if any path is matched, all other security checks will be bypassed, and the request goes to\nthe next handler in the chain. You can use json array or string separated by comma or YAML format.")
    List<String> anonymousPrefixes;
    @ArrayField(configFieldName="pathPrefixAuths", externalizedKeyName="pathPrefixAuths", items=UnifiedPathPrefixAuth.class, externalized=true, description="path prefix security configuration.")
    List<UnifiedPathPrefixAuth> pathPrefixAuths;
    private final Config config = Config.getInstance();
    private Map<String, Object> mappedConfig;

    private UnifiedSecurityConfig() {
        this(CONFIG_NAME);
    }

    private UnifiedSecurityConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigData();
        this.setConfigList();
    }

    public static UnifiedSecurityConfig load() {
        return new UnifiedSecurityConfig();
    }

    public static UnifiedSecurityConfig load(String configName) {
        return new UnifiedSecurityConfig(configName);
    }

    public void reload() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(CONFIG_NAME);
        this.setConfigData();
        this.setConfigList();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public List<String> getAnonymousPrefixes() {
        return this.anonymousPrefixes;
    }

    public void setAnonymousPrefixes(List<String> anonymousPrefixes) {
        this.anonymousPrefixes = anonymousPrefixes;
    }

    public List<UnifiedPathPrefixAuth> getPathPrefixAuths() {
        return this.pathPrefixAuths;
    }

    public void setPathPrefixAuths(List<UnifiedPathPrefixAuth> pathPrefixAuths) {
        this.pathPrefixAuths = pathPrefixAuths;
    }

    private void setConfigData() {
        Object object = this.mappedConfig.get(ENABLED);
        if (object != null) {
            if (object instanceof String) {
                this.enabled = Boolean.parseBoolean((String)object);
            } else if (object instanceof Boolean) {
                this.enabled = (Boolean)object;
            } else {
                throw new ConfigException("enabled must be a boolean value.");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setConfigList() {
        String s2;
        Object object;
        if (this.mappedConfig != null && this.mappedConfig.get(ANONYMOUS_PREFIXES) != null) {
            object = this.mappedConfig.get(ANONYMOUS_PREFIXES);
            this.anonymousPrefixes = new ArrayList<String>();
            if (object instanceof String) {
                s2 = (String)object;
                s2 = s2.trim();
                if (logger.isTraceEnabled()) {
                    logger.trace("s = " + s2);
                }
                if (s2.startsWith("[")) {
                    try {
                        this.anonymousPrefixes = Config.getInstance().getMapper().readValue(s2, new TypeReference<List<String>>(){});
                    }
                    catch (Exception e) {
                        logger.error("could not parse the anonymousPrefixes json with a list of strings.", e);
                        throw new ConfigException("could not parse the anonymousPrefixes json with a list of strings.");
                    }
                } else {
                    this.anonymousPrefixes = Arrays.asList(s2.split("\\s*,\\s*"));
                }
            } else {
                if (!(object instanceof List)) throw new ConfigException("anonymousPrefixes must be a string or a list of strings.");
                List prefixes = (List)object;
                prefixes.forEach(item -> this.anonymousPrefixes.add((String)item));
            }
        }
        if (this.mappedConfig.get(PATH_PREFIX_AUTHS) == null) return;
        object = this.mappedConfig.get(PATH_PREFIX_AUTHS);
        this.pathPrefixAuths = new ArrayList<UnifiedPathPrefixAuth>();
        if (object instanceof String) {
            s2 = (String)object;
            s2 = s2.trim();
            if (logger.isTraceEnabled()) {
                logger.trace("pathPrefixAuth s = " + s2);
            }
            if (!s2.startsWith("[")) throw new ConfigException("pathPrefixAuths must be a list of string object map.");
            try {
                List<Map<String, Object>> values2 = Config.getInstance().getMapper().readValue(s2, new TypeReference<List<Map<String, Object>>>(){});
                this.pathPrefixAuths = UnifiedSecurityConfig.populatePathPrefixAuths(values2);
                return;
            }
            catch (Exception e) {
                logger.error("could not parse the pathPrefixAuths json with a list of string and object.", e);
                throw new ConfigException("could not parse the pathPrefixAuths json with a list of string and object.");
            }
        } else {
            if (!(object instanceof List)) throw new ConfigException("pathPrefixAuth must be a list of string object map.");
            this.pathPrefixAuths = UnifiedSecurityConfig.populatePathPrefixAuths((List)object);
        }
    }

    public static List<UnifiedPathPrefixAuth> populatePathPrefixAuths(List<Map<String, Object>> values2) {
        ArrayList<UnifiedPathPrefixAuth> pathPrefixAuths = new ArrayList<UnifiedPathPrefixAuth>();
        for (Map<String, Object> value : values2) {
            UnifiedPathPrefixAuth unifiedPathPrefixAuth = new UnifiedPathPrefixAuth();
            unifiedPathPrefixAuth.setPrefix((String)value.get(PREFIX));
            unifiedPathPrefixAuth.setBasic(value.get(BASIC) == null ? false : (Boolean)value.get(BASIC));
            unifiedPathPrefixAuth.setJwt(value.get(JWT) == null ? false : (Boolean)value.get(JWT));
            unifiedPathPrefixAuth.setSjwt(value.get(SJWT) == null ? false : (Boolean)value.get(SJWT));
            unifiedPathPrefixAuth.setSwt(value.get(SWT) == null ? false : (Boolean)value.get(SWT));
            unifiedPathPrefixAuth.setApikey(value.get(APIKEY) == null ? false : (Boolean)value.get(APIKEY));
            Object jwkIds = value.get(JWK_SERVICE_IDS);
            if (jwkIds instanceof String) {
                String s2 = (String)value.get(JWK_SERVICE_IDS);
                if (s2.startsWith("[")) {
                    try {
                        unifiedPathPrefixAuth.setJwkServiceIds(Config.getInstance().getMapper().readValue(s2, new TypeReference<List<String>>(){}));
                    }
                    catch (Exception e) {
                        logger.error("could not parse the jwkServiceIds json with a list of strings.", e);
                        throw new ConfigException("could not parse the jwkServiceIds json with a list of strings.");
                    }
                } else {
                    unifiedPathPrefixAuth.setJwkServiceIds(Arrays.asList(s2.split("\\s*,\\s*")));
                }
            } else if (jwkIds instanceof List) {
                unifiedPathPrefixAuth.setJwkServiceIds((List)jwkIds);
            }
            Object sjwkIds = value.get(SJWK_SERVICE_IDS);
            if (sjwkIds instanceof String) {
                String s3 = (String)value.get(SJWK_SERVICE_IDS);
                if (s3.startsWith("[")) {
                    try {
                        unifiedPathPrefixAuth.setSjwkServiceIds(Config.getInstance().getMapper().readValue(s3, new TypeReference<List<String>>(){}));
                    }
                    catch (Exception e) {
                        logger.error("could not parse the sjwkServiceIds json with a list of strings.", e);
                        throw new ConfigException("could not parse the sjwkServiceIds json with a list of strings.");
                    }
                } else {
                    unifiedPathPrefixAuth.setSjwkServiceIds(Arrays.asList(s3.split("\\s*,\\s*")));
                }
            } else if (jwkIds instanceof List) {
                unifiedPathPrefixAuth.setSjwkServiceIds((List)sjwkIds);
            }
            Object swtIds = value.get(SWT_SERVICE_IDS);
            if (swtIds instanceof String) {
                String s4 = (String)value.get(SWT_SERVICE_IDS);
                if (s4.startsWith("[")) {
                    try {
                        unifiedPathPrefixAuth.setSwtServiceIds(Config.getInstance().getMapper().readValue(s4, new TypeReference<List<String>>(){}));
                    }
                    catch (Exception e) {
                        logger.error("could not parse the swtServiceIds json with a list of strings.", e);
                        throw new ConfigException("could not parse the swtServiceIds json with a list of strings.");
                    }
                } else {
                    unifiedPathPrefixAuth.setSwtServiceIds(Arrays.asList(s4.split("\\s*,\\s*")));
                }
            } else if (swtIds instanceof List) {
                unifiedPathPrefixAuth.setSwtServiceIds((List)swtIds);
            }
            pathPrefixAuths.add(unifiedPathPrefixAuth);
        }
        return pathPrefixAuths;
    }
}

