/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.security;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyUtil {
    public static final Logger logger = LoggerFactory.getLogger(KeyUtil.class);
    public static final String RSA = "RSA";

    public static KeyPair generateKeyPair(String algorithm, int keySize) throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(algorithm);
        keyPairGenerator.initialize(keySize);
        return keyPairGenerator.generateKeyPair();
    }

    public static String serializePublicKey(PublicKey publicKey) throws Exception {
        byte[] publicKeyBytes = publicKey.getEncoded();
        return Base64.getEncoder().encodeToString(publicKeyBytes);
    }

    public static String serializePrivateKey(PrivateKey privateKey) throws Exception {
        byte[] privateKeyBytes = privateKey.getEncoded();
        return Base64.getEncoder().encodeToString(privateKeyBytes);
    }

    public static PrivateKey deserializePrivateKey(String serializedPrivateKey, String algorithm) throws Exception {
        byte[] decodedPrivateKeyBytes = Base64.getDecoder().decode(serializedPrivateKey);
        PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(decodedPrivateKeyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        return keyFactory.generatePrivate(privateKeySpec);
    }

    public static PublicKey deserializePublicKey(String serializedPublicKey, String algorithm) throws Exception {
        byte[] decodedPublicKeyBytes = Base64.getDecoder().decode(serializedPublicKey);
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(decodedPublicKeyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        return keyFactory.generatePublic(publicKeySpec);
    }

    public static String generateJwk(PublicKey longKey, String longKeyId, PublicKey currKey, String currKeyId, PublicKey prevKey, String prevKeyId) {
        ArrayList<PublicJsonWebKey> jwkList = new ArrayList<PublicJsonWebKey>();
        try {
            PublicJsonWebKey jwk = PublicJsonWebKey.Factory.newPublicJwk(longKey);
            jwk.setKeyId(longKeyId);
            jwkList.add(jwk);
            jwk = PublicJsonWebKey.Factory.newPublicJwk(currKey);
            jwk.setKeyId(currKeyId);
            jwkList.add(jwk);
            if (prevKey != null && prevKeyId != null) {
                jwk = PublicJsonWebKey.Factory.newPublicJwk(prevKey);
                jwk.setKeyId(prevKeyId);
                jwkList.add(jwk);
            }
        }
        catch (JoseException e) {
            logger.error("Exception:", e);
        }
        JsonWebKeySet jwks = new JsonWebKeySet(jwkList);
        return jwks.toJson(JsonWebKey.OutputControlLevel.PUBLIC_ONLY);
    }
}

