/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.security;

import com.networknt.config.Config;
import com.networknt.config.schema.ConfigSchema;
import com.networknt.config.schema.IntegerField;
import com.networknt.config.schema.ObjectField;
import com.networknt.config.schema.OutputFormat;
import com.networknt.config.schema.StringField;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfigSchema(configKey="jwt", configName="jwt", outputFormats={OutputFormat.JSON_SCHEMA, OutputFormat.YAML})
public class JwtConfig {
    private static final Logger logger = LoggerFactory.getLogger(JwtConfig.class);
    public static final String CONFIG_NAME = "jwt";
    public static final String KEY = "key";
    public static final String ISSUER = "issuer";
    public static final String AUDIENCE = "audience";
    public static final String VERSION = "version";
    public static final String EXPIRED_IN_MINUTES = "expiredInMinutes";
    public static final String PROVIDER_ID = "providerId";
    private Map<String, Object> mappedConfig;
    private final Config config = Config.getInstance();
    @ObjectField(configFieldName="expiredInMinutes", defaultValue="{\"kid\":\"100\",\"filename\":\"primary.jks\",\"keyName\":\"selfsigned\",\"password\":\"password\"}", description="This is the default JWT configuration and some of the properties need to be overwritten when used to issue JWT tokens.\nIt is a component that used to issue JWT token. Normally, it should be used by light-oauth2 or oauth-kafka only.\nSignature private key that used to sign JWT tokens. It is here to ensure backward compatibility only.", ref=Key.class)
    Key key;
    @StringField(configFieldName="issuer", externalizedKeyName="issuer", defaultValue="urn:com:networknt:oauth2:v1", externalized=true, description="issuer of the JWT token")
    String issuer;
    @StringField(configFieldName="audience", externalizedKeyName="audience", defaultValue="urn:com.networknt", externalized=true, description="audience of the JWT token")
    String audience;
    @IntegerField(configFieldName="expiredInMinutes", externalizedKeyName="expiredInMinutes", defaultValue=10, externalized=true, description="expired in 10 minutes by default for issued JWT tokens")
    int expiredInMinutes;
    @StringField(configFieldName="version", externalizedKeyName="version", externalized=true, defaultValue="1.0", description="JWT token version")
    String version;
    @StringField(configFieldName="providerId", externalizedKeyName="providerId", externalized=true, description="If federated OAuth 2.0 providers are used, you need to set providerId for each OAuth instance. In most cases, this\nvalue should be null so that the OAuth 2.0 provider is run as one instance")
    String providerId;

    private JwtConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigData();
        this.setConfigMap();
    }

    public static JwtConfig load() {
        return new JwtConfig(CONFIG_NAME);
    }

    public static JwtConfig load(String configName) {
        return new JwtConfig(configName);
    }

    public void reload(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigData();
    }

    public Map<String, Object> getMappedConfig() {
        return this.mappedConfig;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getAudience() {
        return this.audience;
    }

    public void setAudience(String audience) {
        this.audience = audience;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public int getExpiredInMinutes() {
        return this.expiredInMinutes;
    }

    public void setExpiredInMinutes(int expiredInMinutes) {
        this.expiredInMinutes = expiredInMinutes;
    }

    public Key getKey() {
        return this.key;
    }

    public void setKey(Key key) {
        this.key = key;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    private void setConfigData() {
        if (this.getMappedConfig() != null) {
            Object object = this.getMappedConfig().get(ISSUER);
            if (object != null) {
                this.issuer = (String)object;
            }
            if ((object = this.getMappedConfig().get(AUDIENCE)) != null) {
                this.audience = (String)object;
            }
            if ((object = this.getMappedConfig().get(VERSION)) != null) {
                this.version = object instanceof Number ? object.toString() : (String)object;
            }
            if ((object = this.getMappedConfig().get(EXPIRED_IN_MINUTES)) != null) {
                this.expiredInMinutes = Config.loadIntegerValue(EXPIRED_IN_MINUTES, object);
            }
            if ((object = this.getMappedConfig().get(PROVIDER_ID)) != null) {
                this.providerId = (String)object;
            }
        }
    }

    private void setConfigMap() {
        Object object;
        if (this.getMappedConfig() != null && (object = this.getMappedConfig().get(KEY)) != null) {
            if (object instanceof Map) {
                this.key = Config.getInstance().getMapper().convertValue(object, Key.class);
            } else if (object instanceof String) {
                try {
                    this.key = Config.getInstance().getMapper().readValue((String)object, Key.class);
                }
                catch (Exception e) {
                    logger.error("Exception:", e);
                }
            } else {
                logger.error("key in jwt.yml is not a map or string");
            }
        }
    }

    public static class Key {
        @StringField(configFieldName="kid")
        String kid;
        @StringField(configFieldName="filename")
        String filename;
        @StringField(configFieldName="password")
        String password;
        @StringField(configFieldName="keyName")
        String keyName;

        public String getKid() {
            return this.kid;
        }

        public void setKid(String kid) {
            this.kid = kid;
        }

        public String getFilename() {
            return this.filename;
        }

        public void setFilename(String filename) {
            this.filename = filename;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getKeyName() {
            return this.keyName;
        }

        public void setKeyName(String keyName) {
            this.keyName = keyName;
        }
    }
}

