/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.security;

import com.networknt.exception.ExpiredTokenException;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.httpstring.HttpStringConstants;
import com.networknt.security.IJwtVerifyHandler;
import com.networknt.security.JwtVerifier;
import com.networknt.security.SecurityConfig;
import com.networknt.security.UndertowVerifyHandler;
import com.networknt.security.VerificationException;
import com.networknt.status.Status;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSimpleJwtVerifyHandler
extends UndertowVerifyHandler
implements MiddlewareHandler,
IJwtVerifyHandler {
    static final Logger logger = LoggerFactory.getLogger(AbstractSimpleJwtVerifyHandler.class);
    static final String STATUS_INVALID_AUTH_TOKEN = "ERR10000";
    static final String STATUS_AUTH_TOKEN_EXPIRED = "ERR10001";
    static final String TOKEN_VERIFICATION_EXCEPTION = "ERR10090";
    static final String STATUS_MISSING_AUTH_TOKEN = "ERR10002";
    static final String STATUS_METHOD_NOT_ALLOWED = "ERR10008";
    public static SecurityConfig config;
    public static JwtVerifier jwtVerifier;
    public volatile HttpHandler next;

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        Status status;
        if (logger.isDebugEnabled()) {
            logger.debug("SimpleJwtVerifyHandler.handleRequest starts.");
        }
        String reqPath = exchange.getRequestPath();
        if (config.getSkipPathPrefixes() != null) {
            if (config.getSkipPathPrefixes().stream().anyMatch(reqPath::startsWith)) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Skip request path base on skipPathPrefixes for {}", (Object)reqPath);
                }
                Handler.next(exchange, this.next);
                if (logger.isDebugEnabled()) {
                    logger.debug("SimpleJwtVerifyHandler.handleRequest ends.");
                }
                return;
            }
        }
        if ((status = this.handleJwt(exchange, null, reqPath, null)) != null) {
            this.setExchangeStatus(exchange, status);
            exchange.endExchange();
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("SimpleJwtVerifyHandler.handleRequest ends.");
            }
            Handler.next(exchange, this.next);
        }
    }

    public Status handleJwt(HttpServerExchange exchange, String pathPrefix, String reqPath, List<String> jwkServiceIds) throws Exception {
        HashMap<String, Object> auditInfo = null;
        HeaderMap headerMap = exchange.getRequestHeaders();
        String authorization = headerMap.getFirst(Headers.AUTHORIZATION);
        if (logger.isTraceEnabled() && authorization != null && authorization.length() > 10) {
            logger.trace("Authorization header = {}", (Object)authorization.substring(0, 10));
        }
        if (authorization == null) {
            Status status = new Status(STATUS_MISSING_AUTH_TOKEN, new Object[0]);
            if (logger.isTraceEnabled()) {
                logger.trace("SimpleJwtVerifyHandler.handleRequest ends with an error {}", (Object)status);
            }
            return status;
        }
        if (authorization.trim().length() < 6) {
            Status status = new Status(STATUS_INVALID_AUTH_TOKEN, new Object[0]);
            if (logger.isTraceEnabled()) {
                logger.trace("SimpleJwtVerifyHandler.handleRequest ends with an error {}", (Object)status);
            }
            return status;
        }
        authorization = this.getScopeToken(authorization, headerMap);
        boolean ignoreExpiry = config.isIgnoreJwtExpiry();
        String jwt = JwtVerifier.getTokenFromAuthorization(authorization);
        if (jwt != null) {
            if (logger.isTraceEnabled()) {
                logger.trace("parsed jwt from authorization = {}", (Object)jwt.substring(0, 10));
            }
            try {
                JwtClaims claims = jwtVerifier.verifyJwt(jwt, ignoreExpiry, true, pathPrefix, reqPath, jwkServiceIds);
                if (logger.isTraceEnabled()) {
                    logger.trace("claims = {}", (Object)claims.toJson());
                }
                if ((auditInfo = exchange.getAttachment(AttachmentConstants.AUDIT_INFO)) == null) {
                    auditInfo = new HashMap<String, Object>();
                    exchange.putAttachment(AttachmentConstants.AUDIT_INFO, auditInfo);
                }
                String clientId = claims.getStringClaimValue("client_id");
                String userId = claims.getStringClaimValue("user_id");
                String issuer = claims.getStringClaimValue("iss");
                if (clientId == null) {
                    clientId = claims.getStringClaimValue("cid");
                }
                if (userId == null) {
                    userId = claims.getStringClaimValue("uid");
                }
                auditInfo.put("user_id", userId);
                auditInfo.put("subject_claims", claims);
                auditInfo.put("client_id", clientId);
                auditInfo.put("issuer_claims", issuer);
                if (!config.isEnableH2c() && this.checkForH2CRequest(headerMap)) {
                    Status status = new Status(STATUS_METHOD_NOT_ALLOWED, new Object[0]);
                    if (logger.isTraceEnabled()) {
                        logger.trace("SimpleJwtVerifyHandler.handleRequest ends with an error {}", (Object)status);
                    }
                    return status;
                }
                String callerId = headerMap.getFirst(HttpStringConstants.CALLER_ID);
                if (callerId != null) {
                    auditInfo.put("caller_id", callerId);
                }
                if (config.getPassThroughClaims() != null && config.getPassThroughClaims().size() > 0) {
                    for (Map.Entry<String, String> entry : config.getPassThroughClaims().entrySet()) {
                        String key = entry.getKey();
                        String header = entry.getValue();
                        Object value = claims.getClaimValue(key);
                        if (logger.isTraceEnabled()) {
                            logger.trace("pass through header {} with value {}", (Object)header, value);
                        }
                        headerMap.put(new HttpString(header), value.toString());
                    }
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("complete SJWT verification for request path = {}", (Object)exchange.getRequestURI());
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("SimpleJwtVerifyHandler.handleRequest ends.");
                }
                return null;
            }
            catch (InvalidJwtException e) {
                logger.error("InvalidJwtException: ", e);
                Status status = new Status(STATUS_INVALID_AUTH_TOKEN, new Object[0]);
                if (logger.isTraceEnabled()) {
                    logger.trace("SimpleJwtVerifyHandler.handleRequest ends with an error {}", (Object)status);
                }
                return status;
            }
            catch (ExpiredTokenException e) {
                logger.error("ExpiredTokenException", e);
                Status status = new Status(STATUS_AUTH_TOKEN_EXPIRED, new Object[0]);
                if (logger.isTraceEnabled()) {
                    logger.trace("SimpleJwtVerifyHandler.handleRequest ends with an error {}", (Object)status);
                }
                return status;
            }
            catch (VerificationException e) {
                logger.error("VerificationException", e);
                Status status = new Status(TOKEN_VERIFICATION_EXCEPTION, e.getMessage());
                if (logger.isTraceEnabled()) {
                    logger.trace("SimpleJwtVerifyHandler.handleRequest ends with an error {}", (Object)status);
                }
                return status;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("SimpleJwtVerifyHandler.handleRequest ends with an error.");
        }
        return new Status(STATUS_MISSING_AUTH_TOKEN, new Object[0]);
    }

    protected String getScopeToken(String authorization, HeaderMap headerMap) {
        String returnToken = authorization;
        if (returnToken != null && !returnToken.substring(0, 6).equalsIgnoreCase("Bearer")) {
            returnToken = headerMap.getFirst(HttpStringConstants.SCOPE_TOKEN);
            if (logger.isTraceEnabled() && returnToken != null && returnToken.length() > 10) {
                logger.trace("The replaced authorization from X-Scope-Token header = {}", (Object)returnToken.substring(0, 10));
            }
        }
        return returnToken;
    }

    @Override
    public HttpHandler getNext() {
        return this.next;
    }

    @Override
    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    @Override
    public boolean isEnabled() {
        return config.isEnableVerifyJwt();
    }

    @Override
    public JwtVerifier getJwtVerifier() {
        return jwtVerifier;
    }
}

