/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.resource;

import com.networknt.schema.AbsoluteIri;
import com.networknt.schema.resource.InputStreamSource;
import com.networknt.schema.resource.SchemaLoader;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.function.Supplier;

public class ClasspathSchemaLoader
implements SchemaLoader {
    private final Supplier<ClassLoader> classLoaderSource;

    public ClasspathSchemaLoader() {
        this(ClasspathSchemaLoader::getClassLoader);
    }

    public ClasspathSchemaLoader(Supplier<ClassLoader> classLoaderSource) {
        this.classLoaderSource = classLoaderSource;
    }

    @Override
    public InputStreamSource getSchema(AbsoluteIri absoluteIri) {
        String iri = absoluteIri != null ? absoluteIri.toString() : "";
        String name2 = null;
        if (iri.startsWith("classpath:")) {
            name2 = iri.substring(10);
        } else if (iri.startsWith("resource:")) {
            name2 = iri.substring(9);
        }
        if (name2 != null) {
            ClassLoader classLoader2 = this.classLoaderSource.get();
            if (name2.startsWith("//")) {
                name2 = name2.substring(2);
            }
            String resource = name2;
            return () -> {
                InputStream result2 = classLoader2.getResourceAsStream(resource);
                if (result2 == null) {
                    result2 = classLoader2.getResourceAsStream(resource.substring(1));
                }
                if (result2 == null) {
                    throw new FileNotFoundException(iri);
                }
                return result2;
            };
        }
        return null;
    }

    protected static ClassLoader getClassLoader() {
        ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
        if (classLoader2 == null) {
            classLoader2 = SchemaLoader.class.getClassLoader();
        }
        return classLoader2;
    }
}

