/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.scheduler;

import com.networknt.scheduler.DefinitionAction;
import com.networknt.scheduler.TaskFrequency;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class TaskDefinition
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 410678981943919853L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"TaskDefinition\",\"namespace\":\"com.networknt.scheduler\",\"fields\":[{\"name\":\"host\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},{\"name\":\"name\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},{\"name\":\"action\",\"type\":{\"type\":\"enum\",\"name\":\"DefinitionAction\",\"symbols\":[\"INSERT\",\"UPDATE\",\"DELETE\"]}},{\"name\":\"frequency\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"TaskFrequency\",\"fields\":[{\"name\":\"timeUnit\",\"type\":{\"type\":\"enum\",\"name\":\"TimeUnit\",\"symbols\":[\"MILLISECONDS\",\"SECONDS\",\"MINUTES\",\"HOURS\",\"DAYS\"]}},{\"name\":\"time\",\"type\":\"int\"}]}],\"default\":null},{\"name\":\"topic\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},{\"name\":\"start\",\"type\":\"long\"},{\"name\":\"data\",\"type\":[\"null\",{\"type\":\"map\",\"values\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"avro.java.string\":\"String\"}],\"default\":null}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<TaskDefinition> ENCODER = new BinaryMessageEncoder(MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<TaskDefinition> DECODER = new BinaryMessageDecoder(MODEL$, SCHEMA$);
    private String host;
    private String name;
    private DefinitionAction action;
    private TaskFrequency frequency;
    private String topic;
    private long start;
    private Map<String, String> data;
    private static final DatumWriter<TaskDefinition> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<TaskDefinition> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<TaskDefinition> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<TaskDefinition> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<TaskDefinition> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder<TaskDefinition>(MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode(this);
    }

    public static TaskDefinition fromByteBuffer(ByteBuffer b) throws IOException {
        return (TaskDefinition)DECODER.decode(b);
    }

    public TaskDefinition() {
    }

    public TaskDefinition(String host, String name2, DefinitionAction action, TaskFrequency frequency, String topic, Long start, Map<String, String> data) {
        this.host = host;
        this.name = name2;
        this.action = action;
        this.frequency = frequency;
        this.topic = topic;
        this.start = start;
        this.data = data;
    }

    @Override
    public SpecificData getSpecificData() {
        return MODEL$;
    }

    @Override
    public Schema getSchema() {
        return SCHEMA$;
    }

    @Override
    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.host;
            }
            case 1: {
                return this.name;
            }
            case 2: {
                return this.action;
            }
            case 3: {
                return this.frequency;
            }
            case 4: {
                return this.topic;
            }
            case 5: {
                return this.start;
            }
            case 6: {
                return this.data;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    @Override
    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.host = value$ != null ? value$.toString() : null;
                break;
            }
            case 1: {
                this.name = value$ != null ? value$.toString() : null;
                break;
            }
            case 2: {
                this.action = (DefinitionAction)value$;
                break;
            }
            case 3: {
                this.frequency = (TaskFrequency)value$;
                break;
            }
            case 4: {
                this.topic = value$ != null ? value$.toString() : null;
                break;
            }
            case 5: {
                this.start = (Long)value$;
                break;
            }
            case 6: {
                this.data = (Map)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String value) {
        this.host = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public DefinitionAction getAction() {
        return this.action;
    }

    public void setAction(DefinitionAction value) {
        this.action = value;
    }

    public TaskFrequency getFrequency() {
        return this.frequency;
    }

    public void setFrequency(TaskFrequency value) {
        this.frequency = value;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String value) {
        this.topic = value;
    }

    public long getStart() {
        return this.start;
    }

    public void setStart(long value) {
        this.start = value;
    }

    public Map<String, String> getData() {
        return this.data;
    }

    public void setData(Map<String, String> value) {
        this.data = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(TaskDefinition other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write(this, SpecificData.getEncoder(out));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        READER$.read(this, SpecificData.getDecoder(in));
    }

    @Override
    protected boolean hasCustomCoders() {
        return true;
    }

    @Override
    public void customEncode(Encoder out) throws IOException {
        out.writeString(this.host);
        out.writeString(this.name);
        out.writeEnum(this.action.ordinal());
        if (this.frequency == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            this.frequency.customEncode(out);
        }
        out.writeString(this.topic);
        out.writeLong(this.start);
        if (this.data == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            long size0 = this.data.size();
            out.writeMapStart();
            out.setItemCount(size0);
            long actualSize0 = 0L;
            for (Map.Entry<String, String> e0 : this.data.entrySet()) {
                ++actualSize0;
                out.startItem();
                out.writeString(e0.getKey());
                String v0 = e0.getValue();
                out.writeString(v0);
            }
            out.writeMapEnd();
            if (actualSize0 != size0) {
                throw new ConcurrentModificationException("Map-size written was " + size0 + ", but element count was " + actualSize0 + ".");
            }
        }
    }

    @Override
    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.host = in.readString();
            this.name = in.readString();
            this.action = DefinitionAction.values()[in.readEnum()];
            if (in.readIndex() != 1) {
                in.readNull();
                this.frequency = null;
            } else {
                if (this.frequency == null) {
                    this.frequency = new TaskFrequency();
                }
                this.frequency.customDecode(in);
            }
            this.topic = in.readString();
            this.start = in.readLong();
            if (in.readIndex() != 1) {
                in.readNull();
                this.data = null;
            } else {
                long size0 = in.readMapStart();
                Map<String, String> m0 = this.data;
                if (m0 == null) {
                    this.data = m0 = new HashMap<String, String>((int)(size0 * 4L) / 3 + 1);
                } else {
                    m0.clear();
                }
                while (0L < size0) {
                    while (size0 != 0L) {
                        String k0 = null;
                        k0 = in.readString();
                        String v0 = null;
                        v0 = in.readString();
                        m0.put(k0, v0);
                        --size0;
                    }
                    size0 = in.mapNext();
                }
            }
        } else {
            block11: for (int i = 0; i < 7; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.host = in.readString();
                        continue block11;
                    }
                    case 1: {
                        this.name = in.readString();
                        continue block11;
                    }
                    case 2: {
                        this.action = DefinitionAction.values()[in.readEnum()];
                        continue block11;
                    }
                    case 3: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.frequency = null;
                            continue block11;
                        }
                        if (this.frequency == null) {
                            this.frequency = new TaskFrequency();
                        }
                        this.frequency.customDecode(in);
                        continue block11;
                    }
                    case 4: {
                        this.topic = in.readString();
                        continue block11;
                    }
                    case 5: {
                        this.start = in.readLong();
                        continue block11;
                    }
                    case 6: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.data = null;
                            continue block11;
                        }
                        long size0 = in.readMapStart();
                        Map<String, String> m0 = this.data;
                        if (m0 == null) {
                            this.data = m0 = new HashMap<String, String>((int)(size0 * 4L) / 3 + 1);
                        } else {
                            m0.clear();
                        }
                        while (0L < size0) {
                            while (size0 != 0L) {
                                String k0 = null;
                                k0 = in.readString();
                                String v0 = null;
                                v0 = in.readString();
                                m0.put(k0, v0);
                                --size0;
                            }
                            size0 = in.mapNext();
                        }
                        continue block11;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<TaskDefinition>
    implements RecordBuilder<TaskDefinition> {
        private String host;
        private String name;
        private DefinitionAction action;
        private TaskFrequency frequency;
        private TaskFrequency.Builder frequencyBuilder;
        private String topic;
        private long start;
        private Map<String, String> data;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super(other);
            if (Builder.isValidValue(this.fields()[0], other.host)) {
                this.host = this.data().deepCopy(this.fields()[0].schema(), other.host);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue(this.fields()[1], other.name)) {
                this.name = this.data().deepCopy(this.fields()[1].schema(), other.name);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue(this.fields()[2], other.action)) {
                this.action = this.data().deepCopy(this.fields()[2].schema(), other.action);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue(this.fields()[3], other.frequency)) {
                this.frequency = this.data().deepCopy(this.fields()[3].schema(), other.frequency);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (other.hasFrequencyBuilder()) {
                this.frequencyBuilder = TaskFrequency.newBuilder(other.getFrequencyBuilder());
            }
            if (Builder.isValidValue(this.fields()[4], other.topic)) {
                this.topic = this.data().deepCopy(this.fields()[4].schema(), other.topic);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue(this.fields()[5], other.start)) {
                this.start = this.data().deepCopy(this.fields()[5].schema(), other.start);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue(this.fields()[6], other.data)) {
                this.data = this.data().deepCopy(this.fields()[6].schema(), other.data);
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
        }

        private Builder(TaskDefinition other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue(this.fields()[0], other.host)) {
                this.host = this.data().deepCopy(this.fields()[0].schema(), other.host);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue(this.fields()[1], other.name)) {
                this.name = this.data().deepCopy(this.fields()[1].schema(), other.name);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue(this.fields()[2], other.action)) {
                this.action = this.data().deepCopy(this.fields()[2].schema(), other.action);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue(this.fields()[3], other.frequency)) {
                this.frequency = this.data().deepCopy(this.fields()[3].schema(), other.frequency);
                this.fieldSetFlags()[3] = true;
            }
            this.frequencyBuilder = null;
            if (Builder.isValidValue(this.fields()[4], other.topic)) {
                this.topic = this.data().deepCopy(this.fields()[4].schema(), other.topic);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue(this.fields()[5], other.start)) {
                this.start = this.data().deepCopy(this.fields()[5].schema(), other.start);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue(this.fields()[6], other.data)) {
                this.data = this.data().deepCopy(this.fields()[6].schema(), other.data);
                this.fieldSetFlags()[6] = true;
            }
        }

        public String getHost() {
            return this.host;
        }

        public Builder setHost(String value) {
            this.validate(this.fields()[0], value);
            this.host = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasHost() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearHost() {
            this.host = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String value) {
            this.validate(this.fields()[1], value);
            this.name = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasName() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearName() {
            this.name = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public DefinitionAction getAction() {
            return this.action;
        }

        public Builder setAction(DefinitionAction value) {
            this.validate(this.fields()[2], value);
            this.action = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasAction() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearAction() {
            this.action = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public TaskFrequency getFrequency() {
            return this.frequency;
        }

        public Builder setFrequency(TaskFrequency value) {
            this.validate(this.fields()[3], value);
            this.frequencyBuilder = null;
            this.frequency = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasFrequency() {
            return this.fieldSetFlags()[3];
        }

        public TaskFrequency.Builder getFrequencyBuilder() {
            if (this.frequencyBuilder == null) {
                if (this.hasFrequency()) {
                    this.setFrequencyBuilder(TaskFrequency.newBuilder(this.frequency));
                } else {
                    this.setFrequencyBuilder(TaskFrequency.newBuilder());
                }
            }
            return this.frequencyBuilder;
        }

        public Builder setFrequencyBuilder(TaskFrequency.Builder value) {
            this.clearFrequency();
            this.frequencyBuilder = value;
            return this;
        }

        public boolean hasFrequencyBuilder() {
            return this.frequencyBuilder != null;
        }

        public Builder clearFrequency() {
            this.frequency = null;
            this.frequencyBuilder = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public String getTopic() {
            return this.topic;
        }

        public Builder setTopic(String value) {
            this.validate(this.fields()[4], value);
            this.topic = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasTopic() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearTopic() {
            this.topic = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public long getStart() {
            return this.start;
        }

        public Builder setStart(long value) {
            this.validate(this.fields()[5], value);
            this.start = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasStart() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearStart() {
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public Map<String, String> getData() {
            return this.data;
        }

        public Builder setData(Map<String, String> value) {
            this.validate(this.fields()[6], value);
            this.data = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasData() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearData() {
            this.data = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        @Override
        public TaskDefinition build() {
            try {
                TaskDefinition record = new TaskDefinition();
                record.host = this.fieldSetFlags()[0] ? this.host : (String)this.defaultValue(this.fields()[0]);
                record.name = this.fieldSetFlags()[1] ? this.name : (String)this.defaultValue(this.fields()[1]);
                DefinitionAction definitionAction = record.action = this.fieldSetFlags()[2] ? this.action : (DefinitionAction)this.defaultValue(this.fields()[2]);
                if (this.frequencyBuilder != null) {
                    try {
                        record.frequency = this.frequencyBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("frequency"));
                        throw e;
                    }
                } else {
                    record.frequency = this.fieldSetFlags()[3] ? this.frequency : (TaskFrequency)this.defaultValue(this.fields()[3]);
                }
                record.topic = this.fieldSetFlags()[4] ? this.topic : (String)this.defaultValue(this.fields()[4]);
                record.start = this.fieldSetFlags()[5] ? this.start : (Long)this.defaultValue(this.fields()[5]);
                record.data = this.fieldSetFlags()[6] ? this.data : (Map)this.defaultValue(this.fields()[6]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException(e);
            }
        }
    }
}

