/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.rpc.router;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.networknt.config.Config;
import com.networknt.config.JsonMapper;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.RpcStartupHookProvider;
import com.networknt.status.Status;
import com.networknt.utility.ModuleRegistry;
import com.networknt.utility.Util;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaHandler
implements MiddlewareHandler {
    static final Logger logger = LoggerFactory.getLogger(SchemaHandler.class);
    static final String REQUEST = "request";
    static final String SCHEMA = "schema";
    static final String DATA = "data";
    static final String CMD = "cmd";
    static final String STATUS_HANDLER_NOT_FOUND = "ERR11200";
    static final String STATUS_REQUEST_BODY_EMPTY = "ERR11201";
    static final String STATUS_METHOD_NOT_ALLOWED = "ERR10008";
    static final String STATUS_REQUEST_CMD_EMPTY = "ERR11202";
    private static final String SPEC_YAML = "spec.yaml";
    private volatile HttpHandler next;
    public static Map<String, Object> services = new HashMap<String, Object>();

    public SchemaHandler() {
        if (logger.isTraceEnabled()) {
            logger.trace("SchemaHandler constructed");
        }
        try {
            Enumeration<URL> schemaResources = SchemaHandler.class.getClassLoader().getResources(SPEC_YAML);
            while (schemaResources.hasMoreElements()) {
                URL url = schemaResources.nextElement();
                if (logger.isDebugEnabled()) {
                    logger.debug("schema file = {}", (Object)url);
                }
                InputStream is = url.openStream();
                try {
                    services.putAll(SchemaHandler.parseYaml(is));
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("services = {}", (Object)Config.getInstance().getMapper().writeValueAsString(services));
            }
        }
        catch (IOException e) {
            logger.error("Error loading spec.yaml files from service jars", e);
            throw new RuntimeException("Error loading spec.yaml files from service jars");
        }
    }

    public static Map<String, Map<String, Object>> parseYaml(InputStream yamlStream) throws IOException {
        List actionsNode;
        ObjectMapper mapper = new ObjectMapper(new YAMLFactory());
        Map rootNode = mapper.readValue(yamlStream, Map.class);
        LinkedHashMap<String, Map<String, Object>> resultMap = new LinkedHashMap<String, Map<String, Object>>();
        String host = (String)rootNode.get("host");
        String service = (String)rootNode.get("service");
        HashMap<String, Map> schemas = new HashMap<String, Map>();
        Map schemasNode = (Map)rootNode.get("schemas");
        if (schemasNode != null) {
            for (Map.Entry entry : schemasNode.entrySet()) {
                schemas.put((String)entry.getKey(), (Map)entry.getValue());
            }
        }
        if ((actionsNode = (List)rootNode.get("action")) != null) {
            for (Map actionNode : actionsNode) {
                Map responseNode;
                Map requestNode;
                String actionName = (String)actionNode.get("name");
                String actionVersion = (String)actionNode.get("version");
                String key = host + "/" + service + "/" + actionName + "/" + actionVersion;
                Boolean skipAuth = (Boolean)actionNode.get("skipAuth") != null ? (Boolean)actionNode.get("skipAuth") : false;
                String scope = (String)actionNode.get("scope");
                LinkedHashMap<String, Object> actionMap = new LinkedHashMap<String, Object>();
                actionMap.put("skipAuth", skipAuth);
                if (scope != null) {
                    actionMap.put("scope", scope);
                }
                if ((requestNode = (Map)actionNode.get(REQUEST)) != null) {
                    String ref;
                    String schemaName;
                    Map resolvedSchema;
                    LinkedHashMap<String, Map> requestMap = new LinkedHashMap<String, Map>();
                    Map schemaRef = (Map)requestNode.get(SCHEMA);
                    if (schemaRef != null && schemaRef.containsKey("$ref") && (resolvedSchema = (Map)schemas.get(schemaName = (ref = (String)schemaRef.get("$ref")).substring(ref.lastIndexOf(47) + 1))) != null) {
                        requestMap.put(SCHEMA, resolvedSchema);
                    }
                    actionMap.put(REQUEST, requestMap);
                }
                if ((responseNode = (Map)actionNode.get("response")) != null) {
                    String ref;
                    String schemaName;
                    Map resolvedSchema;
                    LinkedHashMap<String, Map> responseMap = new LinkedHashMap<String, Map>();
                    Map schemaRef = (Map)responseNode.get(SCHEMA);
                    if (schemaRef != null && schemaRef.containsKey("$ref") && (resolvedSchema = (Map)schemas.get(schemaName = (ref = (String)schemaRef.get("$ref")).substring(ref.lastIndexOf(47) + 1))) != null) {
                        responseMap.put(SCHEMA, resolvedSchema);
                    }
                    actionMap.put("response", responseMap);
                }
                resultMap.put(key, actionMap);
            }
        }
        return resultMap;
    }

    @Override
    public HttpHandler getNext() {
        return this.next;
    }

    @Override
    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void register() {
        ModuleRegistry.registerModule(null, SchemaHandler.class.getName(), null, null);
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("SchemaHandler.handleRequest starts.");
        }
        if (Methods.POST.equals(exchange.getRequestMethod())) {
            exchange.getRequestReceiver().receiveFullString((exchange1, message) -> {
                if (message == null || message.trim().isEmpty()) {
                    this.handleEmptyPostRequest(exchange1);
                    return;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Post method with message = {}", (Object)message);
                }
                this.processRequest(exchange1, message);
            });
        } else if (Methods.GET.equals(exchange.getRequestMethod())) {
            Map<String, Deque<String>> params = exchange.getQueryParameters();
            String cmd = params.get(CMD).getFirst();
            if (cmd == null || cmd.trim().isEmpty()) {
                this.handleMissingGetCommand(exchange);
                return;
            }
            String message2 = URLDecoder.decode(cmd, StandardCharsets.UTF_8);
            if (logger.isDebugEnabled()) {
                logger.debug("Get method with message = {}", (Object)message2);
            }
            this.processRequest(exchange, message2);
        } else {
            this.handleUnsupportedMethod(exchange);
        }
    }

    private void processRequest(HttpServerExchange exchange, String message) {
        Map<String, Object> map = JsonMapper.string2Map(message);
        String serviceId = Util.getServiceId(map);
        logger.debug("serviceId = {}", (Object)serviceId);
        HybridHandler handler = RpcStartupHookProvider.serviceMap.get(serviceId);
        if (handler == null) {
            this.handleMissingHandler(exchange, serviceId);
            return;
        }
        Map data = (Map)map.get(DATA);
        Map serviceMap = (Map)services.get(serviceId);
        Map requestMap = (Map)serviceMap.get(REQUEST);
        ByteBuffer error = handler.validate(serviceId, (Map)requestMap.get(SCHEMA), data);
        if (error != null) {
            exchange.setStatusCode(400);
            exchange.getResponseSender().send(error);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("serviceId = {} serviceMap = {}", (Object)serviceId, (Object)JsonMapper.toJson(serviceMap));
        }
        Map<String, String> auditInfo = exchange.getAttachment(AttachmentConstants.AUDIT_INFO) == null ? new HashMap() : exchange.getAttachment(AttachmentConstants.AUDIT_INFO);
        auditInfo.put("endpoint", serviceId);
        auditInfo.put("hybrid_service_id", serviceId);
        auditInfo.put("hybrid_service_map", (String)((Object)serviceMap));
        auditInfo.put("hybrid_service_data", (String)((Object)data));
        exchange.putAttachment(AttachmentConstants.AUDIT_INFO, auditInfo);
        if (logger.isTraceEnabled()) {
            logger.trace("SchemaHandler.handleRequest ends.");
        }
        try {
            Handler.next(exchange, this.next);
        }
        catch (Exception e) {
            logger.error("Exception:", e);
            exchange.setStatusCode(500);
            exchange.endExchange();
        }
    }

    void completeExchange(ByteBuffer result2, HttpServerExchange exchange) {
        if (result2 == null) {
            exchange.setStatusCode(200);
            exchange.endExchange();
        } else {
            exchange.getResponseSender().send(result2);
        }
    }

    private void handleMissingHandler(HttpServerExchange exchange, String serviceId) {
        logger.error("Handler is not found for serviceId {}", (Object)serviceId);
        Status status = new Status(STATUS_HANDLER_NOT_FOUND, serviceId);
        exchange.setStatusCode(status.getStatusCode());
        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/json");
        exchange.getResponseSender().send(status.toString());
    }

    private void handleEmptyPostRequest(HttpServerExchange exchange) {
        logger.error("Post request without body");
        exchange.getResponseHeaders().add(new HttpString("Content-Type"), "application/json");
        Status status = new Status(STATUS_REQUEST_BODY_EMPTY, new Object[0]);
        exchange.setStatusCode(status.getStatusCode());
        exchange.getResponseSender().send(status.toString());
    }

    private void handleMissingGetCommand(HttpServerExchange exchange) {
        logger.error("Get param cmd is empty for light-hybrid-4j");
        exchange.getResponseHeaders().add(new HttpString("Content-Type"), "application/json");
        Status status = new Status(STATUS_REQUEST_CMD_EMPTY, new Object[0]);
        exchange.setStatusCode(status.getStatusCode());
        exchange.getResponseSender().send(status.toString());
    }

    private void handleUnsupportedMethod(HttpServerExchange exchange) {
        exchange.getResponseHeaders().add(new HttpString("Content-Type"), "application/json");
        String method = exchange.getRequestMethod().toString();
        String path = exchange.getRequestPath();
        Status status = new Status(STATUS_METHOD_NOT_ALLOWED, method, path);
        exchange.setStatusCode(status.getStatusCode());
        exchange.getResponseSender().send(status.toString());
    }
}

