/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.portal.registry.client;

import com.networknt.client.Http2Client;
import com.networknt.config.Config;
import com.networknt.config.JsonMapper;
import com.networknt.portal.registry.PortalRegistryConfig;
import com.networknt.portal.registry.PortalRegistryService;
import com.networknt.portal.registry.client.PortalRegistryClient;
import com.networknt.utility.StringUtils;
import io.undertow.UndertowOptions;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.OptionMap;

public class PortalRegistryClientImpl
implements PortalRegistryClient {
    private static final Logger logger = LoggerFactory.getLogger(PortalRegistryClientImpl.class);
    private static final PortalRegistryConfig config = (PortalRegistryConfig)Config.getInstance().getJsonObjectConfig("portal-registry", PortalRegistryConfig.class);
    private static final int UNUSUAL_STATUS_CODE = 300;
    private Http2Client client = Http2Client.getInstance();
    private OptionMap optionMap;
    private URI uri;

    public PortalRegistryClientImpl() {
        String portalUrl = config.getPortalUrl().toLowerCase();
        this.optionMap = OptionMap.create(UndertowOptions.ENABLE_HTTP2, true);
        logger.debug("url = {}", (Object)portalUrl);
        try {
            this.uri = new URI(portalUrl);
        }
        catch (URISyntaxException e) {
            logger.error("Invalid URI " + portalUrl, e);
            throw new RuntimeException("Invalid URI " + portalUrl, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkPass(PortalRegistryService service, String token) {
        String key = service.getTag() == null ? service.getServiceId() : service.getServiceId() + "|" + service.getTag();
        String checkId = String.format("%s:%s:%s", key, service.getAddress(), service.getPort());
        if (logger.isTraceEnabled()) {
            logger.trace("checkPass id = {}", (Object)checkId);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", checkId);
        map.put("pass", true);
        map.put("checkInterval", config.getCheckInterval());
        String path = "/services/check";
        ClientConnection connection = null;
        try {
            connection = this.client.borrowConnection(this.uri, Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, this.optionMap).get();
            AtomicReference<ClientResponse> reference = this.send(connection, Methods.PUT, path, token, JsonMapper.toJson(map));
            int statusCode = reference.get().getResponseCode();
            if (statusCode >= 300) {
                logger.error("checkPass error: {} : {}", (Object)statusCode, (Object)reference.get().getAttachment(Http2Client.RESPONSE_BODY));
            }
            this.client.returnConnection(connection);
        }
        catch (Exception e) {
            logger.error("CheckPass request exception", e);
        }
        finally {
            this.client.returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkFail(PortalRegistryService service, String token) {
        String key = service.getTag() == null ? service.getServiceId() : service.getServiceId() + "|" + service.getTag();
        String checkId = String.format("%s:%s:%s", key, service.getAddress(), service.getPort());
        if (logger.isTraceEnabled()) {
            logger.trace("checkFail id = {}", (Object)checkId);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", checkId);
        map.put("pass", false);
        map.put("checkInterval", config.getCheckInterval());
        String path = "/services/check";
        ClientConnection connection = null;
        try {
            connection = this.client.borrowConnection(this.uri, Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, this.optionMap).get();
            AtomicReference<ClientResponse> reference = this.send(connection, Methods.PUT, path, token, JsonMapper.toJson(map));
            int statusCode = reference.get().getResponseCode();
            if (statusCode >= 300) {
                logger.error("checkFail error: {} : {}", (Object)statusCode, (Object)reference.get().getAttachment(Http2Client.RESPONSE_BODY));
            }
            this.client.returnConnection(connection);
        }
        catch (Exception e) {
            logger.error("CheckFail request exception", e);
        }
        finally {
            this.client.returnConnection(connection);
        }
    }

    @Override
    public void registerService(PortalRegistryService service, String token) {
        String json = service.toString();
        String path = "/services";
        ClientConnection connection = null;
        try {
            connection = this.client.borrowConnection(this.uri, Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, this.optionMap).get();
            AtomicReference<ClientResponse> reference = this.send(connection, Methods.POST, path, token, json);
            int statusCode = reference.get().getResponseCode();
            if (statusCode >= 300) {
                logger.error("Failed to register on portal controller: {} : {}", (Object)statusCode, (Object)reference.get().getAttachment(Http2Client.RESPONSE_BODY));
                System.out.println("Error registerService: " + reference.get().getAttachment(Http2Client.RESPONSE_BODY));
                throw new Exception("Failed to register on portal controller: " + statusCode);
            }
            this.client.returnConnection(connection);
        }
        catch (Exception e) {
            try {
                logger.error("Failed to register on portal controller json = " + json + " uri = " + String.valueOf(this.uri), e);
                throw new RuntimeException(e.getMessage());
            }
            catch (Throwable throwable) {
                this.client.returnConnection(connection);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterService(PortalRegistryService service, String token) {
        String path = "/services?serviceId=" + service.getServiceId() + "&protocol=" + service.getProtocol() + "&address=" + service.getAddress() + "&port=" + service.getPort() + "&checkInterval=" + config.getCheckInterval();
        if (service.getTag() != null) {
            path = path + "&tag=" + service.getTag();
        }
        System.out.println("de-register path = " + path);
        ClientConnection connection = null;
        try {
            connection = this.client.borrowConnection(this.uri, Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, this.optionMap).get();
            AtomicReference<ClientResponse> reference = this.send(connection, Methods.DELETE, path, token, null);
            int statusCode = reference.get().getResponseCode();
            if (statusCode >= 300) {
                logger.error("Failed to unregister on portal controller, body = {}", (Object)reference.get().getAttachment(Http2Client.RESPONSE_BODY));
            }
            this.client.returnConnection(connection);
        }
        catch (Exception e) {
            logger.error("Failed to unregister on portal controller, Exception:", e);
        }
        finally {
            this.client.returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Map<String, Object>> lookupHealthService(String serviceId, String tag, String token) {
        List<Map<String, Object>> services = null;
        if (StringUtils.isBlank(serviceId)) {
            return null;
        }
        ClientConnection connection = null;
        String path = "/services/lookup?serviceId=" + serviceId;
        if (tag != null) {
            path = path + "&tag=" + tag;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("path = {}", (Object)path);
        }
        try {
            connection = this.client.borrowConnection(this.uri, Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, this.optionMap).get();
            AtomicReference<ClientResponse> reference = this.send(connection, Methods.GET, path, token, null);
            int statusCode = reference.get().getResponseCode();
            if (statusCode >= 300) {
                logger.error("Failed to look up service on Portal with serviceId {} tag {} response code {} and body {}", serviceId, tag, statusCode, reference.get().getAttachment(Http2Client.RESPONSE_BODY));
                throw new Exception("Failed to lookup service on Portal: " + statusCode);
            }
            String body = reference.get().getAttachment(Http2Client.RESPONSE_BODY);
            services = JsonMapper.string2List(body);
            this.client.returnConnection(connection);
        }
        catch (Exception e) {
            logger.error("Exception:", e);
        }
        finally {
            this.client.returnConnection(connection);
        }
        return services;
    }

    AtomicReference<ClientResponse> send(ClientConnection connection, HttpString method, String path, String token, String json) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference<ClientResponse> reference = new AtomicReference<ClientResponse>();
        ClientRequest request = new ClientRequest().setMethod(method).setPath(path);
        request.getRequestHeaders().put(Headers.HOST, "localhost");
        if (token != null) {
            request.getRequestHeaders().put(Headers.AUTHORIZATION, token);
        }
        logger.trace("The request sent to controller: {} = request header: {}, request body is empty", (Object)this.uri.toString(), (Object)request.toString());
        if (StringUtils.isBlank(json)) {
            connection.sendRequest(request, this.client.createClientCallback(reference, latch));
        } else {
            request.getRequestHeaders().put(Headers.TRANSFER_ENCODING, "chunked");
            request.getRequestHeaders().put(Headers.CONTENT_TYPE, "application/json");
            connection.sendRequest(request, this.client.createClientCallback(reference, latch, json));
        }
        latch.await();
        logger.trace("The response got from controller: {} = {}", (Object)this.uri.toString(), (Object)reference.get().toString());
        return reference;
    }
}

