/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.monad;

import com.networknt.monad.Result;
import com.networknt.status.Status;
import java.util.NoSuchElementException;
import java.util.Optional;

public final class Success<T>
implements Result<T> {
    public static final Result<Void> SUCCESS = new Success<Object>(null);
    public static final Result OPTIONAL_SUCCESS = Success.ofOptional(null);
    private final T result;

    static <T> Result<Optional<T>> emptyOptional() {
        return OPTIONAL_SUCCESS;
    }

    public static <T> Result<T> of(T result2) {
        return new Success<T>(result2);
    }

    public static <T> Result<Optional<T>> ofOptional(T result2) {
        return new Success<Optional<T>>(Optional.ofNullable(result2));
    }

    private Success(T result2) {
        this.result = result2;
    }

    @Override
    public boolean isSuccess() {
        return true;
    }

    @Override
    public Status getError() {
        throw new NoSuchElementException("There is no error in Success");
    }

    @Override
    public T getResult() {
        return this.result;
    }

    public String toString() {
        String value = this.result != null ? this.result.toString() : "";
        return String.format("Success[%s]", value);
    }
}

