/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.mask;

import com.fasterxml.jackson.databind.JsonNode;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.networknt.config.Config;
import com.networknt.utility.ModuleRegistry;
import com.networknt.utility.StringUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.owasp.encoder.Encode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mask {
    static Map<String, Pattern> patternCache = new ConcurrentHashMap<String, Pattern>();
    private static final String MASK_CONFIG = "mask";
    public static final String MASK_REPLACEMENT_CHAR = "*";
    public static final String MASK_TYPE_STRING = "string";
    public static final String MASK_TYPE_REGEX = "regex";
    public static final String MASK_TYPE_JSON = "json";
    static final Logger logger = LoggerFactory.getLogger(Mask.class);
    private static final Map<String, Object> config = Config.getInstance().getJsonMapConfigNoCache("mask");

    public static String maskString(String input, String key) {
        Map keyConfig;
        if (input == null) {
            return null;
        }
        String output = input;
        Map stringConfig = (Map)config.get(MASK_TYPE_STRING);
        if (stringConfig != null && (keyConfig = (Map)stringConfig.get(key)) != null) {
            Set patterns = keyConfig.keySet();
            for (String pattern : patterns) {
                output = output.replaceAll(pattern, (String)keyConfig.get(pattern));
            }
        }
        return output;
    }

    public static String maskRegex(String input, String key, String name2) {
        String regex;
        Map keyConfig;
        Map regexConfig = (Map)config.get(MASK_TYPE_REGEX);
        if (regexConfig != null && (keyConfig = (Map)regexConfig.get(key)) != null && (regex = (String)keyConfig.get(name2)) != null && regex.length() > 0) {
            return Mask.replaceWithMask(input, MASK_REPLACEMENT_CHAR.charAt(0), regex);
        }
        return input;
    }

    private static String replaceWithMask(String stringToBeMasked, char maskingChar, String regex) {
        if (stringToBeMasked == null || stringToBeMasked.length() == 0) {
            return stringToBeMasked;
        }
        String replacementString = "";
        if (!StringUtils.isEmpty(regex)) {
            try {
                Matcher matcher;
                Pattern pattern = patternCache.get(regex);
                if (pattern == null) {
                    pattern = Pattern.compile(regex);
                    patternCache.put(regex, pattern);
                }
                if ((matcher = pattern.matcher(stringToBeMasked)).matches()) {
                    for (int i = 0; i < matcher.groupCount(); ++i) {
                        String currentGroup = matcher.group(i + 1);
                        String padGroup = StringUtils.rightPad("", currentGroup.length(), maskingChar);
                        stringToBeMasked = StringUtils.replace(stringToBeMasked, currentGroup, padGroup, 1);
                    }
                    replacementString = stringToBeMasked;
                }
            }
            catch (Exception e) {
                replacementString = StringUtils.rightPad("", stringToBeMasked.length(), maskingChar);
            }
        } else {
            replacementString = StringUtils.rightPad("", stringToBeMasked.length(), maskingChar);
        }
        return replacementString;
    }

    public static String maskJson(String input, String key) {
        if (input == null) {
            return null;
        }
        DocumentContext ctx = JsonPath.parse(input);
        return Mask.maskJson(ctx, key);
    }

    public static String maskJson(InputStream input, String key) {
        if (input == null) {
            return null;
        }
        DocumentContext ctx = JsonPath.parse(input);
        return Mask.maskJson(ctx, key);
    }

    public static String maskJson(Object input, String key) {
        if (input == null) {
            return null;
        }
        DocumentContext ctx = JsonPath.parse(input);
        return Mask.maskJson(ctx, key);
    }

    public static String maskJson(DocumentContext ctx, String key) {
        if (ctx == null) {
            return null;
        }
        Map jsonConfig = (Map)config.get(MASK_TYPE_JSON);
        if (jsonConfig != null) {
            Map patternMap = (Map)jsonConfig.get(key);
            if (patternMap != null) {
                Object configNode = Config.getInstance().getMapper().valueToTree(patternMap);
                Iterator<Map.Entry<String, JsonNode>> iterator2 = ((JsonNode)configNode).fields();
                while (iterator2.hasNext()) {
                    Map.Entry<String, JsonNode> entry = iterator2.next();
                    Mask.applyMask(entry, ctx);
                }
                return ctx.jsonString();
            }
            logger.warn("mask.json doesn't contain the key {} ", (Object)Encode.forJava(key));
        }
        return ctx.jsonString();
    }

    private static void applyMask(Map.Entry<String, JsonNode> entry, DocumentContext ctx) {
        String jsonPath = entry.getKey();
        try {
            Object value = ctx.read(jsonPath, new Predicate[0]);
            if (!(value instanceof String || value instanceof Integer || value instanceof List)) {
                logger.error("The value specified by path {} cannot be masked", (Object)jsonPath);
            } else if (!(value instanceof List)) {
                ctx.set(jsonPath, Mask.replaceWithMask(value.toString(), MASK_REPLACEMENT_CHAR.charAt(0), entry.getValue().asText()), new Predicate[0]);
            } else if (value instanceof List) {
                for (Object ele : (List)value) {
                    if (ele instanceof String) continue;
                    logger.error("json path: {} is incorrect, cannot mask an object", (Object)jsonPath);
                    return;
                }
                Mask.maskList(ctx, jsonPath, entry.getValue().asText());
            }
        }
        catch (PathNotFoundException e) {
            logger.warn("JsonPath {} could not be found.", (Object)jsonPath);
        }
    }

    private static void maskList(DocumentContext ctx, String jsonPath, String expression) {
        ctx.configuration().addOptions(Option.AS_PATH_LIST);
        Configuration conf = Configuration.builder().options(Option.AS_PATH_LIST).build();
        DocumentContext context = JsonPath.using(conf).parse(ctx.jsonString());
        List pathList = (List)context.read(jsonPath, new Predicate[0]);
        if (pathList != null && pathList.size() == 1) {
            String path = (String)pathList.get(0);
            Object readValues = ctx.read(path, new Predicate[0]);
            List values2 = new ArrayList();
            if (readValues instanceof String) {
                values2.add(readValues);
            } else {
                values2 = (List)ctx.read(path, new Predicate[0]);
            }
            ArrayList maskedValue = new ArrayList();
            values2.forEach(o -> maskedValue.add(Mask.replaceWithMask(o.toString(), MASK_REPLACEMENT_CHAR.charAt(0), expression)));
            ctx.set(path, maskedValue.size() == 1 ? maskedValue.get(0) : maskedValue, new Predicate[0]);
        } else {
            for (String path : Optional.ofNullable(pathList).orElse(Collections.emptyList())) {
                Object value = ctx.read(path, new Predicate[0]);
                ctx.set(path, Mask.replaceWithMask(value.toString(), MASK_REPLACEMENT_CHAR.charAt(0), expression), new Predicate[0]);
            }
        }
    }

    static {
        ModuleRegistry.registerModule(MASK_CONFIG, Mask.class.getName(), Config.getNoneDecryptedInstance().getJsonMapConfigNoCache(MASK_CONFIG), null);
    }
}

