/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.kafka.producer;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class CompletableFutures {
    private CompletableFutures() {
    }

    public static <T> CompletableFuture<List<T>> allAsList(List<CompletableFuture<T>> futures) {
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(none -> futures.stream().map(CompletableFuture::join).collect(Collectors.toList()));
    }

    public static <T> CompletableFuture<T> failedFuture(Throwable exception) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(exception);
        return future;
    }

    public static <T, E extends Throwable> CompletableFuture<T> catchingCompose(CompletableFuture<T> future, Class<E> exceptionClass, Function<? super E, ? extends CompletableFuture<T>> handler) {
        return ((CompletableFuture)future.handle((value, error) -> {
            if (error == null) {
                return CompletableFuture.completedFuture(value);
            }
            if (exceptionClass.isInstance(error.getCause())) {
                return (CompletableFuture)handler.apply((Object)exceptionClass.cast(error.getCause()));
            }
            if (error instanceof CompletionException) {
                throw (CompletionException)error;
            }
            throw new AssertionError(error);
        })).thenCompose(wrapped -> wrapped);
    }
}

