/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.kafka.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.networknt.utility.ObjectUtils;
import java.nio.charset.StandardCharsets;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(value={"headers"})
public interface StateStoreValue {
    public static final Logger logger = LoggerFactory.getLogger(StateStoreValue.class);

    public void setCorrelationId(String var1);

    public String getCorrelationId();

    public void setTraceabilityId(String var1);

    public String getTraceabilityId();

    default public void setHeaders(Headers headers) {
        if (!ObjectUtils.isEmpty(headers.lastHeader("X-Correlation-Id"))) {
            this.setCorrelationId(new String(headers.lastHeader("X-Correlation-Id").value(), StandardCharsets.UTF_8));
        } else {
            logger.error("X-Correlation-Id is not present in headers");
        }
        if (!ObjectUtils.isEmpty(headers.lastHeader("X-Traceability-Id"))) {
            this.setTraceabilityId(new String(headers.lastHeader("X-Traceability-Id").value(), StandardCharsets.UTF_8));
        } else {
            logger.error("X-Traceability-Id is not present in headers");
        }
    }

    default public Headers getHeaders() {
        RecordHeaders headers = new RecordHeaders();
        headers.add("X-Correlation-Id", this.getCorrelationId().getBytes(StandardCharsets.UTF_8));
        headers.add("X-Traceability-Id", this.getTraceabilityId().getBytes(StandardCharsets.UTF_8));
        return headers;
    }
}

