/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.kafka.entity;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class KsqlDbPullQueryRequest {
    private OffsetEnum offset;
    private QueryType queryType;
    private Boolean deserializationError;
    private Boolean tableScanEnable;
    private String query;
    private Map<String, Object> properties = new HashMap<String, Object>();

    @JsonProperty(value="offset")
    public OffsetEnum getOffset() {
        return this.offset;
    }

    public void setOffset(String offset) {
        this.offset = OffsetEnum.fromValue(offset);
        this.properties.put("auto.offset.reset", offset);
    }

    @JsonProperty(value="queryType")
    public QueryType getQueryType() {
        return this.queryType;
    }

    public void setQueryType(String queryType) {
        this.queryType = QueryType.fromValue(queryType);
    }

    @JsonProperty(value="deserializationError")
    public Boolean getDeserializationError() {
        return this.deserializationError;
    }

    public void setDeserializationError(Boolean deserializationError) {
        this.deserializationError = deserializationError;
        this.properties.put("fail.on.deserialization.error", deserializationError);
    }

    @JsonProperty(value="tableScanEnable")
    public Boolean getTableScanEnable() {
        return this.tableScanEnable;
    }

    public void setTableScanEnable(Boolean tableScanEnable) {
        this.tableScanEnable = tableScanEnable;
        this.properties.put("ksql.query.pull.table.scan.enabled", tableScanEnable);
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    @JsonProperty(value="query")
    public String getQuery() {
        return this.query.replace("\\'", "'");
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KsqlDbPullQueryRequest KsqlDbPullQueryRequest2 = (KsqlDbPullQueryRequest)o;
        return Objects.equals((Object)this.offset, (Object)KsqlDbPullQueryRequest2.offset) && Objects.equals(this.deserializationError, KsqlDbPullQueryRequest2.deserializationError) && Objects.equals(this.query, KsqlDbPullQueryRequest2.query);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.offset, this.deserializationError, this.query});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KsqlDbPullQueryRequest {\n");
        sb.append("    offset: ").append(this.toIndentedString((Object)this.offset)).append("\n");
        sb.append("    deserializationError: ").append(this.toIndentedString(this.deserializationError)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OffsetEnum {
        EARLIEST("earliest"),
        LATEST("latest");

        private final String value;

        private OffsetEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static OffsetEnum fromValue(String text2) {
            for (OffsetEnum b : OffsetEnum.values()) {
                if (!String.valueOf(b.value).equals(text2)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum QueryType {
        PULL("pull"),
        PUSH("push");

        private final String value;

        private QueryType(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static QueryType fromValue(String text2) {
            for (QueryType b : QueryType.values()) {
                if (!String.valueOf(b.value).equals(text2)) continue;
                return b;
            }
            return null;
        }
    }
}

